/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.store;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.intercom.android.sdk.store.ChangeSubscriber;
import io.intercom.android.sdk.store.Store;

class TwoParamChangeSubscriber<S, T1, T2>
implements Store.Subscriber<S> {
    private final Store.Selector<S, T1> selector1;
    private final Store.Selector<S, T2> selector2;
    final Store.Subscriber2<T1, T2> subscriber;
    private final Handler mainHandler;
    @Nullable
    private T1 last1 = null;
    @Nullable
    private T2 last2 = null;

    TwoParamChangeSubscriber(Store.Selector<S, T1> selector1, Store.Selector<S, T2> selector2, Store.Subscriber2<T1, T2> subscriber) {
        this(selector1, selector2, subscriber, new Handler(Looper.getMainLooper()));
    }

    @VisibleForTesting
    TwoParamChangeSubscriber(Store.Selector<S, T1> selector1, Store.Selector<S, T2> selector2, Store.Subscriber2<T1, T2> subscriber, Handler mainHandler) {
        this.selector1 = selector1;
        this.selector2 = selector2;
        this.subscriber = subscriber;
        this.mainHandler = mainHandler;
    }

    @Override
    public void onStateChange(S state) {
        final T1 current1 = this.selector1.transform(state);
        final T2 current2 = this.selector2.transform(state);
        if (this.last1 != current1 || this.last2 != current2) {
            this.last1 = current1;
            this.last2 = current2;
            ChangeSubscriber.runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    TwoParamChangeSubscriber.this.subscriber.onStateChange(current1, current2);
                }
            }, this.mainHandler);
        }
    }
}

