/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.content.Context;
import androidx.compose.runtime.internal.StabilityInferred;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.utilities.Phrase;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0007J \u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J \u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u000f"}, d2={"Lio/intercom/android/sdk/utilities/GroupConversationTextFormatter;", "", "()V", "groupConversationLabel", "", "context", "Landroid/content/Context;", "otherParticipants", "", "Lio/intercom/android/sdk/models/Participant;", "groupConversationSubtitle", "firstName", "", "", "groupConversationTitle", "intercom-sdk-base_release"})
@StabilityInferred(parameters=1)
public final class GroupConversationTextFormatter {
    @NotNull
    public static final GroupConversationTextFormatter INSTANCE = new GroupConversationTextFormatter();
    public static final int $stable;

    private GroupConversationTextFormatter() {
    }

    @JvmStatic
    @NotNull
    public static final CharSequence groupConversationTitle(@NotNull String firstName, int otherParticipants, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)firstName, (String)"firstName");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return otherParticipants == 1 ? (CharSequence)(firstName + context.getString(R.string.intercom_group_conversation_1_other_participant_count_short)) : (otherParticipants > 1 ? (CharSequence)(firstName + Phrase.from(context, R.string.intercom_group_conversation_multiple_other_participant_count_short).put("other_participant_count", otherParticipants).format()) : (CharSequence)firstName);
    }

    @JvmStatic
    @NotNull
    public static final CharSequence groupConversationSubtitle(@NotNull String firstName, int otherParticipants, @NotNull Context context) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)firstName, (String)"firstName");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (otherParticipants == 1) {
            CharSequence charSequence2 = Phrase.from(context, R.string.intercom_name_and_1_other).put("name", firstName).format();
            Intrinsics.checkNotNull((Object)charSequence2);
            charSequence = charSequence2;
        } else if (otherParticipants > 1) {
            CharSequence charSequence3 = Phrase.from(context, R.string.intercom_name_and_x_others).put("name", firstName).put("count", otherParticipants).format();
            Intrinsics.checkNotNull((Object)charSequence3);
            charSequence = charSequence3;
        } else {
            charSequence = firstName;
        }
        return charSequence;
    }

    @JvmStatic
    @NotNull
    public static final CharSequence groupConversationLabel(@NotNull Context context, @NotNull List<? extends Participant> otherParticipants) {
        Phrase phrase;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(otherParticipants, (String)"otherParticipants");
        int otherParticipantsSize = otherParticipants.size();
        switch (otherParticipantsSize) {
            case 1: {
                String string2 = ((Participant)CollectionsKt.first(otherParticipants)).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                if (!StringsKt.isBlank((CharSequence)string2)) {
                    phrase = Phrase.from(context, R.string.intercom_group_conversation_name_also_participating).put("participant_name", ((Participant)CollectionsKt.first(otherParticipants)).getName());
                    break;
                }
                phrase = Phrase.from(context, R.string.intercom_group_conversation_one_person_also_participating);
                break;
            }
            case 2: {
                String string3 = ((Participant)CollectionsKt.first(otherParticipants)).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                if (!StringsKt.isBlank((CharSequence)string3)) {
                    phrase = Phrase.from(context, R.string.intercom_group_conversation_name_and_1_other_also_particiapting).put("participant_name", ((Participant)CollectionsKt.first(otherParticipants)).getName());
                    break;
                }
                phrase = Phrase.from(context, R.string.intercom_group_conversation_multiple_person_also_participating).put("other_participant_count", otherParticipantsSize);
                break;
            }
            default: {
                String string4 = ((Participant)CollectionsKt.first(otherParticipants)).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
                phrase = !StringsKt.isBlank((CharSequence)string4) ? Phrase.from(context, R.string.intercom_group_conversation_name_and_multiple_others_also_participating).put("participant_name", ((Participant)CollectionsKt.first(otherParticipants)).getName()).put("other_participant_count", otherParticipantsSize - 1) : Phrase.from(context, R.string.intercom_group_conversation_multiple_person_also_participating).put("other_participant_count", otherParticipantsSize);
            }
        }
        CharSequence charSequence = phrase.format();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"format(...)");
        return charSequence;
    }
}

