/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.store;

import io.intercom.android.sdk.actions.Action;
import io.intercom.android.sdk.models.carousel.Carousel;
import io.intercom.android.sdk.models.events.failure.FetchCarouselFailedEvent;
import io.intercom.android.sdk.state.ProgrammaticCarouselState;
import io.intercom.android.sdk.store.Store;

public class ProgrammaticCarouselStateReducer
implements Store.Reducer<ProgrammaticCarouselState> {
    static final ProgrammaticCarouselState INITIAL_STATE = ProgrammaticCarouselState.Idle.create();

    @Override
    public ProgrammaticCarouselState reduce(Action<?> action, ProgrammaticCarouselState currentState) {
        switch (action.type()) {
            case PROGRAMMATIC_CAROUSEL_LOADING: {
                String carouselId = (String)action.value();
                return ProgrammaticCarouselState.Loading.create(carouselId);
            }
            case PROGRAMMATIC_CAROUSEL_SUCCESS: {
                Carousel carousel = (Carousel)action.value();
                return ProgrammaticCarouselState.Success.create(carousel);
            }
            case PROGRAMMATIC_CAROUSEL_ERROR: {
                FetchCarouselFailedEvent failedEvent = (FetchCarouselFailedEvent)action.value();
                return ProgrammaticCarouselState.Error.create(failedEvent.carouselId(), failedEvent.errorObject().getStatusCode());
            }
            case CAROUSEL_DISMISSED: {
                return INITIAL_STATE;
            }
        }
        return currentState;
    }
}

