/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.m5.home.reducers;

import androidx.compose.runtime.internal.StabilityInferred;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.helpcenter.utils.networking.NetworkResponse;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.m5.components.ErrorState;
import io.intercom.android.sdk.m5.components.avatar.AvatarWrapper;
import io.intercom.android.sdk.m5.components.intercombadge.IntercomBadgeLocation;
import io.intercom.android.sdk.m5.components.intercombadge.IntercomBadgeState;
import io.intercom.android.sdk.m5.components.intercombadge.IntercomBadgeStateReducer;
import io.intercom.android.sdk.m5.components.intercombadge.IntercomLinkSolution;
import io.intercom.android.sdk.m5.data.IntercomDataLayer;
import io.intercom.android.sdk.m5.home.data.HomeCardType;
import io.intercom.android.sdk.m5.home.data.HomeCards;
import io.intercom.android.sdk.m5.home.data.HomeV2Response;
import io.intercom.android.sdk.m5.home.reducers.HomeHeaderStateReducerKt;
import io.intercom.android.sdk.m5.home.states.HomeClientState;
import io.intercom.android.sdk.m5.home.states.HomeUiState;
import io.intercom.android.sdk.models.ActiveBot;
import io.intercom.android.sdk.models.Avatar;
import io.intercom.android.sdk.models.OpenMessengerResponse;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.models.TeamPresence;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B/\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ#\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0003H\u0000\u00a2\u0006\u0002\b\u0010J&\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/intercom/android/sdk/m5/home/reducers/HomeReducer;", "", "config", "Lkotlin/Function0;", "Lio/intercom/android/sdk/identity/AppConfig;", "badgeStateReducer", "Lio/intercom/android/sdk/m5/components/intercombadge/IntercomBadgeStateReducer;", "intercomDataLayer", "Lio/intercom/android/sdk/m5/data/IntercomDataLayer;", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lio/intercom/android/sdk/m5/data/IntercomDataLayer;)V", "computeUiState", "Lio/intercom/android/sdk/m5/home/states/HomeUiState;", "homeClientState", "Lio/intercom/android/sdk/m5/home/states/HomeClientState;", "onRetryClicked", "", "computeUiState$intercom_sdk_base_release", "reduceHomeCards", "", "Lio/intercom/android/sdk/m5/home/data/HomeCards;", "homeCards", "newConversationCta", "Lio/intercom/android/sdk/models/OpenMessengerResponse$NewConversationData;", "intercom-sdk-base_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nHomeReducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HomeReducer.kt\nio/intercom/android/sdk/m5/home/reducers/HomeReducer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,107:1\n827#2:108\n855#2,2:109\n1557#2:111\n1628#2,3:112\n1557#2:116\n1628#2,3:117\n1#3:115\n*S KotlinDebug\n*F\n+ 1 HomeReducer.kt\nio/intercom/android/sdk/m5/home/reducers/HomeReducer\n*L\n53#1:108\n53#1:109,2\n58#1:111\n58#1:112,3\n90#1:116\n90#1:117,3\n*E\n"})
public final class HomeReducer {
    @NotNull
    private final Function0<AppConfig> config;
    @NotNull
    private final Function0<IntercomBadgeStateReducer> badgeStateReducer;
    @NotNull
    private final IntercomDataLayer intercomDataLayer;
    public static final int $stable = 8;

    public HomeReducer(@NotNull Function0<AppConfig> config, @NotNull Function0<IntercomBadgeStateReducer> badgeStateReducer, @NotNull IntercomDataLayer intercomDataLayer) {
        Intrinsics.checkNotNullParameter(config, (String)"config");
        Intrinsics.checkNotNullParameter(badgeStateReducer, (String)"badgeStateReducer");
        Intrinsics.checkNotNullParameter((Object)intercomDataLayer, (String)"intercomDataLayer");
        this.config = config;
        this.badgeStateReducer = badgeStateReducer;
        this.intercomDataLayer = intercomDataLayer;
    }

    public /* synthetic */ HomeReducer(Function0 function0, Function0 function02, IntercomDataLayer intercomDataLayer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function0 = 1.INSTANCE;
        }
        if ((n & 2) != 0) {
            function02 = 2.INSTANCE;
        }
        if ((n & 4) != 0) {
            IntercomDataLayer intercomDataLayer2 = Injector.get().getDataLayer();
            Intrinsics.checkNotNullExpressionValue((Object)intercomDataLayer2, (String)"getDataLayer(...)");
            intercomDataLayer = intercomDataLayer2;
        }
        this((Function0<AppConfig>)function0, (Function0<IntercomBadgeStateReducer>)function02, intercomDataLayer);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final HomeUiState computeUiState$intercom_sdk_base_release(@NotNull HomeClientState homeClientState, @NotNull Function0<Unit> onRetryClicked) {
        HomeUiState homeUiState;
        Intrinsics.checkNotNullParameter((Object)homeClientState, (String)"homeClientState");
        Intrinsics.checkNotNullParameter(onRetryClicked, (String)"onRetryClicked");
        OpenMessengerResponse openMessengerResponse = homeClientState.getOpenMessengerResponseData();
        OpenMessengerResponse.NewConversationData newConversationCta = openMessengerResponse != null ? openMessengerResponse.getNewConversationData() : null;
        NetworkResponse<HomeV2Response> networkResponse = homeClientState.getHomeResponse();
        if (networkResponse instanceof NetworkResponse.ClientError ? true : networkResponse instanceof NetworkResponse.ServerError) {
            homeUiState = new HomeUiState.Error(IntercomBadgeState.Hidden.INSTANCE, new ErrorState.WithoutCTA(0, 0, null, 7, null), HomeHeaderStateReducerKt.computeErrorHeader(((AppConfig)this.config.invoke()).getConfigModules()));
        } else if (networkResponse instanceof NetworkResponse.NetworkError) {
            homeUiState = new HomeUiState.Error(IntercomBadgeState.Hidden.INSTANCE, new ErrorState.WithCTA(0, 0, null, 0, onRetryClicked, 15, null), HomeHeaderStateReducerKt.computeErrorHeader(((AppConfig)this.config.invoke()).getConfigModules()));
        } else if (networkResponse instanceof NetworkResponse.Success) {
            AvatarWrapper avatarWrapper;
            Participant.Builder builder;
            Collection<AvatarWrapper> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object it;
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv;
            Object object = this.reduceHomeCards(((HomeV2Response)((NetworkResponse.Success)networkResponse).getBody()).getCards(), newConversationCta);
            IntercomBadgeState intercomBadgeState = ((IntercomBadgeStateReducer)this.badgeStateReducer.invoke()).computeIntercomBadgeState(IntercomBadgeLocation.Home.INSTANCE, IntercomLinkSolution.LIVE_CHAT);
            boolean $i$f$filterNot = false;
            Participant participant = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                it = (HomeCards)element$iv$iv;
                boolean bl = false;
                if (it instanceof HomeCards.HomeNewConversationData && ((HomeCards.HomeNewConversationData)it).getPreventMultipleInboundConversationsEnabled() && !((Collection)((HomeCards.HomeNewConversationData)it).getOpenInboundConversationsIds()).isEmpty()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterNot$iv = ((TeamPresence)this.intercomDataLayer.getTeamPresence().getValue()).getBuiltActiveAdmins();
            List list = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterNotTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Participant)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Avatar avatar = ((Participant)it).getAvatar();
                Intrinsics.checkNotNullExpressionValue((Object)avatar, (String)"getAvatar(...)");
                Boolean bl2 = ((Participant)it).isBot();
                Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"isBot(...)");
                collection.add(new AvatarWrapper(avatar, bl2, null, null, null, false, false, 124, null));
            }
            collection = (List)destination$iv$iv;
            IntercomBadgeState intercomBadgeState2 = intercomBadgeState;
            List list2 = list;
            Collection collection2 = collection;
            object = ((TeamPresence)this.intercomDataLayer.getTeamPresence().getValue()).getActiveBot();
            if (object != null && (builder = ((ActiveBot)object).getParticipant()) != null && (participant = builder.build()) != null) {
                void it2;
                Participant $i$f$mapTo2 = participant;
                collection = collection2;
                list = list2;
                intercomBadgeState = intercomBadgeState2;
                boolean bl = false;
                Avatar avatar = it2.getAvatar();
                Intrinsics.checkNotNullExpressionValue((Object)avatar, (String)"getAvatar(...)");
                Boolean bl3 = it2.isBot();
                Intrinsics.checkNotNullExpressionValue((Object)bl3, (String)"isBot(...)");
                AvatarWrapper avatarWrapper2 = new AvatarWrapper(avatar, bl3, null, null, null, false, false, 124, null);
                intercomBadgeState2 = intercomBadgeState;
                list2 = list;
                collection2 = collection;
                avatarWrapper = avatarWrapper2;
            } else {
                avatarWrapper = null;
            }
            HomeUiState.Content.ContentHeader contentHeader = HomeHeaderStateReducerKt.computeContentHeader(((AppConfig)this.config.invoke()).getConfigModules(), (TeamPresence)this.intercomDataLayer.getTeamPresence().getValue(), homeClientState.isHeaderImageLoaded());
            boolean bl = ((AppConfig)this.config.invoke()).isAccessToTeammateEnabled();
            AvatarWrapper avatarWrapper3 = avatarWrapper;
            List list3 = collection2;
            List list4 = list2;
            IntercomBadgeState intercomBadgeState3 = intercomBadgeState2;
            homeUiState = new HomeUiState.Content(intercomBadgeState3, list4, list3, avatarWrapper3, bl, contentHeader);
        } else if (networkResponse == null) {
            homeUiState = new HomeUiState.Loading(((IntercomBadgeStateReducer)this.badgeStateReducer.invoke()).computeIntercomBadgeState(IntercomBadgeLocation.Home.INSTANCE, IntercomLinkSolution.LIVE_CHAT));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return homeUiState;
    }

    /*
     * WARNING - void declaration
     */
    private final List<HomeCards> reduceHomeCards(List<? extends HomeCards> homeCards, OpenMessengerResponse.NewConversationData newConversationCta) {
        void $this$mapTo$iv$iv;
        if (newConversationCta == null) {
            return homeCards;
        }
        Iterable $this$map$iv = homeCards;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void homeCard;
            HomeCards homeCards2 = (HomeCards)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(homeCard instanceof HomeCards.HomeNewConversationData ? (HomeCards)new HomeCards.HomeNewConversationData("", HomeCardType.NEW_CONVERSATION, ((HomeCards.HomeNewConversationData)homeCard).getAction(), ((HomeCards.HomeNewConversationData)homeCard).getPreventMultipleInboundConversationsEnabled(), ((HomeCards.HomeNewConversationData)homeCard).getOpenInboundConversationsIds(), ((HomeCards.HomeNewConversationData)homeCard).getShowFinAvatar(), ((HomeCards.HomeNewConversationData)homeCard).getShowTeammateExpectations(), newConversationCta.getHomeCard()) : homeCard);
        }
        return (List)destination$iv$iv;
    }

    public HomeReducer() {
        this(null, null, null, 7, null);
    }
}

