/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.net.Uri;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import coil.request.ErrorResult;
import coil.request.ImageRequest;
import coil.request.SuccessResult;
import coil.transform.RoundedCornersTransformation;
import coil.transform.Transformation;
import com.intercom.twig.Twig;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.Image;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.blocks.lib.BlockAlignment;
import io.intercom.android.sdk.blocks.lib.interfaces.LocalImageBlock;
import io.intercom.android.sdk.blocks.lib.models.BlockMetadata;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.utilities.BlockUtils;
import io.intercom.android.sdk.utilities.IntercomCoilKt;
import io.intercom.android.sdk.utilities.commons.ScreenUtils;
import io.intercom.android.sdk.views.ProgressFrameLayout;
import io.intercom.android.sdk.views.ResizableImageView;
import io.intercom.android.sdk.views.UploadProgressBar;
import org.jetbrains.annotations.NotNull;

class LocalImage
extends Image
implements LocalImageBlock {
    private final Twig twig = LumberMill.getLogger();

    LocalImage(StyleType style2) {
        super(style2);
    }

    @Override
    public View addImage(Uri uri, int width, int height, BlockAlignment alignment, BlockMetadata blockMetadata, ViewGroup parent) {
        Context context = parent.getContext();
        int widthPx = ScreenUtils.dpToPx(width, context);
        int heightPx = ScreenUtils.dpToPx(height, context);
        ProgressFrameLayout rootView = new ProgressFrameLayout(context);
        BlockUtils.createLayoutParams((View)rootView, -2, -2);
        BlockUtils.setDefaultMarginBottom((View)rootView);
        final ResizableImageView imageView = new ResizableImageView(context);
        BlockUtils.createLayoutParams((View)imageView, -2, -2);
        imageView.setAdjustViewBounds(true);
        imageView.setScaleType(ImageView.ScaleType.FIT_START);
        rootView.addView((View)imageView);
        ImageRequest.Builder requestBuilder = new ImageRequest.Builder(context).target((ImageView)imageView).data((Object)uri);
        this.setImageViewBounds(widthPx, heightPx, imageView, requestBuilder);
        View view = rootView.getChildAt(0);
        Resources resources = context.getResources();
        if (view instanceof UploadProgressBar) {
            int spinnerSize = resources.getDimensionPixelSize(R.dimen.intercom_local_image_upload_size);
            view.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(spinnerSize, spinnerSize, 17));
            view.bringToFront();
            rootView.uploadStarted();
        }
        this.setBackground((ImageView)imageView);
        ColorMatrix matrix = new ColorMatrix();
        matrix.setSaturation(0.0f);
        imageView.setColorFilter((ColorFilter)new ColorMatrixColorFilter(matrix));
        requestBuilder.transformations(new Transformation[]{new RoundedCornersTransformation((float)resources.getDimensionPixelSize(R.dimen.intercom_image_rounded_corners))}).crossfade(true).listener(new ImageRequest.Listener(){

            public void onStart(@NotNull ImageRequest imageRequest) {
            }

            public void onCancel(@NotNull ImageRequest imageRequest) {
            }

            public void onError(@NonNull ImageRequest imageRequest, @NonNull ErrorResult errorResult) {
                LocalImage.this.twig.internal("images", "FAILURE");
            }

            public void onSuccess(@NonNull ImageRequest imageRequest, @NonNull SuccessResult successResult) {
                LocalImage.this.twig.internal("images", "SUCCESS");
                imageView.setBackgroundResource(17170445);
            }
        });
        IntercomCoilKt.loadIntercomImage(context, requestBuilder.build());
        BlockUtils.setLayoutMarginsAndGravity((View)rootView, alignment.getGravity(), blockMetadata.isLastObject());
        return rootView;
    }
}

