/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.metrics;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.intercom.android.sdk.IntercomContent;
import io.intercom.android.sdk.IntercomSpace;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.metrics.MetricObject;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.MessageStyle;
import io.intercom.android.sdk.overlay.LauncherOpenBehaviour;
import io.intercom.android.sdk.user.DeviceData;
import io.intercom.android.sdk.utilities.commons.DeviceUtils;
import io.intercom.android.sdk.utilities.commons.TimeProvider;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class MetricTracker {
    static final String METADATA_BADGE_VALUE = "badge_value";
    static final String METADATA_IS_ATTACHMENT = "is_attachment";
    static final String METADATA_IS_GIF = "is_gif";
    static final String METADATA_MESSAGE_ID = "message_id";
    static final String METADATA_CONVERSATION_ID = "conversation_id";
    static final String METADATA_TICKET_ID = "ticket_id";
    static final String METADATA_PART_ID = "part_id";
    static final String METADATA_QUICK_REPLY_ID = "quick_reply_id";
    static final String METADATA_COMMENT_ID = "comment_id";
    static final String METADATA_REACTION_INDEX = "reaction_index";
    static final String METADATA_MESSAGE_TYPE = "message_type";
    static final String METADATA_PUSH_TYPE = "push_type";
    static final String METADATA_HAS_ARTICLE_CARD = "has_article_card";
    static final String METADATA_SEARCH_QUERY = "search_query";
    static final String METADATA_TEAMMATE_STATUS = "teammate_status";
    static final String METADATA_TIME_SINCE_LAST_ACTIVE = "time_since_last_active";
    static final String METADATA_WITHIN_OFFICE_HOURS = "within_office_hours";
    static final String METADATA_SUGGESTION_ID = "suggestion_id";
    static final String METADATA_INSTANCE_ID = "instance_id";
    static final String METADATA_REQUEST_CONTENT_ID = "requested_content_id";
    static final String METADATA_REQUEST_ERROR_CODE = "error_code";
    static final String METADATA_CLOSED_CONVERSATION_ID = "closed_conversation_id";
    static final String METADATA_SOURCE = "source";
    static final String METADATA_ERROR = "error";
    static final String METADATA_FILTERED = "filtered";
    static final String METADATA_URL = "url";
    static final String METADATA_VIDEO_URL = "video_url";
    static final String METADATA_VIDEO_WIDTH = "video_width";
    static final String METADATA_VIDEO_HEIGHT = "video_height";
    static final String METADATA_SCREENS_IN_MESSAGE = "screens_in_message";
    static final String METADATA_SCREENS_SHOWN = "screens_shown";
    static final String METADATA_SCREENS_SEEN = "screens_seen";
    static final String METADATA_PERMISSION_GRANTED = "permission_granted";
    static final String METADATA_HOME_SCREEN_INDEX = "home_screen_index";
    static final String METADATA_SURVEY_ID = "survey_id";
    static final String METADATA_SURVEY_FORMAT = "format";
    static final String METADATA_PLATFORM = "platform";
    static final String METADATA_STEPS_COMPLETE = "steps_complete";
    static final String METADATA_SPACE = "space";
    static final String METADATA_CONTENT_TYPE = "content_type";
    static final String QUESTIONS_SEEN = "questions_seen";
    static final String METADATA_MAX_STEPS = "max_steps";
    static final String TICKET_TYPE_ID = "ticket_type_id";
    static final String TICKET_STATUS = "ticket_status";
    static final String VALUE_MESSAGE = "message";
    static final String VALUE_NOTIFICATION = "notification";
    static final String VALUE_ACTIVE = "active";
    static final String VALUE_AWAY = "away";
    static final String VALUE_ANDROID_SDK = "android-sdk";
    private final UserIdentity userIdentity;
    private final TimeProvider timeProvider;
    private final MetricsStore store;
    private final String sdkVersion;
    private final String appVersion;
    private final String appMinSdkVersion;
    private final String appName;

    public MetricTracker(UserIdentity userIdentity, MetricsStore store, android.content.Context androidContext) {
        this(userIdentity, store, TimeProvider.SYSTEM, androidContext);
    }

    @VisibleForTesting
    MetricTracker(UserIdentity userIdentity, MetricsStore store, TimeProvider timeProvider, android.content.Context androidContext) {
        this.userIdentity = userIdentity;
        this.timeProvider = timeProvider;
        this.store = store;
        this.sdkVersion = "15.10.2";
        this.appVersion = DeviceUtils.getAppVersion(androidContext);
        this.appMinSdkVersion = DeviceUtils.getAppMinSdkVersionVersion(androidContext);
        this.appName = DeviceData.getApplicationName(androidContext);
    }

    public void openedMessengerConversationList(LauncherOpenBehaviour.LauncherType launcherType) {
        this.track(this.newMetric("opened", "conversation_list", "messenger", MetricTracker.contextFrom(launcherType)));
    }

    public void openedMessengerConversation(String conversationId2, LauncherOpenBehaviour.LauncherType launcherType) {
        this.track(this.newMetric("opened", "conversation", "messenger", MetricTracker.contextFrom(launcherType)).addMetaData(METADATA_CONVERSATION_ID, conversationId2));
    }

    public void openedMessengerNewConversation(LauncherOpenBehaviour.LauncherType launcherType) {
        this.track(this.newMetric("opened", "new_conversation", "messenger", MetricTracker.contextFrom(launcherType)));
    }

    private static String contextFrom(LauncherOpenBehaviour.LauncherType launcherType) {
        return LauncherOpenBehaviour.LauncherType.DEFAULT == launcherType ? "from_launcher" : "from_custom_launcher";
    }

    public void closedMessengerBackButton() {
        this.track(this.newMetric("closed", "messenger", "messenger", "from_android_back_button"));
    }

    public void closedMessengerCloseButton() {
        this.track(this.newMetric("closed", "messenger", "messenger", "from_close_button"));
    }

    void typeInNewConversation() {
        this.track(this.newMetric("typed", VALUE_MESSAGE, "messenger", "in_new_conversation"));
    }

    void typeInNewFollowUpConversation(String closedConversationId) {
        this.track(this.newMetric("typed", VALUE_MESSAGE, "messenger", "from_closed_conversation").addMetaData(METADATA_CLOSED_CONVERSATION_ID, closedConversationId));
    }

    void typeInConversation(String conversationId2) {
        this.track(this.newMetric("typed", "reply", "messenger", "in_conversation").addMetaData(METADATA_CONVERSATION_ID, conversationId2));
    }

    public void sentInNewConversation(boolean isAttachment, boolean isGif, String partId, String conversationId2, boolean withinOfficeHours) {
        this.track(this.newMetric("sent", VALUE_MESSAGE, "messenger", "in_new_conversation").addMetaData(METADATA_IS_ATTACHMENT, isAttachment).addMetaData(METADATA_IS_GIF, isGif).addMetaData(METADATA_MESSAGE_ID, partId).addMetaData(METADATA_CONVERSATION_ID, conversationId2).addMetaData(METADATA_WITHIN_OFFICE_HOURS, withinOfficeHours));
    }

    public void sentInNewFollowupConversation(boolean isAttachment, boolean isGif, String partId, String conversationId2, boolean withinOfficeHours, String closedConversationId) {
        this.track(this.newMetric("sent", VALUE_MESSAGE, "messenger", "in_followup_conversation").addMetaData(METADATA_IS_ATTACHMENT, isAttachment).addMetaData(METADATA_IS_GIF, isGif).addMetaData(METADATA_MESSAGE_ID, partId).addMetaData(METADATA_CONVERSATION_ID, conversationId2).addMetaData(METADATA_WITHIN_OFFICE_HOURS, withinOfficeHours).addMetaData(METADATA_CLOSED_CONVERSATION_ID, closedConversationId));
    }

    public void sentInConversation(boolean isAttachment, boolean isGif, String partId, String conversationId2, boolean withinOfficeHours, boolean isTeamMateActive, String timeSinceLastActive) {
        this.track(this.newMetric("sent", "reply", "messenger", "in_conversation").addMetaData(METADATA_IS_ATTACHMENT, isAttachment).addMetaData(METADATA_IS_GIF, isGif).addMetaData(METADATA_MESSAGE_ID, partId).addMetaData(METADATA_CONVERSATION_ID, conversationId2).addMetaData(METADATA_WITHIN_OFFICE_HOURS, withinOfficeHours).addMetaData(METADATA_TEAMMATE_STATUS, isTeamMateActive ? VALUE_ACTIVE : VALUE_AWAY).addMetaData(METADATA_TIME_SINCE_LAST_ACTIVE, timeSinceLastActive));
    }

    public void openConversationsListFromNewConversation() {
        this.track(this.newMetric("opened", "conversation_list", "messenger", "from_new_conversation"));
    }

    public void startConversation(String conversationId2) {
        this.track(this.newMetric("opened", "conversation", "messenger", "from_new_conversation").addMetaData(METADATA_CONVERSATION_ID, conversationId2));
    }

    public void startFollowupConversation(String conversationId2, String closedConverastionId) {
        this.track(this.newMetric("opened", "conversation", "messenger", "in_followup_conversation").addMetaData(METADATA_CONVERSATION_ID, conversationId2).addMetaData(METADATA_CLOSED_CONVERSATION_ID, closedConverastionId));
    }

    public void openConversationsListFromConversation(String conversationId2) {
        this.track(this.newMetric("opened", "conversation_list", "messenger", "from_conversation").addMetaData(METADATA_CONVERSATION_ID, conversationId2));
    }

    public void openedConversationFromFull(String conversationId2, String commentId) {
        this.track(this.newMetric("opened", "conversation", "messenger", "from_full").addMetaData(METADATA_COMMENT_ID, commentId).addMetaData(METADATA_CONVERSATION_ID, conversationId2));
    }

    public void openedConversationFromSnippet(String conversationId2, String commentId) {
        this.track(this.newMetric("opened", "conversation", "messenger", "from_snippet").addMetaData(METADATA_COMMENT_ID, commentId).addMetaData(METADATA_CONVERSATION_ID, conversationId2));
    }

    public void receivedReply(boolean isAttachment, boolean hasArticle, String partId, String conversationId2) {
        this.track(this.newMetric("received", "reply", "messenger", "in_conversation").addMetaData(METADATA_IS_ATTACHMENT, isAttachment).addMetaData(METADATA_HAS_ARTICLE_CARD, hasArticle).addMetaData(METADATA_PART_ID, partId).addMetaData(METADATA_CONVERSATION_ID, conversationId2));
    }

    public void viewedReply(boolean isAttachment, boolean hasArticle, String partId, String conversationId2) {
        this.track(this.newMetric("viewed", "reply", "messenger", "from_snippet").addMetaData(METADATA_IS_ATTACHMENT, isAttachment).addMetaData(METADATA_HAS_ARTICLE_CARD, hasArticle).addMetaData(METADATA_COMMENT_ID, partId).addMetaData(METADATA_CONVERSATION_ID, conversationId2));
    }

    public void sentReaction(String conversationId2, String messageId, int reactionIndex, ReactionLocation reactionLocation) {
        if (ReactionLocation.CONVERSATION == reactionLocation) {
            this.track(this.newMetric("sent", "reaction", "messenger", "in_conversation").addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_REACTION_INDEX, reactionIndex).addMetaData(METADATA_CONVERSATION_ID, conversationId2));
        } else if (ReactionLocation.LINK == reactionLocation) {
            this.track(this.newEducateMetric("sent", "reaction", "messenger", "on_article").addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_CONVERSATION_ID, conversationId2));
        } else {
            this.track(this.newMetric("sent", "reaction", "in_app", "from_full").addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_CONVERSATION_ID, conversationId2));
        }
    }

    public void openConversationFromConversationList(String conversationId2, boolean withinOfficeHours, boolean isTeamMateActive, String timeSinceLastActive) {
        this.track(this.newMetric("opened", "conversation", "messenger", "from_conversation_list").addMetaData(METADATA_CONVERSATION_ID, conversationId2).addMetaData(METADATA_WITHIN_OFFICE_HOURS, withinOfficeHours).addMetaData(METADATA_TEAMMATE_STATUS, isTeamMateActive ? VALUE_ACTIVE : VALUE_AWAY).addMetaData(METADATA_TIME_SINCE_LAST_ACTIVE, timeSinceLastActive));
    }

    public void receivedPushNotification(String conversationId2) {
        this.track(this.newMetric("received", VALUE_MESSAGE, "push", "from_push").addMetaData(METADATA_CONVERSATION_ID, conversationId2).addMetaData(METADATA_PUSH_TYPE, VALUE_NOTIFICATION));
    }

    public void receivedPushOnlyNotification(String conversationId2, String instanceId) {
        this.track(this.newMetric("received", VALUE_MESSAGE, "push", "from_push").addMetaData(METADATA_CONVERSATION_ID, conversationId2).addMetaData(METADATA_INSTANCE_ID, instanceId).addMetaData(METADATA_PUSH_TYPE, VALUE_MESSAGE));
    }

    public void viewedPushNotification(String conversationId2) {
        this.track(this.newMetric("viewed", VALUE_MESSAGE, "in_app", "from_push").addMetaData(METADATA_CONVERSATION_ID, conversationId2).addMetaData(METADATA_PUSH_TYPE, VALUE_NOTIFICATION));
    }

    public void openedPushOnlyNotification(String conversationId2) {
        this.track(this.newMetric("opened", VALUE_MESSAGE, "in_app", "from_push").addMetaData(METADATA_CONVERSATION_ID, conversationId2).addMetaData(METADATA_PUSH_TYPE, VALUE_MESSAGE));
    }

    public void dismissedPushNotification(String conversationId2) {
        this.track(this.newMetric("dismissed", VALUE_MESSAGE, "in_app", "from_push").addMetaData(METADATA_CONVERSATION_ID, conversationId2).addMetaData(METADATA_PUSH_TYPE, VALUE_NOTIFICATION));
    }

    public void dismissedPushOnlyNotification(String conversationId2, String instanceId) {
        this.track(this.newMetric("dismissed", VALUE_MESSAGE, "in_app", "from_push").addMetaData(METADATA_CONVERSATION_ID, conversationId2).addMetaData(METADATA_INSTANCE_ID, instanceId).addMetaData(METADATA_PUSH_TYPE, VALUE_MESSAGE));
    }

    public void receivedMessageFromSnippetWhenClosed(boolean isAttachment, boolean hasArticle, String conversationId2, String messageId, MessageStyle messageStyle) {
        this.track(this.newMetric("received", VALUE_MESSAGE, "in_app", "from_snippet").addMetaData(METADATA_CONVERSATION_ID, conversationId2).addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_MESSAGE_TYPE, messageStyle.name().toLowerCase()).addMetaData(METADATA_IS_ATTACHMENT, isAttachment).addMetaData(METADATA_HAS_ARTICLE_CARD, hasArticle));
    }

    public void receivedReplyFromSnippetWhenClosed(boolean isAttachment, boolean hasArticle, String conversationId2, String commentId) {
        this.track(this.newMetric("received", "reply", "in_app", "from_snippet").addMetaData(METADATA_CONVERSATION_ID, conversationId2).addMetaData(METADATA_COMMENT_ID, commentId).addMetaData(METADATA_IS_ATTACHMENT, isAttachment).addMetaData(METADATA_HAS_ARTICLE_CARD, hasArticle));
    }

    public void receivedMessageFromFullWhenClosed(boolean isAttachment, boolean hasArticle, String conversationId2, String messageId, MessageStyle messageStyle) {
        this.track(this.newMetric("received", VALUE_MESSAGE, "in_app", "from_full").addMetaData(METADATA_CONVERSATION_ID, conversationId2).addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_MESSAGE_TYPE, messageStyle.name().toLowerCase()).addMetaData(METADATA_IS_ATTACHMENT, isAttachment).addMetaData(METADATA_HAS_ARTICLE_CARD, hasArticle));
    }

    public void receivedQuickReply(String quickReplyId, String conversationId2, String partId) {
        this.track(this.newMetric("received", "quick_replies", "messenger", "in_conversation").addMetaData(METADATA_CONVERSATION_ID, conversationId2).addMetaData(METADATA_PART_ID, partId).addMetaData(METADATA_QUICK_REPLY_ID, quickReplyId));
    }

    public void clickedQuickReply(String quickReplyId, String conversationId2, String partId) {
        this.track(this.newMetric("clicked", "quick_reply", "messenger", "in_conversation").addMetaData(METADATA_CONVERSATION_ID, conversationId2).addMetaData(METADATA_PART_ID, partId).addMetaData(METADATA_QUICK_REPLY_ID, quickReplyId));
    }

    public void receivedComposerSuggestions(String suggestionId, String conversationId2, String partId) {
        this.track(this.newMetric("received", "composer_suggestions", "messenger", "in_conversation").addMetaData(METADATA_CONVERSATION_ID, conversationId2).addMetaData(METADATA_PART_ID, partId).addMetaData(METADATA_SUGGESTION_ID, suggestionId));
    }

    public void clickedComposerSuggestion(String suggestionId, String conversationId2, String partId) {
        this.track(this.newMetric("clicked", "suggestion", "messenger", "in_conversation").addMetaData(METADATA_CONVERSATION_ID, conversationId2).addMetaData(METADATA_PART_ID, partId).addMetaData(METADATA_SUGGESTION_ID, suggestionId));
    }

    public void dismissInAppMessageSnippet(String conversationId2, String messageId) {
        this.track(this.newMetric("dismissed", VALUE_MESSAGE, "in_app", "from_snippet").addMetaData(METADATA_CONVERSATION_ID, conversationId2).addMetaData(METADATA_MESSAGE_ID, messageId));
    }

    public void dismissInAppCommentSnippet(String conversationId2, String commentId) {
        this.track(this.newMetric("dismissed", "reply", "in_app", "from_snippet").addMetaData(METADATA_CONVERSATION_ID, conversationId2).addMetaData(METADATA_COMMENT_ID, commentId));
    }

    public void viewedInAppFromMessenger(String conversationId2, String messageId, MessageStyle messageStyle) {
        this.track(this.newMetric("viewed", VALUE_MESSAGE, "messenger", "from_full").addMetaData(METADATA_MESSAGE_TYPE, messageStyle.name().toLowerCase()).addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_CONVERSATION_ID, conversationId2));
    }

    public void viewedInApp(String conversationId2, String messageId, @InAppMessageViewContext int context) {
        this.track(this.newMetric("viewed", VALUE_MESSAGE, "in_app", MetricTracker.contextForInApp(context)).addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_CONVERSATION_ID, conversationId2));
    }

    private static String contextForInApp(@InAppMessageViewContext int context) {
        return context == 0 ? "from_snippet" : "from_full";
    }

    public void closedInAppFromFull(String conversationId2, String messageId) {
        this.track(this.newMetric("closed", VALUE_MESSAGE, "in_app", "from_full").addMetaData(METADATA_MESSAGE_ID, messageId).addMetaData(METADATA_CONVERSATION_ID, conversationId2));
    }

    public void receivedNotificationFromBadgeWhenMessengerClosed(String badgeValue) {
        this.track(this.newMetric("received", "badge", "in_app", "from_launcher").addMetaData(METADATA_BADGE_VALUE, badgeValue));
    }

    public void receivedOperatorReply(String conversationId2) {
        this.track(this.newEducateMetric("received", "operator_reply", "messenger", "from_conversation").addMetaData(METADATA_CONVERSATION_ID, conversationId2));
    }

    public void openedNativeHelpCenter(String place, @Nullable String context) {
        String metricContext = context;
        if (metricContext == null) {
            metricContext = "no_context";
        }
        this.track(this.newHelpCenterMetric("opened", "help_center", place, metricContext, "search_browse".equals(place)));
    }

    public void searchedNativeHelpCenter(boolean isFromSearchBrowse) {
        this.track(this.newHelpCenterMetric("searched", "help_center", "search_results", "no_context", isFromSearchBrowse));
    }

    public void openedNativeHelpCenterSearchResult(boolean isFromSearchBrowse, String searchQuery) {
        this.track(this.newHelpCenterMetric("clicked", "help_center", "search_results", "no_context", isFromSearchBrowse).addMetaData(METADATA_SEARCH_QUERY, searchQuery));
    }

    public void clickedNewConversation(String place, String context, boolean isFromSearchBrowse) {
        this.track(this.newHelpCenterMetric("clicked", "new_conversation", place, context, isFromSearchBrowse));
    }

    public void sentArticleReaction(String context, @Nullable Boolean conversationShown, boolean isFromSearchBrowse) {
        MetricObject metricObject = this.newHelpCenterMetric("sent", "article_reaction", "article", context, isFromSearchBrowse);
        if (conversationShown != null) {
            metricObject.addMetaData("conversation_shown", conversationShown);
        }
        this.track(metricObject);
    }

    public void failedHelpCenter(String object, String place, @Nullable String code, boolean isFromSearchBrowse) {
        MetricObject metricObject = this.newHelpCenterMetric("failed", object, place, "no_context", isFromSearchBrowse);
        if (code != null) {
            metricObject.addMetaData(METADATA_ERROR, code);
        }
        this.track(metricObject);
    }

    public void requestedHelpCenterData(String place) {
        MetricObject metricObject = this.newEducateMetric("requested", "help_center_data", place, "no_context");
        this.track(metricObject);
    }

    public void viewedNativeHelpCenter(String place, @Nullable Boolean filtered, boolean isFromSearchBrowse) {
        MetricObject metricObject = this.newHelpCenterMetric("viewed", "help_center", place, "no_context", isFromSearchBrowse);
        if (filtered != null) {
            metricObject.addMetaData(METADATA_FILTERED, filtered);
        }
        this.track(metricObject);
    }

    public void viewedCreateTicketForm(@Nullable Integer ticketTypeId, String conversationId2, String from) {
        MetricObject metricObject = this.newMetric("viewed", "create_ticket_form", "messenger", from);
        if (ticketTypeId != null) {
            metricObject.addMetaData(TICKET_TYPE_ID, ticketTypeId);
        }
        metricObject.addMetaData(METADATA_CONVERSATION_ID, conversationId2);
        this.track(metricObject);
    }

    public void viewedTicketDetails(@Nullable Integer ticketTypeId, String conversationId2, String ticketStatus, String from) {
        MetricObject metricObject = this.newMetric("viewed", "ticket_details", "messenger", from);
        if (ticketTypeId != null) {
            metricObject.addMetaData(TICKET_TYPE_ID, ticketTypeId);
        }
        metricObject.addMetaData(TICKET_STATUS, ticketStatus);
        metricObject.addMetaData(METADATA_CONVERSATION_ID, conversationId2);
        this.track(metricObject);
    }

    public void submittedCreateTicketForm(@Nullable Integer ticketTypeId, String conversationId2, String from) {
        MetricObject metricObject = this.newMetric("submitted", "create_ticket_form", "messenger", from);
        if (ticketTypeId != null) {
            metricObject.addMetaData(TICKET_TYPE_ID, ticketTypeId);
        }
        metricObject.addMetaData(METADATA_CONVERSATION_ID, conversationId2);
        this.track(metricObject);
    }

    public void viewedSearchBrowseCard(int homeIndex) {
        MetricObject metricObject = this.createMetric("search_browse_event", "messenger", "viewed", "search_browse_card", "home", "messenger");
        metricObject.addMetaData(METADATA_HOME_SCREEN_INDEX, homeIndex);
        this.track(metricObject);
    }

    public void clickedSearchBrowseCard() {
        MetricObject metricObject = this.createMetric("educate_event", "messenger", "clicked", "search_browse_card_input", "home", "messenger");
        this.track(metricObject);
    }

    public void clickedArticleSuggestion(String articleId) {
        MetricObject metricObject = this.createMetric("m5_metric", "messenger", "clicked", "article_suggestion", "search_browse_card", "messenger").addMetaData("article_id", articleId);
        this.track(metricObject);
    }

    public void viewedArticleSuggestions(List<String> articleIds) {
        MetricObject metricObject = this.createMetric("m5_metric", "messenger", "viewed", "article_suggestions", "search_browse_card", "messenger").addMetaData("articles_count", articleIds.size()).addMetaData("articles_shown", articleIds);
        this.track(metricObject);
    }

    public void initialiseAPICall() {
        this.track(this.createMetric("m5_metric", "messenger", "used", "initialise", "api", "no_context"));
    }

    public void setUserHashAPICall() {
        this.track(this.createMetric("m5_metric", "messenger", "used", "user_hash", "api", "no_context"));
    }

    public void loginUnidentifiedUserAPICall() {
        this.track(this.createMetric("m5_metric", "messenger", "used", "login_unidentified_user", "api", "no_context"));
    }

    public void registerUnidentifiedUserAPICall() {
        this.track(this.createMetric("m5_metric", "messenger", "used", "register_unidentified_user", "api", "no_context"));
    }

    public void loginIdentifiedUserAPICall() {
        this.track(this.createMetric("m5_metric", "messenger", "used", "login_identified_user", "api", "no_context"));
    }

    public void registerIdentifiedUserAPICall() {
        this.track(this.createMetric("m5_metric", "messenger", "used", "register_identified_user", "api", "no_context"));
    }

    public void logoutAPICall() {
        this.track(this.createMetric("m5_metric", "messenger", "used", "logout", "api", "no_context"));
    }

    public void resetAPICall() {
        this.track(this.createMetric("m5_metric", "messenger", "used", "reset", "api", "no_context"));
    }

    public void updateUserCallbackAPICall() {
        this.track(this.createMetric("m5_metric", "messenger", "used", "update_user_callback", "api", "no_context"));
    }

    public void updateUserAPICall() {
        this.track(this.createMetric("m5_metric", "messenger", "used", "update_user", "api", "no_context"));
    }

    public void logEventAPICall() {
        this.track(this.createMetric("m5_metric", "messenger", "used", "log_event", "api", "no_context"));
    }

    public void logEventMetadataAPICall() {
        this.track(this.createMetric("m5_metric", "messenger", "used", "log_event_metadata", "api", "no_context"));
    }

    public void displayMessengerAPICall() {
        this.track(this.createMetric("m5_metric", "messenger", "used", "present_messenger", "api", "no_context"));
    }

    public void displayMessageComposerInitialMessageAPICall() {
        this.track(this.createMetric("m5_metric", "messenger", "used", "present_message_composer_initial_message", "api", "no_context"));
    }

    public void displayMessageComposerAPICall() {
        this.track(this.createMetric("m5_metric", "messenger", "used", "present_message_composer", "api", "no_context"));
    }

    public void displayConversationsListAPICall() {
        this.track(this.createMetric("m5_metric", "messenger", "used", "present_conversation_list", "api", "no_context"));
    }

    public void displayHelpCenterAPICall() {
        this.track(this.createMetric("m5_metric", "messenger", "used", "present_help_center", "api", "no_context"));
    }

    public void displayHelpCenterCollectionsAPICall() {
        this.track(this.createMetric("m5_metric", "messenger", "used", "present_help_center_collections", "api", "no_context"));
    }

    public void displayArticleAPICall() {
        this.track(this.createMetric("m5_metric", "messenger", "used", "present_articles", "api", "no_context"));
    }

    public void fetchHelpCenterCollectionsAPICall() {
        this.track(this.createMetric("m5_metric", "messenger", "used", "fetch_help_center_collections", "api", "no_context"));
    }

    public void fetchHelpCenterCollectionAPICall() {
        this.track(this.createMetric("m5_metric", "messenger", "used", "fetch_help_center_collection", "api", "no_context"));
    }

    public void searchHelpCenterAPICall() {
        this.track(this.createMetric("m5_metric", "messenger", "used", "search_help_center", "api", "no_context"));
    }

    public void displayCarouselAPICall() {
        this.track(this.createMetric("m5_metric", "messenger", "used", "present_carousel", "api", "no_context"));
    }

    public void displaySurveyAPICall() {
        this.track(this.createMetric("m5_metric", "messenger", "used", "present_survey", "api", "no_context"));
    }

    public void handlePushMessageAPICall() {
        this.track(this.createMetric("m5_metric", "messenger", "used", "handle_push_notification", "api", "no_context"));
    }

    public void setBottomPaddingAPICall() {
        this.track(this.createMetric("m5_metric", "messenger", "used", "set_bottom_padding", "api", "no_context"));
    }

    public void setInAppMessageVisibilityAPICall() {
        this.track(this.createMetric("m5_metric", "messenger", "used", "set_inapp_message_visibility", "api", "no_context"));
    }

    public void setLauncherVisibilityAPICall() {
        this.track(this.createMetric("m5_metric", "messenger", "used", "set_launcher_visibility", "api", "no_context"));
    }

    public void hideIntercomAPICall() {
        this.track(this.createMetric("m5_metric", "messenger", "used", "hide_intercom", "api", "no_context"));
    }

    public void unreadConversationCountAPICall() {
        this.track(this.createMetric("m5_metric", "messenger", "used", "unread_conversation_count", "api", "no_context"));
    }

    public void setLogLevelAPICall() {
        this.track(this.createMetric("m5_metric", "messenger", "used", "enable_logging", "api", "no_context"));
    }

    public void handlePushMessageCustomStackAPICall() {
        this.track(this.createMetric("m5_metric", "messenger", "used", "handle_push_notification_custom", "api", "no_context"));
    }

    public void addUnreadConversationCountListenerAPICall() {
        this.track(this.createMetric("m5_metric", "messenger", "used", "add_unread_conversation_count_listener", "api", "no_context"));
    }

    public void removeUnreadConversationCountListenerAPICall() {
        this.track(this.createMetric("m5_metric", "messenger", "used", "remove_unread_conversation_count_listener", "api", "no_context"));
    }

    public void registerForLateInitialisationAPICall() {
        this.track(this.createMetric("m5_metric", "messenger", "used", "register_later_init", "api", "no_context"));
    }

    public void unRegisterForLateInitialisationAPICall() {
        this.track(this.createMetric("m5_metric", "messenger", "used", "unregister_later_init", "api", "no_context"));
    }

    public void presentAPICall(IntercomSpace intercomSpace) {
        MetricObject metric = this.createMetric("m5_metric", "messenger", "used", "present_intercom", "api", "no_context");
        String space = "";
        if (intercomSpace == IntercomSpace.Home) {
            space = "home";
        } else if (intercomSpace == IntercomSpace.HelpCenter) {
            space = "help_center";
        } else if (intercomSpace == IntercomSpace.Messages) {
            space = "messages";
        }
        metric.addMetaData(METADATA_SPACE, space);
        this.track(metric);
    }

    public void presentContentAPICall(IntercomContent intercomContent) {
        MetricObject metric = this.createMetric("m5_metric", "messenger", "used", "present_intercom_content", "api", "no_context");
        String contentType = "";
        if (intercomContent instanceof IntercomContent.Article) {
            contentType = "article";
        } else if (intercomContent instanceof IntercomContent.Carousel) {
            contentType = "carousel";
        } else if (intercomContent instanceof IntercomContent.HelpCenterCollections) {
            contentType = "help_center_collections";
        } else if (intercomContent instanceof IntercomContent.Survey) {
            contentType = "survey";
        }
        metric.addMetaData(METADATA_CONTENT_TYPE, contentType);
        this.track(metric);
    }

    public void clickedInput(String conversationId2, String input) {
        this.track(this.newMetric("clicked", input, "messenger", "in_conversation").addMetaData(METADATA_CONVERSATION_ID, conversationId2));
    }

    public void searchedGifInput(String query) {
        this.track(this.newMetric("searched", "expanded_gif_input", "messenger", "in_conversation").addMetaData(METADATA_SEARCH_QUERY, query));
    }

    public void expandedInput(String conversationId2) {
        this.track(this.newMetric("opened", "expanded_gif_input", "messenger", "in_conversation").addMetaData(METADATA_CONVERSATION_ID, conversationId2));
    }

    public void viewedMessengerSheet(String conversationId2, String url, boolean isHomeScreen) {
        String context = isHomeScreen ? "home_screen" : "conversation";
        this.track(this.newMetric("viewed", "messenger_sheet", "messenger", context).addMetaData(METADATA_URL, url).addMetaData(METADATA_CONVERSATION_ID, conversationId2));
    }

    public void closedMessengerSheet(String conversationId2, String url, boolean isHomeScreen) {
        String context = isHomeScreen ? "home_screen" : "conversation";
        this.track(this.newMetric("closed", "messenger_sheet", "messenger", context).addMetaData(METADATA_URL, url).addMetaData(METADATA_CONVERSATION_ID, conversationId2));
    }

    public void messengerCardWebViewEvent(String action, String object, String place, @Nullable Map<String, java.lang.Object> eventMetaData, boolean isHomeScreen) {
        String context = isHomeScreen ? "home_screen" : "conversation";
        MetricObject metricObject = this.newEducateMetric(action, object, place, context);
        this.addMetadataToMetricObject(metricObject, eventMetaData);
        this.track(metricObject);
    }

    public void clickedSpace(String spaceType) {
        this.track(this.newMetric("clicked", spaceType, "messenger", "home"));
    }

    public void viewedNewConversation(String spaceType) {
        this.track(this.newMetric("viewed", "new_conversation", "messenger", spaceType));
    }

    public void clickedExternalLinkCard() {
        this.track(this.newMetric("clicked", "external_link", "messenger", "home"));
    }

    public void viewedConversation(String spaceType, Conversation conversation) {
        this.track(this.newMetric("viewed", "conversation", "messenger", spaceType).addMetaData(METADATA_CONVERSATION_ID, conversation.getId()));
    }

    public void clickedLauncher() {
        this.track(this.newMetric("clicked", "launcher", "messenger", "no_context"));
    }

    public void receivedInAppOnLegacyActivity() {
        this.track(this.newMetric("received", "in_app_on_legacy_activity", "in_app", "no_context"));
    }

    public void clickedPoweredBy(String context) {
        this.track(this.newMetric("clicked", "we_run_on_intercom", "messenger", context));
    }

    public void viewedSpace(String spaceType) {
        this.track(this.newMetric("viewed", spaceType, "messenger", "no_context"));
    }

    public void startedToPlayVideo() {
        this.track(this.newMetric("started", "video_auto_message", "in_app", "conversation"));
    }

    public void loadedVideo(String videoUrl, int width, int height) {
        this.track(this.newMetric("loaded", "video_auto_message", "in_app", "conversation").addMetaData(METADATA_VIDEO_URL, videoUrl).addMetaData(METADATA_VIDEO_WIDTH, width).addMetaData(METADATA_VIDEO_HEIGHT, height));
    }

    public void failedToPlayVideo(String videoUrl) {
        this.track(this.newMetric("failed", "video_auto_message", "in_app", "conversation").addMetaData(METADATA_VIDEO_URL, videoUrl));
    }

    public void completedVideo() {
        this.track(this.newMetric("completed", "video_auto_message", "in_app", "conversation"));
    }

    public void trackFinDictation(String action, String conversationId2, Map<String, java.lang.Object> meta) {
        MetricObject metricObject = this.newMetric(action, "fin_dictation", "conversation", "conversation").addMetaData(METADATA_CONVERSATION_ID, conversationId2);
        this.addMetadataToMetricObject(metricObject, meta);
        this.track(metricObject);
    }

    public void openedCarousel(String instanceId, String source, int screensInMessage, int screensShown) {
        this.track(this.newCarouselMetric("opened", "carousel_message", "from_carousel", instanceId, source).addMetaData(METADATA_SCREENS_IN_MESSAGE, screensInMessage).addMetaData(METADATA_SCREENS_SHOWN, screensShown));
    }

    public void dismissedCarousel(String context, String instanceId, String source, int screensInMessage, int screensShown, int screensSeen) {
        this.track(this.newCarouselMetric("dismissed", "carousel_message", context, instanceId, source).addMetaData(METADATA_SCREENS_IN_MESSAGE, screensInMessage).addMetaData(METADATA_SCREENS_SHOWN, screensShown).addMetaData(METADATA_SCREENS_SEEN, screensSeen));
    }

    public void dismissedCarouselFetching(String context, String requestId, String source) {
        this.track(this.newCarouselMetric("dismissed", "carousel_message_preload", context, source).addMetaData(METADATA_REQUEST_CONTENT_ID, requestId));
    }

    public void failedCarousel(String requestId, String source, int errorCode) {
        this.track(this.newCarouselMetric("failed", "carousel_message_preload", "from_carousel", source).addMetaData(METADATA_REQUEST_ERROR_CODE, errorCode).addMetaData(METADATA_REQUEST_CONTENT_ID, requestId));
    }

    public void startedCarouselFetching(String requestId, String source) {
        this.track(this.newCarouselMetric("started", "carousel_message_preload", "from_carousel", source).addMetaData(METADATA_REQUEST_CONTENT_ID, requestId));
    }

    public void retriedCarouselFetching(String requestId, String source) {
        this.track(this.newCarouselMetric("clicked", "carousel_message_preload", "from_retry", source).addMetaData(METADATA_REQUEST_CONTENT_ID, requestId));
    }

    public void completedCarousel(String context, String instanceId, String source, int screensInMessage, int screensShown) {
        this.track(this.newCarouselMetric("completed", "carousel_message", context, instanceId, source).addMetaData(METADATA_SCREENS_IN_MESSAGE, screensInMessage).addMetaData(METADATA_SCREENS_SHOWN, screensShown));
    }

    public void skippedPermission(String permissionType, String instanceId, String source) {
        this.track(this.newCarouselMetric("clicked", "carousel_permission_skipped", permissionType, instanceId, source));
    }

    public void requestedPermission(String permissionType, String instanceId, String source, boolean isGranted) {
        this.track(this.newCarouselMetric("clicked", "carousel_permission_dialog", permissionType, instanceId, source).addMetaData(METADATA_PERMISSION_GRANTED, isGranted));
    }

    public void sentToPermissionSettings(String permissionType, String instanceId, String source, boolean isGranted) {
        this.track(this.newCarouselMetric("clicked", "carousel_permission_settings", permissionType, instanceId, source).addMetaData(METADATA_PERMISSION_GRANTED, isGranted));
    }

    public void educateWebviewMetric(String action, String object, String place, @Nullable Map<String, java.lang.Object> eventMetaData, String context) {
        MetricObject metricObject = this.newEducateMetric(action, object, place, context);
        if (context.equals("from_article_on_button")) {
            metricObject.addMetaData(METADATA_SOURCE, "programmatic");
        } else {
            metricObject.addMetaData(METADATA_SOURCE, "automatic");
        }
        this.addMetadataToMetricObject(metricObject, eventMetaData);
        this.track(metricObject);
    }

    public void surveyOpened(String action, String object, String context, String surveyID, String format) {
        MetricObject surveyMetric = this.newSurveyMetric(action, object, context).addMetaData(METADATA_PLATFORM, VALUE_ANDROID_SDK).addMetaData(METADATA_SURVEY_ID, surveyID).addMetaData(METADATA_SURVEY_FORMAT, format);
        this.track(surveyMetric);
    }

    public void surveyCompleted(String action, String object, String context, String surveyID, String format, int stepsCompleted, int maxSteps, int questionsSeen) {
        MetricObject surveyMetric = this.newSurveyMetric(action, object, context).addMetaData(METADATA_PLATFORM, VALUE_ANDROID_SDK).addMetaData(METADATA_SURVEY_ID, surveyID).addMetaData(METADATA_SURVEY_FORMAT, format).addMetaData(METADATA_STEPS_COMPLETE, stepsCompleted).addMetaData(QUESTIONS_SEEN, questionsSeen).addMetaData(METADATA_MAX_STEPS, maxSteps);
        this.track(surveyMetric);
    }

    public void surveyDismissed(String action, String object, String context, String surveyID, String format, int stepsCompleted, int maxSteps, int questionsSeen) {
        MetricObject surveyMetric = this.newSurveyMetric(action, object, context).addMetaData(METADATA_PLATFORM, VALUE_ANDROID_SDK).addMetaData(METADATA_SURVEY_ID, surveyID).addMetaData(METADATA_SURVEY_FORMAT, format).addMetaData(METADATA_STEPS_COMPLETE, stepsCompleted).addMetaData(QUESTIONS_SEEN, questionsSeen).addMetaData(METADATA_MAX_STEPS, maxSteps);
        this.track(surveyMetric);
    }

    public void moreMenuClicked(String context) {
        this.track(this.newMetric("clicked", "more_menu", "conversational_messenger", context));
    }

    public void conversationsInMoreMenuClicked(String context) {
        this.track(this.newMetric("clicked", "messages", "conversational_messenger", context));
    }

    public void newConversationInMoreMenuClicked(String context) {
        this.track(this.newMetric("clicked", "new_conversation", "conversational_messenger", context));
    }

    public void ticketsInMoreMenuClicked(String context) {
        this.track(this.newMetric("clicked", "tickets", "conversational_messenger", context));
    }

    public void helpInMoreMenuClicked(String context) {
        this.track(this.newMetric("clicked", "help", "conversational_messenger", context));
    }

    public void startConversationFromRecentActivityClicked() {
        this.track(this.newMetric("clicked", "new_conversation", "conversational_messenger", "recent_activity"));
    }

    public void recentConversationClicked(String conversationId2) {
        this.track(this.newMetric("clicked", "recent_conversation", "conversational_messenger", "recent_activity").addMetaData(METADATA_CONVERSATION_ID, conversationId2));
    }

    public void recentTicketClicked(String ticketId) {
        this.track(this.newMetric("clicked", "recent_tickets", "conversational_messenger", "recent_activity").addMetaData(METADATA_TICKET_ID, ticketId));
    }

    private void track(MetricObject metric) {
        this.store.track(metric);
    }

    private MetricObject newMetric(String action, String object, String place, String context) {
        return this.createMetric("m5_metric", "messenger", action, object, place, context);
    }

    private MetricObject newEducateMetric(String action, String object, String place, String context) {
        return this.createMetric("educate_event", "educate", action, object, place, context);
    }

    private MetricObject newHelpCenterMetric(String action, String object, String place, String context, boolean isSearchBrowse) {
        String name = isSearchBrowse ? "search_browse_event" : "educate_event";
        return this.createMetric(name, "educate", action, object, place, context);
    }

    private MetricObject newCarouselMetric(String action, String object, String context, String instanceId, String source) {
        return this.newCarouselMetric(action, object, context, source).addMetaData(METADATA_INSTANCE_ID, instanceId);
    }

    private MetricObject newCarouselMetric(String action, String object, String context, String source) {
        return this.createMetric("carousel_metric", "messenger", action, object, "carousel_message", context).addMetaData(METADATA_SOURCE, source);
    }

    private MetricObject newSurveyMetric(String action, String object, String context) {
        return this.createMetric("survey_metric", "messenger", action, object, "survey", context);
    }

    private MetricObject createMetric(String name, String owner, String action, String object, String place, String context) {
        return new MetricObject(name, owner, UUID.randomUUID().toString(), this.userIdentity.getIntercomId(), action, object, place, context, this.timeProvider, this.appVersion, this.sdkVersion, this.appMinSdkVersion, this.appName);
    }

    private void addMetadataToMetricObject(MetricObject metricObject, @Nullable Map<String, java.lang.Object> eventMetaData) {
        if (eventMetaData != null && !eventMetaData.isEmpty()) {
            for (String key : eventMetaData.keySet()) {
                metricObject.addMetaData(key, eventMetaData.get(key));
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Place {
        public static final String MESSENGER = "messenger";
        public static final String IN_APP = "in_app";
        public static final String PUSH = "push";
        public static final String MESSENGER_CARD = "messenger_card";
        public static final String CAROUSEL_MESSAGE = "carousel_message";
        public static final String SEARCH_RESULTS = "search_results";
        public static final String ARTICLE = "article";
        public static final String COLLECTION_LIST = "collection_list";
        public static final String ARTICLE_LIST = "article_list";
        public static final String API = "api";
        public static final String LEGACY_ARTICLE_SEARCH_APP = "legacy_article_search_app";
        public static final String CONVERSATION = "conversation";
        public static final String MESSENGER_HOME_APP = "messenger_home_app";
        public static final String HOME_SCREEN = "home";
        public static final String SEARCH_BROWSE = "search_browse";
        public static final String SURVEY = "survey";
        public static final String SEARCH_BROWSE_CARD = "search_browse_card";
        public static final String CONVERSATIONAL_MESSENGER = "conversational_messenger";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CarouselSource {
        public static final String AUTOMATIC = "automatic";
        public static final String PROGRAMMATIC = "programmatic";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Context {
        public static final String FROM_LAUNCHER = "from_launcher";
        public static final String FROM_CUSTOM_LAUNCHER = "from_custom_launcher";
        public static final String FROM_ANDROID_BACK_BUTTON = "from_android_back_button";
        public static final String FROM_ONWARD_EXTERNAL_LINK = "from_onward_external_link";
        public static final String FROM_ONWARD_DEEP_LINK = "from_onward_deep_link";
        public static final String FROM_CLOSE_BUTTON = "from_close_button";
        public static final String FROM_CONVERSATION_LIST = "from_conversation_list";
        public static final String IN_NEW_CONVERSATION = "in_new_conversation";
        public static final String FROM_NEW_CONVERSATION = "from_new_conversation";
        public static final String FROM_CONVERSATION = "from_conversation";
        public static final String IN_CONVERSATION = "in_conversation";
        public static final String FROM_SNIPPET = "from_snippet";
        public static final String FROM_FULL = "from_full";
        public static final String FROM_CLICKING = "from_clicking";
        public static final String FROM_SCROLLING = "from_scrolling";
        public static final String FROM_AUTO = "from_auto";
        public static final String FROM_PUSH = "from_push";
        public static final String ON_ARTICLE = "on_article";
        public static final String FROM_HELP_CENTER_WEBVIEW = "from_help_center_webview";
        public static final String FROM_ARTICLE_ON_BUTTON = "from_article_on_button";
        public static final String CONVERSATION = "conversation";
        public static final String HOME_SCREEN = "home_screen";
        public static final String FROM_CLOSED_CONVERSATION = "from_closed_conversation";
        public static final String IN_FOLLOWUP_CONVERSATION = "in_followup_conversation";
        public static final String FROM_CAROUSEL = "from_carousel";
        public static final String FROM_RETRY = "from_retry";
        public static final String FROM_CTA = "from_cta";
        public static final String FROM_PERMISSION = "from_permission";
        public static final String FROM_PERMISSION_SKIPPED = "from_permission_skipped";
        public static final String NO_CONTEXT = "no_context";
        public static final String STYLE_HUMAN = "style_human";
        public static final String STYLE_BOT = "style_bot";
        public static final String REACTION_SAD = "reaction_sad";
        public static final String REACTION_NEUTRAL = "reaction_neutral";
        public static final String REACTION_HAPPY = "reaction_happy";
        public static final String ARTICLE = "article";
        public static final String MESSENGER = "messenger";
        public static final String FROM_PROGRAMMATIC = "from_programmatic";
        public static final String FROM_AUTOMATIC = "from_automatic";
        public static final String SPACE_MESSAGES = "messages";
        public static final String SPACE_HELP = "help";
        public static final String SPACE_HOME = "home";
        public static final String FROM_TICKETS_SPACE = "from_tickets_space";
        public static final String RECENT_ACTIVITY = "recent_activity";
        public static final String NEW_CONVERSATION = "new_conversation";
        public static final String EXISTING_CONVERSATION = "existing_conversation";
        public static final String MORE_MENU = "more_menu";
        public static final String CONVERSATIONAL_MESSENGER = "conversational_messenger";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Object {
        public static final String BADGE = "badge";
        public static final String CONVERSATION_LIST = "conversation_list";
        public static final String CONVERSATION = "conversation";
        public static final String NEW_CONVERSATION = "new_conversation";
        public static final String CREATE_TICKET_FORM = "create_ticket_form";
        public static final String TICKET_DETAILS = "ticket_details";
        public static final String MESSENGER = "messenger";
        public static final String MESSAGE = "message";
        public static final String REPLY = "reply";
        public static final String REACTION = "reaction";
        public static final String TEAMMATE_PROFILE = "teammate_profile";
        public static final String TEAM_PROFILE = "team_profile";
        public static final String ARTICLE = "article";
        public static final String HELP_CENTER = "help_center";
        public static final String HELP_CENTER_DATA_API = "help_center_data";
        public static final String OPERATOR_REPLY = "operator_reply";
        public static final String EXPANDED_GIF_INPUT = "expanded_gif_input";
        public static final String EXPANDED_IMAGE_INPUT = "expanded_image_input";
        public static final String EXTERNAL_LINK = "external_link";
        public static final String GIF_INPUT = "gif_input";
        public static final String TEXT_INPUT = "text_input";
        public static final String GALLERY_INPUT = "gallery_input";
        public static final String CAMERA_INPUT = "camera_input";
        public static final String INPUT = "input";
        public static final String IMAGE_INPUT = "image_input";
        public static final String FILE_INPUT = "file_input";
        public static final String VOICE_INPUT = "voice_input";
        public static final String IN_APP_ON_LEGACY_ACTIVITY = "in_app_on_legacy_activity";
        public static final String MESSENGER_SHEET = "messenger_sheet";
        public static final String QUICK_REPLY = "quick_reply";
        public static final String QUICK_REPLIES = "quick_replies";
        public static final String VIDEO_MESSAGE = "video_auto_message";
        public static final String COMPOSER_SUGGESTIONS = "composer_suggestions";
        public static final String SUGGESTION = "suggestion";
        public static final String CAROUSEL_MESSAGE = "carousel_message";
        public static final String CAROUSEL_MESSAGE_PRELOAD = "carousel_message_preload";
        public static final String CAROUSEL_PERMISSION_SKIPPED = "carousel_permission_skipped";
        public static final String CAROUSEL_PERMISSION_DIALOG = "carousel_permission_dialog";
        public static final String CAROUSEL_PERMISSION_SETTINGS = "carousel_permission_settings";
        public static final String ARTICLE_REACTION = "article_reaction";
        public static final String SEARCH_BROWSE_CARD = "search_browse_card";
        public static final String SEARCH_BROWSE_CARD_INPUT = "search_browse_card_input";
        public static final String SURVEY = "survey";
        public static final String SURVEY_STEP_ERROR = "step_error";
        public static final String SURVEY_STEP_LOADING = "step_load";
        public static final String ARTICLE_SUGGESTIONS = "article_suggestions";
        public static final String ARTICLE_SUGGESTION = "article_suggestion";
        public static final String INITIALISE = "initialise";
        public static final String LAUNCHER = "launcher";
        public static final String USER_HASH = "user_hash";
        public static final String LOGIN_UNIDENTIFIED_USER = "login_unidentified_user";
        public static final String REGISTER_UNIDENTIFIED_USER = "register_unidentified_user";
        public static final String LOGIN_IDENTIFIED_USER = "login_identified_user";
        public static final String REGISTER_IDENTIFIED_USER = "register_identified_user";
        public static final String LOGOUT = "logout";
        public static final String RESET = "reset";
        public static final String UPDATE_USER_CALLBACK = "update_user_callback";
        public static final String UPDATE_USER = "update_user";
        public static final String LOG_EVENT = "log_event";
        public static final String LOG_EVENT_METADATA = "log_event_metadata";
        public static final String PRESENT_MESSENGER = "present_messenger";
        public static final String PRESENT_INTERCOM = "present_intercom";
        public static final String PRESENT_INTERCOM_CONTENT = "present_intercom_content";
        public static final String PRESENT_MESSAGE_COMPOSER_INITIAL_MESSAGE = "present_message_composer_initial_message";
        public static final String PRESENT_MESSAGE_COMPOSER = "present_message_composer";
        public static final String PRESENT_CONVERSATION_LIST = "present_conversation_list";
        public static final String PRESENT_HELP_CENTER = "present_help_center";
        public static final String PRESENT_HELP_CENTER_COLLECTIONS = "present_help_center_collections";
        public static final String PRESENT_ARTICLE = "present_articles";
        public static final String FETCH_HELPCENTER_COLLECTIONS = "fetch_help_center_collections";
        public static final String FETCH_HELPCENTER_COLLECTION = "fetch_help_center_collection";
        public static final String SEARCH_HELP_CENTER = "search_help_center";
        public static final String PRESENT_CAROUSEL = "present_carousel";
        public static final String PRESENT_SURVEY = "present_survey";
        public static final String HANDLE_PUSH_NOTIFICATION = "handle_push_notification";
        public static final String SET_BOTTOM_PADDING = "set_bottom_padding";
        public static final String SPACE_HOME = "home";
        public static final String SPACE_MESSAGES = "messages";
        public static final String SPACE_HELP = "help";
        public static final String SPACE_TICKETS = "tickets";
        public static final String SET_INAPP_MESSAGE_VISIBILITY = "set_inapp_message_visibility";
        public static final String SET_LAUNCHER_VISIBILITY = "set_launcher_visibility";
        public static final String HIDE_INTERCOM = "hide_intercom";
        public static final String UNREAD_CONVERSATION_COUNT = "unread_conversation_count";
        public static final String ENABLE_LOGGING = "enable_logging";
        public static final String HANDLE_PUSH_NOTIFICATION_CUSTOM = "handle_push_notification_custom";
        public static final String ADD_UNREAD_CONVERSATION_COUNT_LISTENER = "add_unread_conversation_count_listener";
        public static final String REMOVE_UNREAD_CONVERSATION_COUNT_LISTENER = "remove_unread_conversation_count_listener";
        public static final String REGISTER_LATER_INIT = "register_later_init";
        public static final String UNREGISTER_LATER_INIT = "unregister_later_init";
        public static final String WE_RUN_ON_INTERCOM = "we_run_on_intercom";
        public static final String FIN_DICTATION = "fin_dictation";
        public static final String MORE_MENU = "more_menu";
        public static final String MESSAGES = "messages";
        public static final String TICKETS = "tickets";
        public static final String HELP = "help";
        public static final String RECENT_CONVERSATION = "recent_conversation";
        public static final String RECENT_TICKET = "recent_tickets";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Action {
        public static final String OPENED = "opened";
        public static final String CLOSED = "closed";
        public static final String TYPED = "typed";
        public static final String SENT = "sent";
        public static final String RECEIVED = "received";
        public static final String VIEWED = "viewed";
        public static final String DISMISSED = "dismissed";
        public static final String SEARCHED = "searched";
        public static final String CLICKED = "clicked";
        public static final String STARTED = "started";
        public static final String LOADED = "loaded";
        public static final String FAILED = "failed";
        public static final String COMPLETED = "completed";
        public static final String REQUESTED = "requested";
        public static final String USED = "used";
        public static final String SUBMITTED = "submitted";
        public static final String VOICE_RECOGNITION_STARTED = "voice_recognition_started";
        public static final String VOICE_RECOGNITION_ENDED = "voice_recognition_ended";
    }

    public static @interface InAppMessageViewContext {
        public static final int SNIPPET = 0;
        public static final int FULL = 1;
    }

    public static enum ReactionLocation {
        CONVERSATION,
        IN_APP,
        LINK;

    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Name {
        public static final String MESSENGER = "m5_metric";
        public static final String EDUCATE = "educate_event";
        public static final String CAROUSEL = "carousel_metric";
        public static final String SURVEY = "survey_metric";
        public static final String SEARCH_BROWSE = "search_browse_event";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Owner {
        public static final String MESSENGER = "messenger";
        public static final String EDUCATE = "educate";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CloseActionContext {
        public static final int CLOSE_BUTTON = 0;
        public static final int BACK_BUTTON = 1;
    }
}

