/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.lightbox;

import android.animation.ArgbEvaluator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.transition.Transition;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import coil.request.ImageRequest;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.lightbox.LightBoxImageView;
import io.intercom.android.sdk.lightbox.LightBoxListener;
import io.intercom.android.sdk.utilities.IntercomCoilKt;

public class LightBoxActivity
extends AppCompatActivity
implements LightBoxListener {
    private static final String EXTRA_IMAGE_URL = "extra_image_url";
    private static final String EXTRA_ACTIVITY_FULLSCREEN = "extra_activity_fullscreen";
    private static final int ANIMATION_TIME_MS = 300;
    public static final String TRANSITION_KEY = "lightbox_image";
    private String imageUrl = "";
    ViewGroup rootView;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        Bundle data = this.getIntent().getExtras();
        if (data != null) {
            this.imageUrl = data.getString(EXTRA_IMAGE_URL, "");
            if (data.getBoolean(EXTRA_ACTIVITY_FULLSCREEN, false)) {
                this.requestWindowFeature(1);
                this.getWindow().setFlags(1024, 1024);
            }
        }
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.intercom_activity_lightbox);
        this.rootView = (ViewGroup)this.findViewById(R.id.root_view);
        LightBoxImageView fullImage = (LightBoxImageView)this.findViewById(R.id.full_image);
        fullImage.setTransitionName(TRANSITION_KEY);
        this.loadImage((ImageView)fullImage);
        this.reloadAfterTransition(fullImage);
        fullImage.setLightBoxListener(this);
        this.fadeIn();
    }

    private void reloadAfterTransition(final LightBoxImageView fullImage) {
        Transition sharedElementEnterTransition = this.getWindow().getSharedElementEnterTransition();
        sharedElementEnterTransition.addListener(new Transition.TransitionListener(){

            public void onTransitionStart(Transition transition2) {
            }

            public void onTransitionEnd(Transition transition2) {
                Handler handler = new Handler();
                handler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        LightBoxActivity.this.loadImage((ImageView)fullImage);
                    }
                }, 10L);
            }

            public void onTransitionCancel(Transition transition2) {
            }

            public void onTransitionPause(Transition transition2) {
            }

            public void onTransitionResume(Transition transition2) {
            }
        });
    }

    private void loadImage(ImageView fullImage) {
        ImageRequest imageRequest = new ImageRequest.Builder(fullImage.getContext()).data((Object)this.imageUrl).crossfade(true).error(R.drawable.intercom_image_load_failed).target(fullImage).build();
        IntercomCoilKt.loadIntercomImage(fullImage.getContext(), imageRequest);
    }

    private void fadeIn() {
        int colorFrom = ContextCompat.getColor((Context)this, (int)R.color.intercom_full_transparent_full_black);
        int colorTo = ContextCompat.getColor((Context)this, (int)R.color.intercom_transparent_black_lightbox);
        ValueAnimator colorAnimation = ValueAnimator.ofObject((TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{colorFrom, colorTo});
        colorAnimation.setDuration(300L);
        colorAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animator) {
                LightBoxActivity.this.rootView.setBackgroundColor(((Integer)animator.getAnimatedValue()).intValue());
            }
        });
        colorAnimation.start();
    }

    private void fadeOut() {
        int colorFrom = ContextCompat.getColor((Context)this, (int)R.color.intercom_transparent_black_lightbox);
        int colorTo = ContextCompat.getColor((Context)this, (int)R.color.intercom_full_transparent_full_black);
        ValueAnimator colorAnimation = ValueAnimator.ofObject((TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{colorFrom, colorTo});
        colorAnimation.setDuration(300L);
        colorAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animator) {
                LightBoxActivity.this.rootView.setBackgroundColor(((Integer)animator.getAnimatedValue()).intValue());
            }
        });
        colorAnimation.start();
    }

    public static Intent imageIntent(Context context, String url, boolean fullScreen) {
        return new Intent(context, LightBoxActivity.class).putExtra(EXTRA_IMAGE_URL, url).putExtra(EXTRA_ACTIVITY_FULLSCREEN, fullScreen);
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.closeLightBox();
    }

    @Override
    public void closeLightBox() {
        this.fadeOut();
        this.supportFinishAfterTransition();
    }
}

