/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.api.CallbackHolder;
import io.intercom.android.sdk.api.ExternalUploadApi;
import io.intercom.android.sdk.api.HeaderInterceptor;
import io.intercom.android.sdk.api.KotlinXConvertorFactory;
import io.intercom.android.sdk.api.MessengerApi;
import io.intercom.android.sdk.api.RateLimiter;
import io.intercom.android.sdk.api.RetryInterceptor;
import io.intercom.android.sdk.api.ShutdownInterceptor;
import io.intercom.android.sdk.api.ShutdownState;
import io.intercom.android.sdk.api.SurveyApi;
import io.intercom.android.sdk.api.TaggingSocketFactory;
import io.intercom.android.sdk.api.UserIdentityInterceptor;
import io.intercom.android.sdk.helpcenter.api.HelpCenterApi;
import io.intercom.android.sdk.helpcenter.utils.networking.NetworkResponseAdapterFactory;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.AppIdentity;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.m5.home.data.HomeCardType;
import io.intercom.android.sdk.m5.home.data.HomeCards;
import io.intercom.android.sdk.metrics.ops.OpsMetricTracker;
import io.intercom.android.sdk.models.Ticket;
import io.intercom.android.sdk.models.TicketAttributeType;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Store;
import io.intercom.android.sdk.tickets.create.data.TicketApi;
import io.intercom.android.sdk.utilities.UtilsKt;
import io.intercom.android.sdk.utilities.commons.TimeProvider;
import io.intercom.android.sdk.utilities.gson.RuntimeTypeAdapterFactory;
import java.io.File;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import okhttp3.Cache;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class ApiFactory {
    private static final String CACHE_NAME = "Intercom_SDK/HttpCache";
    private static final String PROTOCOL = "https://";
    private static final String PARTIAL_HOSTNAME_US = ".mobile-messenger.intercom.com";
    private static final String PARTIAL_HOSTNAME_AUS = ".mobile-messenger.au.intercom.io";
    private static final String PARTIAL_HOSTNAME_EU = ".mobile-messenger.eu.intercom.io";
    private static final String ENDPOINT = "/messenger/mobile/";
    private static final int CACHE_SIZE = 0xA00000;
    private static final int MAX_DNS_SEGMENT_SIZE = 63;
    private static final int INTERCOM_TRAFFIC_TAG = 46837266;
    @Nullable
    private static OkHttpClient okHttpClient = null;
    @Nullable
    private static OkHttpClient okHttpClientWithoutHeaders = null;
    @Nullable
    private static Retrofit legacyRetrofit = null;
    @Nullable
    private static Retrofit kotlinxRetrofit = null;
    @Nullable
    private static Retrofit retrofitWithoutHeaders = null;
    @Nullable
    public static MessengerApi messengerApi;
    @Nullable
    public static ExternalUploadApi uploadApi;

    public static Api create(Context context, AppIdentity appIdentity, UserIdentity userIdentity, Store<State> store, String hostname, Provider<AppConfig> appConfigProvider2, Gson gson, OpsMetricTracker opsMetricTracker) {
        OkHttpClient httpClient = ApiFactory.createConfigurableHttpClient(context, appIdentity, userIdentity);
        return ApiFactory.createWithNetworkClient(context, appIdentity, userIdentity, httpClient, store, hostname, appConfigProvider2, gson, opsMetricTracker);
    }

    public static HelpCenterApi createHelpCenterApi(Context context, AppIdentity appIdentity, UserIdentity userIdentity, String hostname, Gson gson) {
        OkHttpClient httpClient = ApiFactory.createConfigurableHttpClient(context, appIdentity, userIdentity);
        ApiFactory.createRetrofit(hostname, httpClient, gson);
        return (HelpCenterApi)kotlinxRetrofit.create(HelpCenterApi.class);
    }

    public static SurveyApi createSurveyApi(Context context, AppIdentity appIdentity, UserIdentity userIdentity, String hostname, Gson gson) {
        OkHttpClient httpClient = ApiFactory.createConfigurableHttpClient(context, appIdentity, userIdentity);
        ApiFactory.createRetrofit(hostname, httpClient, gson);
        return (SurveyApi)legacyRetrofit.create(SurveyApi.class);
    }

    public static TicketApi createTicketApi(Context context, AppIdentity appIdentity, UserIdentity userIdentity, String hostname, Gson gson) {
        OkHttpClient httpClient = ApiFactory.createConfigurableHttpClient(context, appIdentity, userIdentity);
        Gson gson1 = new GsonBuilder().registerTypeAdapterFactory(ApiFactory.getTicketTypeAdapterFactory()).create();
        ApiFactory.createRetrofit(hostname, httpClient, gson1);
        return (TicketApi)legacyRetrofit.create(TicketApi.class);
    }

    public static Api createWithNetworkClient(Context context, AppIdentity appIdentity, UserIdentity userIdentity, OkHttpClient client, Store<State> store, String hostname, Provider<AppConfig> appConfigProvider2, Gson gson, OpsMetricTracker opsMetricTracker) {
        if (messengerApi == null) {
            messengerApi = ApiFactory.createMessengerApi(client, hostname, gson);
        }
        if (uploadApi == null) {
            uploadApi = (ExternalUploadApi)retrofitWithoutHeaders.create(ExternalUploadApi.class);
        }
        CallbackHolder callbackHolder = new CallbackHolder(store);
        RateLimiter rateLimiter = new RateLimiter(appConfigProvider2.get());
        return new Api(context, appIdentity, userIdentity, client, messengerApi, callbackHolder, rateLimiter, store, appConfigProvider2, opsMetricTracker);
    }

    public static OkHttpClient createConfigurableHttpClient(Context context, AppIdentity appIdentity, UserIdentity userIdentity) {
        OkHttpClient.Builder builder;
        if (okHttpClient == null) {
            builder = new OkHttpClient.Builder().readTimeout(2L, TimeUnit.MINUTES).connectTimeout(2L, TimeUnit.MINUTES).writeTimeout(2L, TimeUnit.MINUTES).socketFactory((SocketFactory)new TaggingSocketFactory(SocketFactory.getDefault(), 46837266)).addInterceptor((Interceptor)new UserIdentityInterceptor(userIdentity)).addInterceptor((Interceptor)new RetryInterceptor(new RetryInterceptor.Sleeper())).addInterceptor((Interceptor)new ShutdownInterceptor(new ShutdownState(context, appIdentity, TimeProvider.SYSTEM))).addNetworkInterceptor((Interceptor)HeaderInterceptor.create(context, appIdentity));
            File systemCacheDirectory = context.getCacheDir();
            if (systemCacheDirectory != null) {
                File responseCacheDirectory = new File(systemCacheDirectory.getAbsolutePath(), CACHE_NAME);
                builder.cache(new Cache(responseCacheDirectory, 0xA00000L));
            }
            okHttpClient = builder.build();
        }
        if (okHttpClientWithoutHeaders == null) {
            builder = new OkHttpClient.Builder();
            okHttpClientWithoutHeaders = builder.build();
        }
        return okHttpClient;
    }

    private static MessengerApi createMessengerApi(OkHttpClient apiHttpClient, String hostname, Gson gson) {
        RuntimeTypeAdapterFactory<HomeCards.UnSupported> typeAdapterFactory = RuntimeTypeAdapterFactory.of(HomeCards.class, "type").registerSubtype(HomeCards.HomeSpacesData.class, HomeCardType.SPACES.name().toLowerCase()).registerSubtype(HomeCards.HomeNewConversationData.class, HomeCardType.NEW_CONVERSATION.name().toLowerCase()).registerSubtype(HomeCards.HomeRecentConversationData.class, HomeCardType.RECENT_CONVERSATION.name().toLowerCase()).registerSubtype(HomeCards.HomeHelpCenterData.class, HomeCardType.HELP_CENTER.name().toLowerCase()).registerSubtype(HomeCards.HomeExternalLinkData.class, HomeCardType.EXTERNAL_LINKS.name().toLowerCase()).registerSubtype(HomeCards.HomeMessengerAppData.class, HomeCardType.MESSENGER_APP.name().toLowerCase()).registerSubtype(HomeCards.HomeRecentTicketsData.class, HomeCardType.TICKETS.name().toLowerCase()).registerIgnoredSubtype(HomeCards.UnSupported.class, "UnSupported");
        Gson gson1 = new GsonBuilder().registerTypeAdapterFactory(typeAdapterFactory).registerTypeAdapterFactory(ApiFactory.getTicketTypeAdapterFactory()).create();
        ApiFactory.createRetrofit(hostname, apiHttpClient, gson1);
        return (MessengerApi)legacyRetrofit.create(MessengerApi.class);
    }

    private static void createRetrofit(String hostname, OkHttpClient apiHttpClient, Gson gson) {
        if (legacyRetrofit == null) {
            legacyRetrofit = new Retrofit.Builder().baseUrl(hostname).addCallAdapterFactory((CallAdapter.Factory)new NetworkResponseAdapterFactory()).client(apiHttpClient).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)gson)).build();
        }
        if (kotlinxRetrofit == null) {
            kotlinxRetrofit = new Retrofit.Builder().baseUrl(hostname).addCallAdapterFactory((CallAdapter.Factory)new NetworkResponseAdapterFactory()).client(apiHttpClient).addConverterFactory(KotlinXConvertorFactory.INSTANCE.getConvertorFactory()).build();
        }
        if (retrofitWithoutHeaders == null) {
            Retrofit.Builder builder = new Retrofit.Builder().baseUrl(hostname).addCallAdapterFactory((CallAdapter.Factory)new NetworkResponseAdapterFactory()).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)gson));
            if (okHttpClientWithoutHeaders != null) {
                builder.client(okHttpClientWithoutHeaders);
            }
            retrofitWithoutHeaders = builder.build();
        }
    }

    public static String getServerUrl(AppIdentity appIdentity, Context context) {
        String customHost = UtilsKt.readHostFromManifest(context);
        String hostName = TextUtils.isEmpty((CharSequence)customHost) ? ApiFactory.getFullHostname(appIdentity.appId(), context) : ApiFactory.createUniqueIdentifier(appIdentity.appId()) + customHost;
        return ApiFactory.convertHostnameToUrl(hostName);
    }

    static String convertHostnameToUrl(String hostname) {
        return PROTOCOL + hostname + ENDPOINT;
    }

    static String getFullHostname(String appId, Context context) {
        return ApiFactory.createUniqueIdentifier(appId) + ApiFactory.getCorrectServerHostname(UtilsKt.getServerRegionFromManifest(context), context);
    }

    private static String getCorrectServerHostname(int region, Context context) {
        if (region == UtilsKt.getRegionCode(context, R.integer.intercom_server_region_aus)) {
            return PARTIAL_HOSTNAME_AUS;
        }
        if (region == UtilsKt.getRegionCode(context, R.integer.intercom_server_region_eu)) {
            return PARTIAL_HOSTNAME_EU;
        }
        if (region == UtilsKt.getRegionCode(context, R.integer.intercom_server_region_us) || region == 0) {
            LumberMill.getLogger().i("Defaulting to US region, since no explicit region was mentioned. For more info on regions, please visit Intercom Android SDK documentation", new Object[0]);
            return PARTIAL_HOSTNAME_US;
        }
        LumberMill.getLogger().e("Incorrect value for region is provided in AndroidManifest.xml file. Please use one of the available regions values from provided list. For more info on regions, please visit Intercom Android SDK documentation", new Object[0]);
        return "";
    }

    static String createUniqueIdentifier(String appId) {
        String identifier = ApiFactory.removeInvalidCharacters(appId) + "-android";
        if (identifier.length() > 63) {
            int endIndex = 63;
            if (identifier.charAt(62) == '-') {
                --endIndex;
            }
            identifier = identifier.substring(0, endIndex);
        }
        return identifier;
    }

    public static String removeInvalidCharacters(String appId) {
        return appId.replaceAll("[^A-Za-z0-9\\-$]", "");
    }

    private static RuntimeTypeAdapterFactory<Ticket.TicketAttribute> getTicketTypeAdapterFactory() {
        RuntimeTypeAdapterFactory<Ticket.TicketAttribute> ticketAttributeTypeAdapterFactory = RuntimeTypeAdapterFactory.of(Ticket.TicketAttribute.class, "type").registerSubtype(Ticket.TicketAttribute.PrimitiveAttribute.class, TicketAttributeType.STRING.name().toLowerCase()).registerSubtype(Ticket.TicketAttribute.PrimitiveAttribute.class, TicketAttributeType.INTEGER.name().toLowerCase()).registerSubtype(Ticket.TicketAttribute.PrimitiveAttribute.class, TicketAttributeType.FLOAT.name().toLowerCase()).registerSubtype(Ticket.TicketAttribute.PrimitiveAttribute.class, TicketAttributeType.BOOLEAN.name().toLowerCase()).registerSubtype(Ticket.TicketAttribute.ListAttribute.class, TicketAttributeType.LIST.name().toLowerCase()).registerSubtype(Ticket.TicketAttribute.DateTimeAttribute.class, TicketAttributeType.DATETIME.name().toLowerCase()).registerSubtype(Ticket.TicketAttribute.FilesAttribute.class, TicketAttributeType.FILES.name().toLowerCase()).registerIgnoredSubtype(Ticket.TicketAttribute.UnSupported.class, "UnSupported");
        return ticketAttributeTypeAdapterFactory;
    }
}

