/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import android.content.Context;
import io.intercom.android.sdk.api.Platform;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0010\u0010\u000e\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\rH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"ANDROID_HEADER", "", "CORDOVA_HEADER", "CORDOVA_VERSION", "FLUTTER_HEADER", "FLUTTER_VERSION", "NATIVE_SDK", "REACT_NATIVE_HEADER", "REACT_NATIVE_VERSION", "WRAPPER_PREFS", "getPlatform", "Lio/intercom/android/sdk/api/Platform;", "context", "Landroid/content/Context;", "getPlatformIdentifier", "intercom-sdk-base_release"})
public final class PlatformIdentifierUtilKt {
    @NotNull
    public static final String WRAPPER_PREFS = "intercomsdk_wrapper_prefs";
    @NotNull
    public static final String CORDOVA_VERSION = "cordova_version";
    @NotNull
    public static final String REACT_NATIVE_VERSION = "react_native_version";
    @NotNull
    public static final String FLUTTER_VERSION = "flutter_version";
    @NotNull
    public static final String ANDROID_HEADER = "intercom-android-sdk";
    @NotNull
    public static final String CORDOVA_HEADER = "intercom-sdk-cordova";
    @NotNull
    public static final String REACT_NATIVE_HEADER = "intercom-sdk-react-native";
    @NotNull
    public static final String FLUTTER_HEADER = "intercom-sdk-flutter";
    @NotNull
    public static final String NATIVE_SDK = "intercom-sdk-native";

    private static final Platform getPlatform(Context context) {
        String cordovaVersion = context.getSharedPreferences(WRAPPER_PREFS, 0).getString(CORDOVA_VERSION, "");
        String reactNativeVersion = context.getSharedPreferences(WRAPPER_PREFS, 0).getString(REACT_NATIVE_VERSION, "");
        String flutterVersion = context.getSharedPreferences(WRAPPER_PREFS, 0).getString(FLUTTER_VERSION, "");
        return !Intrinsics.areEqual((Object)cordovaVersion, (Object)"") ? Platform.Cordova : (!Intrinsics.areEqual((Object)reactNativeVersion, (Object)"") ? Platform.ReactNative : (!Intrinsics.areEqual((Object)flutterVersion, (Object)"") ? Platform.Flutter : Platform.Native));
    }

    @NotNull
    public static final String getPlatformIdentifier(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return PlatformIdentifierUtilKt.getPlatform(context).getIdentifier();
    }
}

