/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import com.intercom.twig.Twig;
import com.squareup.otto.Bus;
import io.intercom.android.sdk.actions.Actions;
import io.intercom.android.sdk.api.BaseCallback;
import io.intercom.android.sdk.api.ErrorObject;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.ConversationResponse;
import io.intercom.android.sdk.models.ConversationsResponse;
import io.intercom.android.sdk.models.LogEventResponse;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.UsersResponse;
import io.intercom.android.sdk.models.carousel.CarouselResponse;
import io.intercom.android.sdk.models.events.ConversationEvent;
import io.intercom.android.sdk.models.events.FormSubmitSuccessEvent;
import io.intercom.android.sdk.models.events.NewConversationEvent;
import io.intercom.android.sdk.models.events.NewTriggerConversationEvent;
import io.intercom.android.sdk.models.events.ReplyEvent;
import io.intercom.android.sdk.models.events.failure.ConversationFailedEvent;
import io.intercom.android.sdk.models.events.failure.FetchCarouselFailedEvent;
import io.intercom.android.sdk.models.events.failure.FormSubmitFailedEvent;
import io.intercom.android.sdk.models.events.failure.NewConversationFailedEvent;
import io.intercom.android.sdk.models.events.failure.ReplyFailedEvent;
import io.intercom.android.sdk.state.ReplyPart;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Store;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

class CallbackHolder {
    final Bus bus;
    final Store<State> store;
    private static final Twig TWIG = LumberMill.getLogger();

    CallbackHolder(Bus bus, Store<State> store) {
        this.bus = bus;
        this.store = store;
    }

    BaseCallback<LogEventResponse.Builder> logEventCallback() {
        return new BaseCallback<LogEventResponse.Builder>(){

            @Override
            public void onSuccess(LogEventResponse.Builder builder) {
                LogEventResponse response = builder.build();
                CallbackHolder.this.store.dispatch(Actions.baseResponseReceived(response));
                CallbackHolder.this.store.dispatch(Actions.unreadConversationsSuccess(response));
                CallbackHolder.this.store.dispatch(Actions.carouselUpdated(response.getCarousel()));
            }
        };
    }

    BaseCallback<UsersResponse.Builder> unreadCallback() {
        return new BaseCallback<UsersResponse.Builder>(){

            @Override
            public void onSuccess(UsersResponse.Builder builder) {
                UsersResponse response = builder.build();
                CallbackHolder.this.store.dispatch(Actions.baseResponseReceived(response));
                CallbackHolder.this.store.dispatch(Actions.unreadConversationsSuccess(response));
            }
        };
    }

    Callback<ConversationsResponse.Builder> inboxCallback() {
        return new BaseCallback<ConversationsResponse.Builder>(){

            @Override
            public void onSuccess(ConversationsResponse.Builder builder) {
                ConversationsResponse response = builder.build();
                CallbackHolder.this.store.dispatch(Actions.baseResponseReceived(response));
                CallbackHolder.this.store.dispatch(Actions.fetchInboxSuccess(response));
            }

            @Override
            public void onError(ErrorObject errorObject) {
                CallbackHolder.this.store.dispatch(Actions.fetchInboxFailed());
            }
        };
    }

    Callback<Part.Builder> replyCallback(final int position, final boolean isUpload, final String partId, final String conversationId) {
        return new BaseCallback<Part.Builder>(){

            @Override
            public void onSuccess(Part.Builder builder) {
                Part response = builder.build();
                CallbackHolder.this.store.dispatch(Actions.conversationReplySuccess(new ReplyPart(response, conversationId)));
                CallbackHolder.this.bus.post((Object)new ReplyEvent(response, position, partId, conversationId));
            }

            @Override
            public void onError(ErrorObject errorObject) {
                CallbackHolder.this.bus.post((Object)new ReplyFailedEvent(position, isUpload, partId));
            }
        };
    }

    Callback<Conversation.Builder> conversationCallback(final String uuid) {
        return new BaseCallback<Conversation.Builder>(){

            @Override
            public void onSuccess(Conversation.Builder builder) {
                CallbackHolder.this.conversationFetchSuccess(builder.build(), uuid);
            }

            @Override
            public void onError(ErrorObject errorObject) {
                CallbackHolder.this.bus.post((Object)new ConversationFailedEvent());
            }
        };
    }

    Callback<ConversationResponse.Builder> newConversationCallback(final int position, final String partId) {
        return new BaseCallback<ConversationResponse.Builder>(){

            @Override
            public void onSuccess(ConversationResponse.Builder builder) {
                ConversationResponse response = builder.build();
                Conversation conversation = response.getConversation();
                CallbackHolder.this.store.dispatch(Actions.baseResponseReceived(response));
                CallbackHolder.this.store.dispatch(Actions.newConversationSuccess(conversation));
                CallbackHolder.this.bus.post((Object)new NewConversationEvent(conversation, partId));
            }

            @Override
            protected void onError(ErrorObject errorObject) {
                CallbackHolder.this.bus.post((Object)new NewConversationFailedEvent(position, partId));
            }
        };
    }

    Callback<Conversation.Builder> triggeredInboundBotCallback(final int position, final String partId) {
        return new BaseCallback<Conversation.Builder>(){

            @Override
            public void onSuccess(Conversation.Builder builder) {
                Conversation conversation = builder.build();
                CallbackHolder.this.store.dispatch(Actions.newConversationSuccess(conversation));
                CallbackHolder.this.bus.post((Object)new NewTriggerConversationEvent(conversation, partId));
            }

            @Override
            protected void onError(ErrorObject errorObject) {
                CallbackHolder.this.bus.post((Object)new NewConversationFailedEvent(position, partId));
            }
        };
    }

    Callback<Conversation.Builder> submitFormCallback(final String partId, final String attributeId) {
        return new BaseCallback<Conversation.Builder>(){

            @Override
            public void onSuccess(Conversation.Builder builder) {
                Conversation conversation = builder.build();
                CallbackHolder.this.store.dispatch(Actions.fetchConversationSuccess(conversation));
                CallbackHolder.this.bus.post((Object)new FormSubmitSuccessEvent(conversation, partId));
            }

            @Override
            public void onError(ErrorObject errorObject) {
                CallbackHolder.this.bus.post((Object)new FormSubmitFailedEvent(partId, attributeId));
            }
        };
    }

    Callback<Void> loggingCallback(final String action) {
        return new Callback<Void>(){

            public void onResponse(Call<Void> call, Response<Void> response) {
                TWIG.internal(action + " success");
            }

            public void onFailure(Call<Void> call, Throwable throwable) {
                TWIG.internal(action + " failure");
            }
        };
    }

    Callback<CarouselResponse.Builder> getCarouselCallback(final String carouselId) {
        return new BaseCallback<CarouselResponse.Builder>(){

            @Override
            protected void onSuccess(CarouselResponse.Builder builder) {
                CallbackHolder.this.store.dispatch(Actions.programmaticCarouselSuccess(builder.build().carousel().build()));
            }

            @Override
            protected void onError(ErrorObject errorDetails) {
                CallbackHolder.this.store.dispatch(Actions.programmaticCarouselError(FetchCarouselFailedEvent.create(carouselId, errorDetails)));
            }
        };
    }

    private void conversationFetchSuccess(Conversation conversation, String uuid) {
        Part part;
        Part part2 = part = conversation.getParts().isEmpty() ? Part.NULL : conversation.getParts().get(0);
        if (!Part.NULL.equals(part) && !part.getUuid().isEmpty() && part.getUuid().equals(uuid)) {
            this.store.dispatch(Actions.newConversationSuccess(conversation));
            this.bus.post((Object)new NewTriggerConversationEvent(conversation, part.getId()));
        } else {
            this.store.dispatch(Actions.fetchConversationSuccess(conversation));
            this.bus.post((Object)new ConversationEvent.Builder(conversation).build());
        }
    }
}

