/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.m5.push;

import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import com.intercom.twig.Twig;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.m5.push.IntercomNotificationHandler;
import io.intercom.android.sdk.m5.push.IntercomPushClientHandler;
import io.intercom.android.sdk.m5.push.IntercomPushData;
import io.intercom.android.sdk.user.DeviceData;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u001a\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\"\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001f0\u001eJ\b\u0010 \u001a\u00020!H\u0002J\u0016\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001fJ\u0018\u0010&\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010%\u001a\u00020\u001fH\u0002J\u0018\u0010'\u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010%\u001a\u00020\u001fH\u0002R#\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R#\u0010\n\u001a\n \u0005*\u0004\u0018\u00010\u000b0\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\t\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000f\u001a\n \u0005*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0011\u001a\n \u0005*\u0004\u0018\u00010\u00120\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\t\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006("}, d2={"Lio/intercom/android/sdk/m5/push/IntercomPushClientHandler;", "", "()V", "api", "Lio/intercom/android/sdk/api/Api;", "kotlin.jvm.PlatformType", "getApi", "()Lio/intercom/android/sdk/api/Api;", "api$delegate", "Lkotlin/Lazy;", "appConfig", "Lio/intercom/android/sdk/identity/AppConfig;", "getAppConfig", "()Lio/intercom/android/sdk/identity/AppConfig;", "appConfig$delegate", "twig", "Lcom/intercom/twig/Twig;", "userIdentity", "Lio/intercom/android/sdk/identity/UserIdentity;", "getUserIdentity", "()Lio/intercom/android/sdk/identity/UserIdentity;", "userIdentity$delegate", "handlePush", "", "context", "Landroid/content/Context;", "message", "Landroid/os/Bundle;", "intercomPushData", "Lio/intercom/android/sdk/m5/push/IntercomPushData;", "", "", "hasUserHashIfNeeded", "", "onNewToken", "application", "Landroid/app/Application;", "token", "sendTokenToIntercom", "shouldSendDeviceToken", "intercom-sdk-base_release"})
public final class IntercomPushClientHandler {
    private final Twig twig = LumberMill.getLogger();
    @NotNull
    private final Lazy userIdentity$delegate = LazyKt.lazy((Function0)userIdentity.2.INSTANCE);
    @NotNull
    private final Lazy api$delegate = LazyKt.lazy((Function0)api.2.INSTANCE);
    @NotNull
    private final Lazy appConfig$delegate = LazyKt.lazy((Function0)appConfig.2.INSTANCE);

    private final UserIdentity getUserIdentity() {
        Lazy lazy = this.userIdentity$delegate;
        return (UserIdentity)lazy.getValue();
    }

    private final Api getApi() {
        Lazy lazy = this.api$delegate;
        return (Api)lazy.getValue();
    }

    private final AppConfig getAppConfig() {
        Lazy lazy = this.appConfig$delegate;
        return (AppConfig)lazy.getValue();
    }

    public final void onNewToken(@NotNull Application application, @NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        if (((CharSequence)token).length() == 0) {
            this.twig.e("sendTokenToIntercom() was called with a null or empty token. This user will not receive push notifications until a valid device token is sent.", new Object[0]);
            return;
        }
        Injector.initIfCachedCredentials(application);
        if (Injector.isNotInitialised()) {
            this.twig.w("Token not sent because Intercom is not initialised", new Object[0]);
            return;
        }
        if (this.shouldSendDeviceToken((Context)application, token)) {
            this.sendTokenToIntercom((Context)application, token);
        }
    }

    public final void handlePush(@NotNull Context context, @NotNull Bundle message) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.twig.d("handlePush  " + message, new Object[0]);
        this.handlePush(context, IntercomPushData.Companion.createFrom(context, message));
    }

    public final void handlePush(@NotNull Context context, @NotNull Map<String, String> message) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(message, (String)"message");
        this.twig.d("handlePush from FCM  " + message, new Object[0]);
        this.handlePush(context, IntercomPushData.Companion.createFrom(context, message));
    }

    private final void handlePush(Context context, IntercomPushData intercomPushData) {
        if (intercomPushData == null) {
            this.twig.i("This is not a Intercom push message", new Object[0]);
            return;
        }
        if (!this.getUserIdentity().identityExists()) {
            this.twig.i("Can't create push message as we have no user identity. This can be caused by messages being sent to a logged out user.", new Object[0]);
            IntercomNotificationHandler.INSTANCE.clear(context);
            return;
        }
        IntercomNotificationHandler.INSTANCE.processIntercomPushNotification$intercom_sdk_base_release(context, intercomPushData);
    }

    private final boolean shouldSendDeviceToken(Context context, String token) {
        return !DeviceData.hasCachedDeviceToken(context, token);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasUserHashIfNeeded() {
        if (!this.getAppConfig().isReceivedFromServer()) return false;
        if (this.getAppConfig().isIdentityVerificationEnabled()) {
            if (!this.getAppConfig().isIdentityVerificationEnabled()) return false;
        }
        String string2 = this.getUserIdentity().getHmac();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"userIdentity.hmac");
        if (((CharSequence)string2).length() <= 0) return false;
        return true;
    }

    private final void sendTokenToIntercom(Context context, String token) {
        if (this.getUserIdentity().identityExists() && this.hasUserHashIfNeeded()) {
            this.getApi().setDeviceToken(token);
        }
        DeviceData.cacheDeviceToken(context, token);
    }
}

