/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.PorterDuff;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import com.intercom.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.blocks.lib.interfaces.LinkListBlock;
import io.intercom.android.sdk.blocks.lib.models.BlockMetadata;
import io.intercom.android.sdk.blocks.lib.models.Link;
import io.intercom.android.sdk.blocks.lib.models.LinkList;
import io.intercom.android.sdk.helpcenter.articles.ArticleActivity;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.m5.IntercomRootActivityLauncher;
import io.intercom.android.sdk.utilities.ColorUtils;
import io.intercom.android.sdk.utilities.LinkOpener;
import java.util.Collections;

class LinkListRenderer
implements LinkListBlock {
    private final Api api;
    private final Provider<AppConfig> appConfigProvider;
    private final String conversationId;

    LinkListRenderer(Api api2, Provider<AppConfig> appConfigProvider2, String conversationId) {
        this.api = api2;
        this.appConfigProvider = appConfigProvider2;
        this.conversationId = conversationId;
    }

    @Override
    public View addLinkListBlock(LinkList block, BlockMetadata blockMetadata, ViewGroup parent) {
        Context context = parent.getContext();
        LayoutInflater layoutInflater = LayoutInflater.from((Context)context);
        FrameLayout rootLayout = (FrameLayout)layoutInflater.inflate(R.layout.intercom_card_list_block, parent, false);
        int primaryColor = ColorUtils.primaryOrDarkColor(context, this.appConfigProvider.get());
        LinearLayout layout2 = (LinearLayout)rootLayout.findViewById(R.id.card_links);
        layout2.setShowDividers(2);
        int dividerColor = ContextCompat.getColor((Context)context, (int)R.color.intercom_container_border);
        layout2.setDividerDrawable((Drawable)new ColorDrawable(dividerColor));
        layout2.setOrientation(1);
        for (Link link : block.getLinks()) {
            this.addLinkToLayout(layout2, link, primaryColor, context, false);
        }
        Link footerLink = block.getFooterLink();
        if (!footerLink.getText().isEmpty()) {
            this.addLinkToLayout(layout2, footerLink, primaryColor, context, true);
        }
        return rootLayout;
    }

    private void addLinkToLayout(LinearLayout layout2, final Link link, int primaryColor, final Context context, boolean isFooter) {
        FrameLayout linkLayout = new FrameLayout(context);
        linkLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
        TextView textView = new TextView(context);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -1);
        if (isFooter) {
            params.gravity = 17;
        }
        textView.setLayoutParams((ViewGroup.LayoutParams)params);
        textView.setTextColor(primaryColor);
        textView.setTextSize(16.0f);
        textView.setText((CharSequence)link.getTitle());
        textView.setMaxLines(2);
        textView.setEllipsize(TextUtils.TruncateAt.END);
        textView.setPadding(ScreenUtils.dpToPx((float)24.0f, (Context)context), ScreenUtils.dpToPx((float)16.0f, (Context)context), ScreenUtils.dpToPx((float)16.0f, (Context)context), ScreenUtils.dpToPx((float)16.0f, (Context)context));
        if ("educate.help_center".equals(link.getLinkType())) {
            Drawable openHelpCenter = ContextCompat.getDrawable((Context)context, (int)R.drawable.intercom_open_help_center);
            openHelpCenter.setColorFilter(primaryColor, PorterDuff.Mode.SRC_IN);
            textView.setCompoundDrawablesWithIntrinsicBounds(openHelpCenter, null, null, null);
            textView.setCompoundDrawablePadding(ScreenUtils.dpToPx((float)8.0f, (Context)context));
        }
        linkLayout.addView((View)textView);
        linkLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (("educate.article".equals(link.getLinkType()) || "educate.suggestion".equals(link.getLinkType())) && context instanceof Activity) {
                    Intent intent = ArticleActivity.buildIntent(context, new ArticleActivity.ArticleActivityArguments(link.getArticleId(), "conversation"));
                    context.startActivity(intent);
                } else if ("educate.help_center".equals(link.getLinkType()) && context instanceof Activity) {
                    IntercomRootActivityLauncher.INSTANCE.startHelpCenterCollections(context, Collections.emptyList(), "conversation");
                } else {
                    LinkOpener.handleUrl(link.getUrl(), context, LinkListRenderer.this.api);
                }
            }
        });
        TypedValue outValue = new TypedValue();
        context.getTheme().resolveAttribute(16843534, outValue, true);
        linkLayout.setBackgroundResource(outValue.resourceId);
        layout2.addView((View)linkLayout);
    }
}

