/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views.holder;

import android.content.res.Resources;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.VisibleForTesting;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.models.Attribute;
import io.intercom.android.sdk.utilities.AttributeValidatorUtils;
import io.intercom.android.sdk.views.TextAttributeView;
import io.intercom.android.sdk.views.holder.ConversationListener;
import kotlin.Deprecated;

@Deprecated(message="Only used in the old conversation screen")
public class SubmitAttributeClickListener
implements View.OnClickListener {
    private final TextAttributeView textAttributeView;
    private final String partId;
    private final ConversationListener conversationListener;

    public SubmitAttributeClickListener(TextAttributeView textAttributeView, String partId, ConversationListener conversationListener) {
        this.textAttributeView = textAttributeView;
        this.partId = partId;
        this.conversationListener = conversationListener;
    }

    public void onClick(View view) {
        String value2 = this.textAttributeView.getInputValue();
        Attribute attribute = this.textAttributeView.getAttribute();
        if (TextUtils.isEmpty((CharSequence)value2)) {
            Resources resources = this.textAttributeView.getContext().getResources();
            this.textAttributeView.displayErrorState(resources.getString(R.string.intercom_string_is_incorrect));
            return;
        }
        int resultCode = AttributeValidatorUtils.validateAttribute(value2, attribute.getRenderType());
        if (resultCode == 0) {
            this.textAttributeView.displayLoadingState();
            this.conversationListener.onSubmitAttribute(this.partId, attribute.getIdentifier(), value2, attribute.getType());
        } else {
            String errorMessage = this.getErrorStringFromCode(resultCode, this.textAttributeView.getContext().getResources());
            this.textAttributeView.displayErrorState(errorMessage);
        }
    }

    @VisibleForTesting
    String getErrorStringFromCode(int errorCode, Resources resources) {
        switch (errorCode) {
            case 1: {
                return resources.getString(R.string.intercom_string_is_incorrect);
            }
            case 2: {
                return resources.getString(R.string.intercom_that_email_address_doesnt_look_quite_right);
            }
            case 3: {
                return resources.getString(R.string.intercom_that_number_doesnt_look_quite_right);
            }
            case 4: {
                return resources.getString(R.string.intercom_that_number_needs_a_prefix);
            }
            case 5: {
                return resources.getString(R.string.intercom_that_number_has_too_many_digits);
            }
            case 6: {
                return resources.getString(R.string.intercom_that_country_code_doesnt_look_quite_right);
            }
            case 7: {
                return resources.getString(R.string.intercom_that_number_is_missing_a_few_digits);
            }
        }
        return "";
    }
}

