/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views.holder;

import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.m5.components.avatar.AvatarIcon;
import io.intercom.android.sdk.m5.components.avatar.AvatarWrapper;
import io.intercom.android.sdk.models.AiMood;
import io.intercom.android.sdk.models.Avatar;
import io.intercom.android.sdk.models.EventData;
import io.intercom.android.sdk.models.EventParticipant;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.utilities.ColorUtils;
import io.intercom.android.sdk.views.holder.ConversationPartViewHolder;

public class EventViewHolder
extends RecyclerView.ViewHolder
implements ConversationPartViewHolder {
    private final TextView eventTitle;
    private final AvatarIcon avatar;

    public EventViewHolder(View itemView) {
        super(itemView);
        this.eventTitle = (TextView)itemView.findViewById(R.id.event_name);
        this.avatar = (AvatarIcon)itemView.findViewById(R.id.avatar);
    }

    @Override
    public void bind(Part part, ViewGroup blocksLayout) {
        EventData eventData = part.getEventData();
        EventParticipant participant = eventData.getParticipant();
        this.eventTitle.setText((CharSequence)eventData.getEventAsPlainText());
        this.avatar.setAvatar(new AvatarWrapper(Avatar.create(participant.getAvatar().getImageUrl(), participant.getInitial()), false, AiMood.DEFAULT, false, false));
        this.avatar.setAvatarBackgroundColor(ColorUtils.parseColor("#FFF1F1F1"));
    }
}

