/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import android.annotation.SuppressLint;
import android.app.Application;
import android.app.NotificationManager;
import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.gson.Gson;
import com.intercom.commons.utilities.TimeProvider;
import com.intercom.twig.Twig;
import com.squareup.otto.Bus;
import com.squareup.otto.ThreadEnforcer;
import io.intercom.android.nexus.NexusClient;
import io.intercom.android.sdk.LifecycleTracker;
import io.intercom.android.sdk.MainThreadBus;
import io.intercom.android.sdk.NexusWrapper;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.ResetManager;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.api.ApiFactory;
import io.intercom.android.sdk.api.DeDuper;
import io.intercom.android.sdk.api.ExternalUploadApi;
import io.intercom.android.sdk.api.MessengerApi;
import io.intercom.android.sdk.api.SurveyApi;
import io.intercom.android.sdk.api.TaggingSocketFactory;
import io.intercom.android.sdk.api.UserUpdater;
import io.intercom.android.sdk.conversation.SoundPlayer;
import io.intercom.android.sdk.errorreporting.ErrorReporter;
import io.intercom.android.sdk.exceptions.IntercomIntegrationException;
import io.intercom.android.sdk.helpcenter.api.HelpCenterApi;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.AppIdentity;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.metrics.ops.OpsMetricTracker;
import io.intercom.android.sdk.overlay.OverlayPresenter;
import io.intercom.android.sdk.push.SystemNotificationManager;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Store;
import io.intercom.android.sdk.store.StoreFactory;
import io.intercom.android.sdk.tickets.create.data.TicketApi;
import io.intercom.android.sdk.utilities.ActivityFinisher;
import io.intercom.android.sdk.utilities.SystemSettings;
import io.intercom.android.sdk.utilities.UuidStringProvider;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import okhttp3.OkHttpClient;

public class Injector {
    private static final int NEXUS_TRAFFIC_TAG = 63987;
    @SuppressLint(value={"StaticFieldLeak"})
    @Nullable
    private static Injector instance;
    private static final Twig TWIG;
    private final Application application;
    private final AppIdentity appIdentity;
    private final AppConfig appConfig;
    private final UserIdentity userIdentity;
    private final ActivityFinisher activityFinisher = new ActivityFinisher();
    @Nullable
    private MainThreadBus bus;
    @Nullable
    private NexusWrapper nexusClient;
    @Nullable
    private DeDuper superDeDuper;
    @Nullable
    private Api api;
    @Nullable
    private MessengerApi messengerApi;
    @Nullable
    private ExternalUploadApi externalUploadApi;
    @Nullable
    private HelpCenterApi helpCenterApi;
    @Nullable
    private SurveyApi surveyApi;
    @Nullable
    private TicketApi ticketApi;
    @Nullable
    private MetricsStore metricsStore;
    @Nullable
    private MetricTracker metricTracker;
    @Nullable
    private OpsMetricTracker opsMetricTracker;
    @Nullable
    private OverlayPresenter overlayPresenter;
    @Nullable
    private LifecycleTracker lifecycleTracker;
    @Nullable
    private SystemNotificationManager systemNotificationManager;
    @Nullable
    private Store<State> store;
    @Nullable
    private UserUpdater userUpdater;
    @Nullable
    private ResetManager resetManager;
    @Nullable
    private Gson gson;
    @Nullable
    private ErrorReporter errorReporter;
    private final Provider<AppConfig> appConfigProvider = new Provider<AppConfig>(){

        @Override
        public AppConfig get() {
            return Injector.this.appConfig;
        }
    };
    private final Provider<NexusClient> nexusClientProvider = new Provider<NexusClient>(){

        @Override
        public NexusClient get() {
            return Injector.this.getNexusClient();
        }
    };
    private final Provider<UserUpdater> userUpdaterProvider = new Provider<UserUpdater>(){

        @Override
        public UserUpdater get() {
            return Injector.this.getUserUpdater();
        }
    };
    private final Provider<Api> apiProvider = new Provider<Api>(){

        @Override
        public Api get() {
            return Injector.this.getApi();
        }
    };
    private final Provider<OverlayPresenter> overlayManagerProvider = new Provider<OverlayPresenter>(){

        @Override
        public OverlayPresenter get() {
            return Injector.this.getOverlayPresenter();
        }
    };
    private final Provider<UserIdentity> userIdentityProvider = new Provider<UserIdentity>(){

        @Override
        public UserIdentity get() {
            return Injector.this.getUserIdentity();
        }
    };
    private final Provider<MetricTracker> metricTrackerProvider = new Provider<MetricTracker>(){

        @Override
        public MetricTracker get() {
            return Injector.this.getMetricTracker();
        }
    };

    public static synchronized void initIfCachedCredentials(Application application) {
        if (instance != null) {
            return;
        }
        AppIdentity appIdentity = AppIdentity.loadFromDevice((Context)application);
        String apiKey = appIdentity.apiKey();
        String appId = appIdentity.appId();
        if (!appId.isEmpty() && !apiKey.isEmpty()) {
            Injector.initWithAppCredentials(application, apiKey, appId);
        }
    }

    public static synchronized void initWithAppCredentials(Application application, String apiKey, String appId) {
        if (instance != null) {
            return;
        }
        TWIG.internal("Injector", "Initializing");
        AppIdentity appIdentity = AppIdentity.create(apiKey, appId);
        appIdentity.persist((Context)application);
        AppConfig appConfig = new AppConfig((Context)application);
        instance = new Injector(application, appIdentity, appConfig, new UserIdentity((Context)application));
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)instance.getLifecycleTracker());
    }

    protected Injector(Application application, AppIdentity appIdentity, AppConfig appConfig, UserIdentity userIdentity2) {
        this.application = application;
        this.appIdentity = appIdentity;
        this.appConfig = appConfig;
        this.userIdentity = userIdentity2;
    }

    public static synchronized boolean isNotInitialised() {
        return instance == null;
    }

    public static synchronized Injector get() {
        if (instance == null) {
            String message = "Intercom was not initialized correctly, Intercom.initialize() needs to be called in onCreate() in your Application class.";
            throw new IntercomIntegrationException(message);
        }
        return instance;
    }

    public Application getApplication() {
        return this.application;
    }

    public Provider<AppConfig> getAppConfigProvider() {
        return this.appConfigProvider;
    }

    public AppIdentity getAppIdentity() {
        return this.appIdentity;
    }

    public UserIdentity getUserIdentity() {
        return this.userIdentity;
    }

    public synchronized Bus getBus() {
        if (this.bus == null) {
            this.bus = new MainThreadBus(ThreadEnforcer.ANY);
        }
        return this.bus;
    }

    public synchronized NexusClient getNexusClient() {
        if (this.nexusClient == null) {
            OkHttpClient okHttpClient = NexusClient.defaultOkHttpClientBuilder().socketFactory((SocketFactory)new TaggingSocketFactory(SocketFactory.getDefault(), 63987)).build();
            this.nexusClient = new NexusWrapper(LumberMill.getNexusTwig(), okHttpClient, this.getBus(), this.getStore(), this.getApi(), this.getNexusDebouncePeriod());
        }
        return this.nexusClient;
    }

    protected long getNexusDebouncePeriod() {
        return TimeUnit.SECONDS.toMillis(1L);
    }

    public synchronized DeDuper getDeDuper() {
        if (this.superDeDuper == null) {
            SharedPreferences prefs = this.application.getSharedPreferences("INTERCOM_DEDUPER_PREFS", 0);
            this.superDeDuper = new DeDuper(this.appConfigProvider, prefs);
            this.superDeDuper.readPersistedCachedAttributes();
        }
        return this.superDeDuper;
    }

    public synchronized Api getApi() {
        if (this.api == null) {
            String serverUrl = ApiFactory.getServerUrl(this.appIdentity, (Context)this.application);
            this.api = ApiFactory.create((Context)this.getApplication(), this.appIdentity, this.userIdentity, this.getBus(), this.getStore(), serverUrl, this.appConfigProvider, this.getGson(), this.getOpsMetricTracker());
            this.messengerApi = ApiFactory.messengerApi;
        }
        this.api.updateMaxRequests();
        return this.api;
    }

    public synchronized HelpCenterApi getHelpCenterApi() {
        if (this.helpCenterApi == null) {
            String hostname = ApiFactory.getServerUrl(this.appIdentity, (Context)this.application);
            this.helpCenterApi = ApiFactory.createHelpCenterApi((Context)this.getApplication(), this.appIdentity, this.userIdentity, hostname, this.getGson());
        }
        return this.helpCenterApi;
    }

    public synchronized SurveyApi getSurveyApi() {
        if (this.surveyApi == null) {
            String hostname = ApiFactory.getServerUrl(this.appIdentity, (Context)this.application);
            this.surveyApi = ApiFactory.createSurveyApi((Context)this.getApplication(), this.appIdentity, this.userIdentity, hostname, this.getGson());
        }
        return this.surveyApi;
    }

    public synchronized TicketApi getTicketApi() {
        if (this.ticketApi == null) {
            String hostname = ApiFactory.getServerUrl(this.appIdentity, (Context)this.application);
            this.ticketApi = ApiFactory.createTicketApi((Context)this.getApplication(), this.appIdentity, this.userIdentity, hostname, this.getGson());
        }
        return this.ticketApi;
    }

    public synchronized Gson getGson() {
        if (this.gson == null) {
            this.gson = new Gson();
        }
        return this.gson;
    }

    public synchronized MetricTracker getMetricTracker() {
        if (this.metricTracker == null) {
            this.metricTracker = new MetricTracker(this.userIdentity, this.getMetricsStore(), (Context)this.getApplication());
        }
        return this.metricTracker;
    }

    public synchronized MetricsStore getMetricsStore() {
        if (this.metricsStore == null) {
            this.metricsStore = new MetricsStore((Context)this.getApplication(), this.getApiProvider(), this.appConfigProvider);
        }
        return this.metricsStore;
    }

    public synchronized OpsMetricTracker getOpsMetricTracker() {
        if (this.opsMetricTracker == null) {
            this.opsMetricTracker = new OpsMetricTracker(this.getMetricsStore(), this.getTimeProvider(), UuidStringProvider.SYSTEM);
        }
        return this.opsMetricTracker;
    }

    public synchronized OverlayPresenter getOverlayPresenter() {
        if (this.overlayPresenter == null) {
            this.overlayPresenter = new OverlayPresenter(this.getApplication(), this.getBus(), this.getStore(), this.appConfigProvider, this.getMetricTracker(), this.userIdentity);
        }
        return this.overlayPresenter;
    }

    public synchronized Store<State> getStore() {
        if (this.store == null) {
            this.store = StoreFactory.createStore(this.apiProvider, this.appConfigProvider, this.nexusClientProvider, this.overlayManagerProvider, this.userUpdaterProvider, new SoundPlayer((Context)this.application, this.appConfigProvider), this.userIdentityProvider, (Context)this.application, LumberMill.getLogger(), this.getBus(), this.metricTrackerProvider);
        }
        return this.store;
    }

    public TimeProvider getTimeProvider() {
        return TimeProvider.SYSTEM;
    }

    public synchronized SystemNotificationManager getSystemNotificationManager() {
        if (this.systemNotificationManager == null) {
            NotificationManager notificationManager = (NotificationManager)this.application.getSystemService("notification");
            this.systemNotificationManager = new SystemNotificationManager(notificationManager);
        }
        return this.systemNotificationManager;
    }

    public synchronized LifecycleTracker getLifecycleTracker() {
        if (this.lifecycleTracker == null) {
            this.lifecycleTracker = LifecycleTracker.create(this.getSystemNotificationManager(), this.getMetricsStore(), this.getErrorReporter(), this.getDeDuper(), this.getTimeProvider(), this.getUserUpdater(), this.getStore(), this.getResetManager(), SystemSettings.getTransitionScale((Context)this.application));
        }
        return this.lifecycleTracker;
    }

    public synchronized ErrorReporter getErrorReporter() {
        if (this.errorReporter == null) {
            this.errorReporter = ErrorReporter.create((Context)this.application, this.getGson(), this.apiProvider);
        }
        return this.errorReporter;
    }

    public synchronized UserUpdater getUserUpdater() {
        if (this.userUpdater == null) {
            this.userUpdater = new UserUpdater(this.getApiProvider(), this.getStore(), this.getOpsMetricTracker());
        }
        return this.userUpdater;
    }

    public synchronized ResetManager getResetManager() {
        if (this.resetManager == null) {
            this.resetManager = new ResetManager(this.getApiProvider(), this.getUserIdentity(), this.getOverlayPresenter(), this.appConfigProvider, this.getStore(), this.getUserUpdater(), (Context)this.application, this.activityFinisher);
        }
        return this.resetManager;
    }

    public Provider<UserUpdater> getUserUpdaterProvider() {
        return this.userUpdaterProvider;
    }

    public Provider<Api> getApiProvider() {
        return this.apiProvider;
    }

    public ActivityFinisher getActivityFinisher() {
        return this.activityFinisher;
    }

    @VisibleForTesting
    static void setSharedInstance(Injector injector2) {
        instance = injector2;
    }

    public MessengerApi getMessengerApi() {
        if (this.messengerApi == null) {
            this.messengerApi = ApiFactory.messengerApi;
        }
        return this.messengerApi;
    }

    public ExternalUploadApi getExternalUploadApi() {
        if (this.externalUploadApi == null) {
            this.externalUploadApi = ApiFactory.uploadApi;
        }
        return this.externalUploadApi;
    }

    static {
        TWIG = LumberMill.getLogger();
    }
}

