/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.operator;

import android.os.Handler;
import io.intercom.android.sdk.views.ClientConditionListener;

public class OperatorClientConditionTimer {
    private static final int SHORT_DELAY_MILLIS = 2000;
    private static final int LONG_DELAY_MILLIS = 10000;
    private final Handler handler;
    private final Runnable runnable;
    private final String conversationId;
    private final String condition;

    public OperatorClientConditionTimer(final String conversationId, final String condition, Handler handler, final ClientConditionListener listener2) {
        this.conversationId = conversationId;
        this.condition = condition;
        this.handler = handler;
        this.runnable = new Runnable(){

            @Override
            public void run() {
                listener2.conditionSatisfied(conversationId, condition);
            }
        };
    }

    public void beginCountdown() {
        this.handler.postDelayed(this.runnable, 2000L);
    }

    public void interrupt() {
        this.handler.removeCallbacks(this.runnable);
        this.handler.postDelayed(this.runnable, 10000L);
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public String getCondition() {
        return this.condition;
    }
}

