/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.carousel;

import android.os.Build;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import io.intercom.android.sdk.actions.Actions;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.carousel.CarouselView;
import io.intercom.android.sdk.carousel.PermissionManager;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.models.carousel.Carousel;
import io.intercom.android.sdk.models.carousel.CarouselScreen;
import io.intercom.android.sdk.models.carousel.ScreenAction;
import io.intercom.android.sdk.state.ProgrammaticCarouselState;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Selectors;
import io.intercom.android.sdk.store.Store;
import io.intercom.android.sdk.utilities.StoreUtils;
import java.util.Iterator;
import java.util.List;

public final class CarouselPresenter {
    private final Store<State> store;
    private final Api api;
    private UserIdentity userIdentity;
    private final MetricTracker metricTracker;
    private final PermissionManager permissionManager;
    private Carousel carousel = Carousel.NULL;
    private int initialNumberOfScreens;
    private CarouselView view = null;
    private Store.Subscription programmaticCarouselSubscription = null;
    private String carouselSource = "programmatic";
    @Nullable
    private String carouselId = null;

    public CarouselPresenter(Store<State> store2, Api api, UserIdentity userIdentity, MetricTracker metricTracker, PermissionManager permissionManager) {
        this.store = store2;
        this.api = api;
        this.userIdentity = userIdentity;
        this.metricTracker = metricTracker;
        this.permissionManager = permissionManager;
        this.filterCarouselScreens(this.carousel);
    }

    public void attachView(CarouselView view) {
        this.view = view;
    }

    public void detachView() {
        StoreUtils.safeUnsubscribe(this.programmaticCarouselSubscription);
        this.view = null;
    }

    public String getCarouselSource() {
        return this.carouselSource;
    }

    public void fetchCarousel(@Nullable String carouselId) {
        this.carouselId = carouselId;
        this.setSource(carouselId);
        if ("programmatic".equals(this.carouselSource)) {
            if (TextUtils.isEmpty((CharSequence)carouselId)) {
                this.view.logEmptyCarouselError();
                this.view.showNotFoundError();
            } else if (this.noUserRegistered()) {
                this.view.logUserNotRegisteredError();
                this.view.showNotFoundError();
            } else {
                this.fetchProgrammaticCarousel(carouselId);
            }
        } else {
            this.fetchAutomaticCarousel();
        }
    }

    private boolean noUserRegistered() {
        return !this.userIdentity.identityExists() || this.userIdentity.isSoftReset();
    }

    public void retryFetch(@Nullable String carouselId) {
        if (TextUtils.isEmpty((CharSequence)carouselId)) {
            if (this.view != null) {
                this.view.showNotFoundError();
            }
            return;
        }
        this.metricTracker.retriedCarouselFetching(carouselId, this.carouselSource);
        this.fetchProgrammaticCarousel(carouselId);
    }

    public Carousel getCarousel() {
        return this.carousel;
    }

    public void resetPersistedCarousel() {
        this.store.dispatch(Actions.carouselDismissed());
    }

    public void recordDismissedOrCompletedStats(boolean isLastScreenViewed) {
        String instanceId = this.getCarousel().getInstanceId();
        if (TextUtils.isEmpty((CharSequence)instanceId)) {
            return;
        }
        if (isLastScreenViewed) {
            this.api.markCarouselAsCompleted(instanceId, this.isTriggeredFromCode());
        } else {
            this.api.markCarouselAsDismissed(instanceId, this.isTriggeredFromCode());
        }
    }

    public void recordScreenSeenStats(String screenId) {
        String instanceId = this.getCarousel().getInstanceId();
        this.api.markCarouselScreenViewed(instanceId, screenId, this.isTriggeredFromCode());
    }

    public void recordActionButtonTappedStats(@NonNull String screenId) {
        String instanceId = this.getCarousel().getInstanceId();
        this.api.markCarouselActionButtonTapped(instanceId, screenId, this.isTriggeredFromCode());
    }

    public void recordOpenMetric() {
        int numberOfScreensShown = this.getCarousel().getScreens().size();
        this.metricTracker.openedCarousel(this.getCarousel().getInstanceId(), this.carouselSource, this.initialNumberOfScreens, numberOfScreensShown);
    }

    public void recordDismissedOrCompletedMetric(String context, boolean isLastScreenViewed, int screensSeen) {
        String instanceId = this.getCarousel().getInstanceId();
        if (TextUtils.isEmpty((CharSequence)instanceId)) {
            if (!TextUtils.isEmpty((CharSequence)this.carouselId)) {
                this.metricTracker.dismissedCarouselFetching(context, this.carouselId, this.carouselSource);
            }
            return;
        }
        int numberOfScreensShown = this.getCarousel().getScreens().size();
        if (isLastScreenViewed) {
            this.metricTracker.completedCarousel(context, instanceId, this.carouselSource, this.initialNumberOfScreens, numberOfScreensShown);
        } else {
            this.metricTracker.dismissedCarousel(context, instanceId, this.carouselSource, this.initialNumberOfScreens, numberOfScreensShown, screensSeen);
        }
    }

    public void recordPermissionRequestedMetric(String permissionType, int[] grantResults, String screenId) {
        boolean isGranted = false;
        String instanceId = this.getCarousel().getInstanceId();
        for (int result : grantResults) {
            if (result != 0) continue;
            isGranted = true;
            this.api.markPermissionGranted(instanceId, screenId, this.isTriggeredFromCode());
            break;
        }
        this.metricTracker.requestedPermission(permissionType, instanceId, this.carouselSource, isGranted);
    }

    public void recordSentToPermissionSettingsMetric(ScreenAction permissionAction, String screenId) {
        String permissionType = permissionAction.getType();
        List<String> permissions = permissionAction.getValidPermissions(this.permissionManager);
        boolean isGranted = this.permissionManager.permissionsGranted(permissions);
        String instanceId = this.getCarousel().getInstanceId();
        if (isGranted) {
            this.api.markPermissionGranted(instanceId, screenId, this.isTriggeredFromCode());
        }
        this.metricTracker.sentToPermissionSettings(permissionType, instanceId, this.carouselSource, isGranted);
    }

    @VisibleForTesting
    void filterCarouselScreens(Carousel carousel) {
        Iterator<CarouselScreen> iterator = carousel.getScreens().iterator();
        while (iterator.hasNext()) {
            CarouselScreen screen = iterator.next();
            if (!this.screenShouldBeRemoved(screen)) continue;
            iterator.remove();
        }
    }

    @VisibleForTesting
    boolean screenShouldBeRemoved(CarouselScreen screen) {
        ScreenAction permissionAction = screen.getPermissionAction();
        if (ScreenAction.NULL.equals(permissionAction)) {
            return false;
        }
        List<String> permissionStrings = permissionAction.getValidPermissions(this.permissionManager);
        return Build.VERSION.SDK_INT < 23 || permissionStrings.isEmpty() || this.permissionManager.permissionsGranted(permissionStrings);
    }

    private void fetchAutomaticCarousel() {
        this.carousel = this.store.select(Selectors.OVERLAY).carousel();
        this.initialNumberOfScreens = this.carousel.getScreens().size();
        this.filterCarouselScreens(this.carousel);
        if (this.view != null) {
            this.view.showSuccess(this.carousel);
        }
    }

    private void fetchProgrammaticCarousel(@NonNull String carouselId) {
        StoreUtils.safeUnsubscribe(this.programmaticCarouselSubscription);
        this.store.dispatch(Actions.openProgrammaticCarousel(carouselId));
        this.programmaticCarouselSubscription = this.store.subscribeToChanges(Selectors.PROGRAMMATIC_CAROUSEL_STATE, state -> {
            if (state instanceof ProgrammaticCarouselState.Loading) {
                this.metricTracker.startedCarouselFetching(carouselId, this.carouselSource);
                if (this.view != null) {
                    this.view.showLoading();
                }
            } else if (state instanceof ProgrammaticCarouselState.Success) {
                StoreUtils.safeUnsubscribe(this.programmaticCarouselSubscription);
                this.carousel = ((ProgrammaticCarouselState.Success)state).carousel();
                if (this.view != null) {
                    this.view.showSuccess(this.carousel);
                }
            } else if (state instanceof ProgrammaticCarouselState.Error) {
                StoreUtils.safeUnsubscribe(this.programmaticCarouselSubscription);
                ProgrammaticCarouselState.Error programmaticCarouselState = (ProgrammaticCarouselState.Error)state;
                this.metricTracker.failedCarousel(carouselId, this.carouselSource, programmaticCarouselState.errorCode());
                if (this.view != null) {
                    if (programmaticCarouselState.errorCode() == 404) {
                        this.view.showNotFoundError();
                    } else {
                        this.view.showGenericError();
                    }
                }
            }
        });
    }

    private boolean isTriggeredFromCode() {
        return this.carouselSource.equals("programmatic");
    }

    private void setSource(@Nullable String carouselId) {
        this.carouselSource = carouselId == null ? "automatic" : "programmatic";
    }
}

