/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.content.Context;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.utilities.Phrase;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0014\u0010\n\u001a\u00020\u0007*\u00020\u00012\u0006\u0010\b\u001a\u00020\tH\u0000\u00a8\u0006\u000b"}, d2={"getDifferenceInDays", "", "date", "Ljava/util/Date;", "getDifferenceInHours", "getDifferenceInMinutes", "getFormattedTime", "", "context", "Landroid/content/Context;", "formattedDateFromLong", "intercom-sdk-base_release"})
public final class TimeFormatterExtKt {
    @NotNull
    public static final String formattedDateFromLong(long $this$formattedDateFromLong, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if ($this$formattedDateFromLong <= 0L) {
            return "";
        }
        Date date = new Date($this$formattedDateFromLong * (long)1000);
        return TimeFormatterExtKt.getFormattedTime(context, date);
    }

    private static final String getFormattedTime(Context context, Date date) {
        long diffInMin = TimeFormatterExtKt.getDifferenceInMinutes(date);
        long diffInHours = TimeFormatterExtKt.getDifferenceInHours(date);
        long diffInDays = TimeFormatterExtKt.getDifferenceInDays(date);
        long diffInWeeks = diffInDays / (long)7;
        String displayDate = diffInWeeks > 0L ? ((Object)Phrase.from(context, R.string.intercom_time_week_ago).put("delta", String.valueOf(diffInWeeks)).format()).toString() : (diffInDays > 0L ? ((Object)Phrase.from(context, R.string.intercom_time_day_ago).put("delta", String.valueOf(diffInDays)).format()).toString() : (diffInHours > 0L ? ((Object)Phrase.from(context, R.string.intercom_time_hour_ago).put("delta", String.valueOf(diffInHours)).format()).toString() : (diffInMin >= 1L ? ((Object)Phrase.from(context, R.string.intercom_time_minute_ago).put("delta", String.valueOf(diffInMin)).format()).toString() : ((Object)context.getText(R.string.intercom_time_just_now)).toString())));
        return displayDate;
    }

    private static final long getDifferenceInMinutes(Date date) {
        return TimeUnit.MILLISECONDS.toMinutes(System.currentTimeMillis() - date.getTime());
    }

    private static final long getDifferenceInHours(Date date) {
        return TimeUnit.MILLISECONDS.toHours(System.currentTimeMillis() - date.getTime());
    }

    private static final long getDifferenceInDays(Date date) {
        return TimeUnit.MILLISECONDS.toDays(System.currentTimeMillis() - date.getTime());
    }
}

