/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;

public class CountryAreaCode {
    private String code;
    private String dialCode;
    private String emoji;
    private int priority;
    private List<String> areaCodes;
    public static final CountryAreaCode UNKNOWN = new Builder().build();

    CountryAreaCode(Builder builder) {
        this.code = builder.code == null ? "" : builder.code;
        this.dialCode = builder.dialCode == null ? "" : builder.dialCode;
        this.emoji = builder.emoji == null ? "\ud83c\udf0e" : builder.emoji;
        this.priority = builder.priority == null ? 0 : builder.priority;
        this.areaCodes = new ArrayList<String>();
        if (builder.areaCodes != null) {
            for (String areaCode : builder.areaCodes) {
                if (areaCode == null) continue;
                this.areaCodes.add(areaCode);
            }
        }
    }

    public String getCode() {
        return this.code;
    }

    public String getDialCode() {
        return this.dialCode;
    }

    public String getEmoji() {
        return this.emoji;
    }

    public int getPriority() {
        return this.priority;
    }

    public List<String> getAreaCodes() {
        return this.areaCodes;
    }

    public static final class Builder {
        @Nullable
        String code;
        @Nullable
        String dialCode;
        @Nullable
        String emoji;
        @Nullable
        List<String> areaCodes;
        @Nullable
        Integer priority;

        public CountryAreaCode build() {
            return new CountryAreaCode(this);
        }
    }
}

