/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.helpcenter.articles;

import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelKt;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.articles.ArticleWebViewListener;
import io.intercom.android.sdk.helpcenter.api.HelpCenterApi;
import io.intercom.android.sdk.helpcenter.articles.ArticleViewModel;
import io.intercom.android.sdk.helpcenter.articles.ArticleViewState;
import io.intercom.android.sdk.helpcenter.component.TeammateHelpKt;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.TeamPresence;
import io.intercom.android.sdk.state.InboxState;
import io.intercom.android.sdk.store.Selectors;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0006\b\u0000\u0018\u0000 02\u00020\u00012\u00020\u0002:\u00010BQ\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0006J\b\u0010!\u001a\u00020\u001fH\u0016J\u000e\u0010\"\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u0006J\u0006\u0010#\u001a\u00020\u001fJ\u0006\u0010$\u001a\u00020\u001fJ\b\u0010%\u001a\u00020\u001fH\u0016J\b\u0010&\u001a\u00020\u001fH\u0016J\b\u0010'\u001a\u00020\u001fH\u0016J\u0006\u0010(\u001a\u00020\u001fJ\u0019\u0010)\u001a\u00020\u001f2\n\b\u0002\u0010*\u001a\u0004\u0018\u00010+H\u0002\u00a2\u0006\u0002\u0010,J \u0010-\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010.\u001a\u00020+H\u0002J\b\u0010/\u001a\u00020\u0011H\u0002R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lio/intercom/android/sdk/helpcenter/articles/ArticleViewModel;", "Landroidx/lifecycle/ViewModel;", "Lio/intercom/android/sdk/articles/ArticleWebViewListener;", "helpCenterApi", "Lio/intercom/android/sdk/helpcenter/api/HelpCenterApi;", "baseUrl", "", "appConfig", "Lio/intercom/android/sdk/identity/AppConfig;", "inboxState", "Lio/intercom/android/sdk/state/InboxState;", "teamPresence", "Lio/intercom/android/sdk/models/TeamPresence;", "metricTracker", "Lio/intercom/android/sdk/metrics/MetricTracker;", "metricPlace", "isFromSearchBrowse", "", "dispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "(Lio/intercom/android/sdk/helpcenter/api/HelpCenterApi;Ljava/lang/String;Lio/intercom/android/sdk/identity/AppConfig;Lio/intercom/android/sdk/state/InboxState;Lio/intercom/android/sdk/models/TeamPresence;Lio/intercom/android/sdk/metrics/MetricTracker;Ljava/lang/String;ZLkotlinx/coroutines/CoroutineDispatcher;)V", "_state", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lio/intercom/android/sdk/helpcenter/articles/ArticleViewState;", "articleContentId", "articleId", "state", "Lkotlinx/coroutines/flow/StateFlow;", "getState", "()Lkotlinx/coroutines/flow/StateFlow;", "articleContentIdFetched", "", "value", "articleNotFound", "fragmentLoaded", "happyReactionTapped", "neutralReactionTapped", "onArticleFinishedLoading", "onArticleLoadingError", "onArticleStartedLoading", "sadReactionTapped", "sendFailedMetric", "errorCode", "", "(Ljava/lang/Integer;)V", "sendReactionToServer", "reactionIndex", "shouldAddSendMessageRow", "Companion", "intercom-sdk-base_release"})
public final class ArticleViewModel
extends ViewModel
implements ArticleWebViewListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HelpCenterApi helpCenterApi;
    @NotNull
    private final String baseUrl;
    @NotNull
    private final AppConfig appConfig;
    @NotNull
    private final InboxState inboxState;
    @NotNull
    private final TeamPresence teamPresence;
    @NotNull
    private final MetricTracker metricTracker;
    private final boolean isFromSearchBrowse;
    @NotNull
    private final CoroutineDispatcher dispatcher;
    @NotNull
    private final MutableStateFlow<ArticleViewState> _state;
    @NotNull
    private final StateFlow<ArticleViewState> state;
    @NotNull
    private String articleContentId;
    @NotNull
    private String articleId;
    public static final int HAPPY_SERVER_INDEX = 0;
    public static final int NEUTRAL_SERVER_INDEX = 1;
    public static final int SAD_SERVER_INDEX = 2;

    public ArticleViewModel(@NotNull HelpCenterApi helpCenterApi, @NotNull String baseUrl, @NotNull AppConfig appConfig, @NotNull InboxState inboxState, @NotNull TeamPresence teamPresence, @NotNull MetricTracker metricTracker, @NotNull String metricPlace, boolean isFromSearchBrowse, @NotNull CoroutineDispatcher dispatcher) {
        Intrinsics.checkNotNullParameter((Object)helpCenterApi, (String)"helpCenterApi");
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)appConfig, (String)"appConfig");
        Intrinsics.checkNotNullParameter((Object)inboxState, (String)"inboxState");
        Intrinsics.checkNotNullParameter((Object)teamPresence, (String)"teamPresence");
        Intrinsics.checkNotNullParameter((Object)metricTracker, (String)"metricTracker");
        Intrinsics.checkNotNullParameter((Object)metricPlace, (String)"metricPlace");
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        this.helpCenterApi = helpCenterApi;
        this.baseUrl = baseUrl;
        this.appConfig = appConfig;
        this.inboxState = inboxState;
        this.teamPresence = teamPresence;
        this.metricTracker = metricTracker;
        this.isFromSearchBrowse = isFromSearchBrowse;
        this.dispatcher = dispatcher;
        this._state = StateFlowKt.MutableStateFlow((Object)ArticleViewState.Initial.INSTANCE);
        this.state = FlowKt.asStateFlow(this._state);
        this.articleContentId = "";
        this.articleId = "";
        if (!Intrinsics.areEqual((Object)metricPlace, (Object)"collection_list") && !Intrinsics.areEqual((Object)metricPlace, (Object)"article")) {
            String metricContext = "no_context";
            if (Intrinsics.areEqual((Object)metricPlace, (Object)"api")) {
                metricContext = "article";
            }
            this.metricTracker.openedNativeHelpCenter(metricPlace, metricContext);
        }
    }

    public /* synthetic */ ArticleViewModel(HelpCenterApi helpCenterApi, String string, AppConfig appConfig, InboxState inboxState, TeamPresence teamPresence, MetricTracker metricTracker, String string2, boolean bl, CoroutineDispatcher coroutineDispatcher, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x80) != 0) {
            bl = false;
        }
        if ((n & 0x100) != 0) {
            coroutineDispatcher = Dispatchers.getIO();
        }
        this(helpCenterApi, string, appConfig, inboxState, teamPresence, metricTracker, string2, bl, coroutineDispatcher);
    }

    @NotNull
    public final StateFlow<ArticleViewState> getState() {
        return this.state;
    }

    public final void fragmentLoaded(@NotNull String articleId) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        this.articleId = articleId;
        String url = this.baseUrl + "/articles/" + articleId;
        this._state.setValue((Object)new ArticleViewState.Content(url, articleId, ArticleViewState.WebViewStatus.Idle, ArticleViewState.ReactionState.Companion.getDefaultReactionState(), ArticleViewState.TeamPresenceState.Companion.getDefaultTeamPresenceState()));
    }

    @Override
    public void onArticleFinishedLoading() {
        this.metricTracker.viewedNativeHelpCenter("article", null, this.isFromSearchBrowse);
        ArticleViewState currentState = (ArticleViewState)this._state.getValue();
        if (currentState instanceof ArticleViewState.Content) {
            this._state.setValue((Object)ArticleViewState.Content.copy$default((ArticleViewState.Content)currentState, null, null, ArticleViewState.WebViewStatus.Ready, null, null, 27, null));
        } else if (Intrinsics.areEqual((Object)currentState, (Object)ArticleViewState.Initial.INSTANCE) ? true : currentState instanceof ArticleViewState.Error) {
            // empty if block
        }
    }

    @Override
    public void onArticleLoadingError() {
        ArticleViewModel.sendFailedMetric$default(this, null, 1, null);
        this._state.setValue((Object)new ArticleViewState.Error(R.string.intercom_something_went_wrong_try_again, 0, this.appConfig.getPrimaryColor()));
    }

    @Override
    public void articleNotFound() {
        this.sendFailedMetric(404);
        this._state.setValue((Object)new ArticleViewState.Error(R.string.intercom_page_not_found, 8, this.appConfig.getPrimaryColor()));
    }

    @Override
    public void onArticleStartedLoading() {
        ArticleViewState currentState = (ArticleViewState)this._state.getValue();
        if (currentState instanceof ArticleViewState.Content) {
            this._state.setValue((Object)ArticleViewState.Content.copy$default((ArticleViewState.Content)currentState, null, null, ArticleViewState.WebViewStatus.Loading, null, null, 27, null));
        } else if (!(Intrinsics.areEqual((Object)currentState, (Object)ArticleViewState.Initial.INSTANCE) ? true : currentState instanceof ArticleViewState.Error)) {
            throw new NoWhenBranchMatchedException();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void sadReactionTapped() {
        ArticleViewState currentState = (ArticleViewState)this._state.getValue();
        if (currentState instanceof ArticleViewState.Content) {
            void $this$sadReactionTapped_u24lambda_u2d0;
            ArticleViewState.Content content = (ArticleViewState.Content)currentState;
            MutableStateFlow<ArticleViewState> mutableStateFlow = this._state;
            boolean bl = false;
            this.metricTracker.sentArticleReaction("reaction_sad", this.appConfig.isInboundMessages(), this.isFromSearchBrowse);
            this.sendReactionToServer($this$sadReactionTapped_u24lambda_u2d0.getArticleId(), this.articleContentId, 2);
            int transitionState = R.id.sad_end;
            int teamHelpVisibility = 8;
            boolean shouldScrollToBottom = false;
            if (this.shouldAddSendMessageRow()) {
                teamHelpVisibility = 0;
                shouldScrollToBottom = true;
            }
            mutableStateFlow.setValue((Object)ArticleViewState.Content.copy$default((ArticleViewState.Content)$this$sadReactionTapped_u24lambda_u2d0, null, null, null, ArticleViewState.ReactionState.copy$default($this$sadReactionTapped_u24lambda_u2d0.getReactionState(), 0, transitionState, teamHelpVisibility, shouldScrollToBottom, 1, null), TeammateHelpKt.computeViewState($this$sadReactionTapped_u24lambda_u2d0.getArticleId(), $this$sadReactionTapped_u24lambda_u2d0.getTeamPresenceState(), this.appConfig, this.teamPresence, "article", this.isFromSearchBrowse), 7, null));
        } else if (!(Intrinsics.areEqual((Object)currentState, (Object)ArticleViewState.Initial.INSTANCE) ? true : currentState instanceof ArticleViewState.Error)) {
            throw new NoWhenBranchMatchedException();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void happyReactionTapped() {
        ArticleViewState currentState = (ArticleViewState)this._state.getValue();
        if (currentState instanceof ArticleViewState.Content) {
            void $this$happyReactionTapped_u24lambda_u2d1;
            ArticleViewState.Content content = (ArticleViewState.Content)currentState;
            MutableStateFlow<ArticleViewState> mutableStateFlow = this._state;
            boolean bl = false;
            this.metricTracker.sentArticleReaction("reaction_happy", null, this.isFromSearchBrowse);
            this.sendReactionToServer($this$happyReactionTapped_u24lambda_u2d1.getArticleId(), this.articleContentId, 0);
            mutableStateFlow.setValue((Object)ArticleViewState.Content.copy$default((ArticleViewState.Content)$this$happyReactionTapped_u24lambda_u2d1, null, null, null, ArticleViewState.ReactionState.copy$default($this$happyReactionTapped_u24lambda_u2d1.getReactionState(), 0, R.id.happy_end, 8, false, 1, null), null, 23, null));
        } else if (!(Intrinsics.areEqual((Object)currentState, (Object)ArticleViewState.Initial.INSTANCE) ? true : currentState instanceof ArticleViewState.Error)) {
            throw new NoWhenBranchMatchedException();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void neutralReactionTapped() {
        ArticleViewState currentState = (ArticleViewState)this._state.getValue();
        if (currentState instanceof ArticleViewState.Content) {
            void $this$neutralReactionTapped_u24lambda_u2d2;
            ArticleViewState.Content content = (ArticleViewState.Content)currentState;
            MutableStateFlow<ArticleViewState> mutableStateFlow = this._state;
            boolean bl = false;
            this.metricTracker.sentArticleReaction("reaction_neutral", null, this.isFromSearchBrowse);
            this.sendReactionToServer($this$neutralReactionTapped_u24lambda_u2d2.getArticleId(), this.articleContentId, 1);
            mutableStateFlow.setValue((Object)ArticleViewState.Content.copy$default((ArticleViewState.Content)$this$neutralReactionTapped_u24lambda_u2d2, null, null, null, ArticleViewState.ReactionState.copy$default($this$neutralReactionTapped_u24lambda_u2d2.getReactionState(), 0, R.id.neutral_end, 8, false, 1, null), null, 23, null));
        } else if (!(Intrinsics.areEqual((Object)currentState, (Object)ArticleViewState.Initial.INSTANCE) ? true : currentState instanceof ArticleViewState.Error)) {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void sendReactionToServer(String articleId, String articleContentId, int reactionIndex) {
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), (CoroutineContext)((CoroutineContext)this.dispatcher), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, articleId, reactionIndex, articleContentId, null){
            int label;
            final /* synthetic */ ArticleViewModel this$0;
            final /* synthetic */ String $articleId;
            final /* synthetic */ int $reactionIndex;
            final /* synthetic */ String $articleContentId;
            {
                this.this$0 = $receiver;
                this.$articleId = $articleId;
                this.$reactionIndex = $reactionIndex;
                this.$articleContentId = $articleContentId;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = HelpCenterApi.DefaultImpls.reactToArticle$default(ArticleViewModel.access$getHelpCenterApi$p(this.this$0), this.$articleId, this.$reactionIndex, this.$articleContentId, false, ArticleViewModel.access$isFromSearchBrowse$p(this.this$0) ? "search_browse" : null, null, (Continuation)this, 40, null);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public final void articleContentIdFetched(@Nullable String value) {
        if (value != null) {
            this.articleContentId = value;
            ArticleViewState currentState = (ArticleViewState)this._state.getValue();
            if (currentState instanceof ArticleViewState.Content) {
                this._state.setValue((Object)ArticleViewState.Content.copy$default((ArticleViewState.Content)currentState, null, null, null, ArticleViewState.ReactionState.copy$default(((ArticleViewState.Content)currentState).getReactionState(), 0, 0, 0, false, 14, null), null, 23, null));
            } else if (Intrinsics.areEqual((Object)currentState, (Object)ArticleViewState.Initial.INSTANCE) ? true : currentState instanceof ArticleViewState.Error) {
                // empty if block
            }
        }
    }

    private final void sendFailedMetric(Integer errorCode) {
        Integer n = errorCode;
        this.metricTracker.failedHelpCenter("help_center", "article", n != null ? n.toString() : null, this.isFromSearchBrowse);
    }

    static /* synthetic */ void sendFailedMetric$default(ArticleViewModel articleViewModel, Integer n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = null;
        }
        articleViewModel.sendFailedMetric(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldAddSendMessageRow() {
        Conversation it;
        boolean eligibilityForConv = this.appConfig.isInboundMessages();
        if (!this.appConfig.isPreventMultipleInboundConversationsEnabled()) return eligibilityForConv;
        if (!eligibilityForConv) return false;
        List<Conversation> list = this.inboxState.conversations();
        Intrinsics.checkNotNullExpressionValue(list, (String)"inboxState.conversations()");
        Iterable $this$all$iv = list;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            it = (Conversation)element$iv;
            boolean bl = false;
        } while (Intrinsics.areEqual((Object)it.getState(), (Object)"state_closed"));
        return false;
    }

    public static final /* synthetic */ HelpCenterApi access$getHelpCenterApi$p(ArticleViewModel $this) {
        return $this.helpCenterApi;
    }

    public static final /* synthetic */ boolean access$isFromSearchBrowse$p(ArticleViewModel $this) {
        return $this.isFromSearchBrowse;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000;\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\b\u0003*\u0001\u0013\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J-\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/intercom/android/sdk/helpcenter/articles/ArticleViewModel$Companion;", "", "()V", "HAPPY_SERVER_INDEX", "", "NEUTRAL_SERVER_INDEX", "SAD_SERVER_INDEX", "create", "Lio/intercom/android/sdk/helpcenter/articles/ArticleViewModel;", "owner", "Landroidx/lifecycle/ViewModelStoreOwner;", "helpCenterApi", "Lio/intercom/android/sdk/helpcenter/api/HelpCenterApi;", "baseUrl", "", "metricPlace", "isFromSearchBrowse", "", "factory", "io/intercom/android/sdk/helpcenter/articles/ArticleViewModel$Companion$factory$1", "(Lio/intercom/android/sdk/helpcenter/api/HelpCenterApi;Ljava/lang/String;Ljava/lang/String;Z)Lio/intercom/android/sdk/helpcenter/articles/ArticleViewModel$Companion$factory$1;", "intercom-sdk-base_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ArticleViewModel create(@NotNull ViewModelStoreOwner owner, @NotNull HelpCenterApi helpCenterApi, @NotNull String baseUrl, @NotNull String metricPlace, boolean isFromSearchBrowse) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)helpCenterApi, (String)"helpCenterApi");
            Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
            Intrinsics.checkNotNullParameter((Object)metricPlace, (String)"metricPlace");
            return (ArticleViewModel)new ViewModelProvider(owner, (ViewModelProvider.Factory)this.factory(helpCenterApi, baseUrl, metricPlace, isFromSearchBrowse)).get(ArticleViewModel.class);
        }

        private final factory.1 factory(HelpCenterApi helpCenterApi, String baseUrl, String metricPlace, boolean isFromSearchBrowse) {
            return new ViewModelProvider.Factory(helpCenterApi, baseUrl, metricPlace, isFromSearchBrowse){
                final /* synthetic */ HelpCenterApi $helpCenterApi;
                final /* synthetic */ String $baseUrl;
                final /* synthetic */ String $metricPlace;
                final /* synthetic */ boolean $isFromSearchBrowse;
                {
                    this.$helpCenterApi = $helpCenterApi;
                    this.$baseUrl = $baseUrl;
                    this.$metricPlace = $metricPlace;
                    this.$isFromSearchBrowse = $isFromSearchBrowse;
                }

                @NotNull
                public <T extends ViewModel> T create(@NotNull Class<T> modelClass) {
                    Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
                    AppConfig appConfig = Injector.get().getAppConfigProvider().get();
                    Intrinsics.checkNotNullExpressionValue((Object)appConfig, (String)"get().appConfigProvider.get()");
                    InboxState inboxState = Injector.get().getStore().state().inboxState();
                    Intrinsics.checkNotNullExpressionValue((Object)inboxState, (String)"get().store.state().inboxState()");
                    TeamPresence teamPresence = Injector.get().getStore().select(Selectors.TEAM_PRESENCE);
                    Intrinsics.checkNotNullExpressionValue((Object)teamPresence, (String)"get().store.select(Selectors.TEAM_PRESENCE)");
                    MetricTracker metricTracker = Injector.get().getMetricTracker();
                    Intrinsics.checkNotNullExpressionValue((Object)metricTracker, (String)"get().metricTracker");
                    return (T)new ArticleViewModel(this.$helpCenterApi, this.$baseUrl, appConfig, inboxState, teamPresence, metricTracker, this.$metricPlace, this.$isFromSearchBrowse, null, 256, null);
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

