/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views.holder;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.VisibleForTesting;
import androidx.core.view.MarginLayoutParamsCompat;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.conversation.attribute.AttributeMetadata;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.models.Attribute;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.utilities.ColorUtils;
import io.intercom.android.sdk.views.AttributeCollectorCardView;
import io.intercom.android.sdk.views.BaseAttributeView;
import io.intercom.android.sdk.views.BooleanAttributeView;
import io.intercom.android.sdk.views.DateAttributeView;
import io.intercom.android.sdk.views.ListAttributeView;
import io.intercom.android.sdk.views.TextAttributeView;
import io.intercom.android.sdk.views.holder.BlocksPartViewHolder;
import io.intercom.android.sdk.views.holder.ConversationListener;
import io.intercom.android.sdk.views.holder.ConversationPartViewHolder;
import java.util.List;
import java.util.Locale;

public class AttributeCollectorViewHolder
extends BlocksPartViewHolder
implements ConversationPartViewHolder {
    private final ConversationListener conversationListener;
    private final Provider<AppConfig> appConfigProvider;
    private final Locale locale;
    private final View.OnFocusChangeListener inputFocusChangeListener = new View.OnFocusChangeListener(){

        public void onFocusChange(View view, boolean isFocused) {
            if (isFocused) {
                AttributeCollectorViewHolder.this.expandAttributeCard();
            }
        }
    };

    public AttributeCollectorViewHolder(View itemView, Provider<AppConfig> appConfigProvider2, ConversationListener conversationListener, Locale locale) {
        super(itemView, conversationListener);
        this.conversationListener = conversationListener;
        this.appConfigProvider = appConfigProvider2;
        this.locale = locale;
        this.applyCardBorderStyle((View)this.cellLayout);
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.cellLayout.getLayoutParams();
        int marginStart = this.cellLayout.getContext().getResources().getDimensionPixelSize(R.dimen.intercom_attribute_part_left_margin);
        MarginLayoutParamsCompat.setMarginStart((ViewGroup.MarginLayoutParams)params, (int)marginStart);
    }

    @Override
    public void bind(Part part, ViewGroup blocksLayout) {
        if (this.networkAvatar != null) {
            this.showAvatar(part.getParticipant(), this.networkAvatar, this.appConfigProvider.get());
            this.updateAvatarMarginForCard(part);
        }
        this.renderAttributes(blocksLayout, part.getForm().getAttributes(), part.getId());
        if (this.cellLayout.getChildCount() > 0) {
            this.cellLayout.removeAllViews();
        }
        if (blocksLayout.getParent() != null) {
            ((ViewGroup)blocksLayout.getParent()).removeView((View)blocksLayout);
        }
        this.cellLayout.addView((View)blocksLayout);
    }

    @VisibleForTesting
    void renderAttributes(ViewGroup rootLayout, List<Attribute> attributes, String partId) {
        if (rootLayout.getChildCount() > 0) {
            rootLayout.removeAllViews();
        }
        int attributeSize = attributes.size();
        for (int index = 0; index < attributeSize; ++index) {
            Attribute attribute = attributes.get(index);
            AttributeMetadata metadata = new AttributeMetadata.Builder().withPosition(index).withTotalCount(attributeSize).build();
            this.addAttributeView(rootLayout, attribute, metadata, partId);
            if (attributeSize <= 1 || attribute.hasValue()) continue;
            this.updateMultiAttributesLabel(rootLayout);
            break;
        }
    }

    @VisibleForTesting
    void updateMultiAttributesLabel(ViewGroup rootLayout) {
        View childView;
        int renderedCount = rootLayout.getChildCount();
        if (renderedCount > 0 && (childView = rootLayout.getChildAt(0)) instanceof BaseAttributeView) {
            BaseAttributeView attributeView = (BaseAttributeView)childView;
            attributeView.showLabel(renderedCount);
        }
    }

    private void addAttributeView(ViewGroup rootLayout, Attribute attribute, AttributeMetadata metadata, String partId) {
        Context context = rootLayout.getContext();
        switch (attribute.getRenderType()) {
            case "text": 
            case "email": 
            case "company.website": 
            case "number": 
            case "float": 
            case "phone": {
                TextAttributeView textAttributeView = new TextAttributeView(context);
                textAttributeView.setMetadata(metadata);
                textAttributeView.updateSubmitButtonColor(this.appConfigProvider.get());
                textAttributeView.setOnSubmitClickListener(partId, this.conversationListener);
                textAttributeView.setUpAttribute(attribute, this.locale);
                textAttributeView.setOnFocusChangeListener(this.inputFocusChangeListener);
                rootLayout.addView((View)textAttributeView);
                break;
            }
            case "boolean": {
                BooleanAttributeView booleanAttributeView = new BooleanAttributeView(context);
                booleanAttributeView.setMetadata(metadata);
                booleanAttributeView.updateAttributeContent(attribute);
                booleanAttributeView.setOnSubmitClickListener(partId, this.conversationListener);
                rootLayout.addView((View)booleanAttributeView);
                break;
            }
            case "list": {
                ListAttributeView listAttributeView = new ListAttributeView(context);
                listAttributeView.setMetadata(metadata);
                listAttributeView.updateAttributeContent(attribute);
                listAttributeView.setOnClickListener(partId, this.conversationListener);
                rootLayout.addView((View)listAttributeView);
                break;
            }
            case "date": {
                DateAttributeView attributeView = new DateAttributeView(context);
                attributeView.setMetadata(metadata);
                attributeView.updateAttributeContent(attribute);
                attributeView.setOnClickListener(partId, this.conversationListener);
                rootLayout.addView((View)attributeView);
                break;
            }
        }
    }

    private void applyCardBorderStyle(View cardView) {
        ColorUtils.updateInnerBorderColor(this.appConfigProvider.get(), cardView);
    }

    @VisibleForTesting
    void expandAttributeCard() {
        if (this.cellLayout instanceof AttributeCollectorCardView) {
            AttributeCollectorCardView collectorView = (AttributeCollectorCardView)this.cellLayout;
            collectorView.animateToExpand();
            this.networkAvatar.setVisibility(8);
        }
    }

    public void onClick(View view) {
    }
}

