/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.push;

import android.annotation.SuppressLint;
import android.app.Notification;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.StyleSpan;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.core.app.NotificationCompat;
import com.intercom.commons.utilities.DeviceUtils;
import com.intercom.twig.Twig;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.push.IntercomPushBroadcastReceiver;
import io.intercom.android.sdk.push.IntercomPushTrampolineActivity;
import io.intercom.android.sdk.push.PushPayload;
import io.intercom.android.sdk.utilities.Phrase;
import java.util.List;

class SystemNotificationFactory {
    private static final String CONVERSATION_URI = "conversation_id=%s";
    private static final String INTERCOM_SDK_PUSH = "intercom_sdk_push";
    private static final Twig twig = LumberMill.getLogger();

    SystemNotificationFactory() {
    }

    Notification createSingleNotification(PushPayload payload, Context context, AppConfig appConfig, @Nullable Bitmap avatarImage, @Nullable Bitmap contentImage) {
        Uri destination = Uri.parse((String)String.format("intercom_sdk/conversation_id=%s", payload.getConversationId()));
        String channelId = this.getConversationChannelId(payload);
        String contentText = payload.getBody();
        CharSequence contentTitle = this.getTitle(context, payload);
        return this.createBuilder(context, destination, null, null, -1, channelId, appConfig, contentImage, contentText, contentTitle).setPriority(payload.getPriority()).setLargeIcon(avatarImage).build();
    }

    Notification createGroupedNotification(List<PushPayload> payloads, Context context, AppConfig appConfig) {
        Uri destination = Uri.parse((String)"intercom_sdk/multiple_notifications");
        CharSequence subtitle = payloads.size() == 1 ? context.getString(R.string.intercom_one_new_message) : Phrase.from(context, R.string.intercom_new_messages).put("n", payloads.size()).format();
        NotificationCompat.InboxStyle inboxStyle = new NotificationCompat.InboxStyle();
        inboxStyle.setBigContentTitle((CharSequence)context.getString(R.string.intercom_new_notifications));
        for (PushPayload payload : payloads) {
            SpannableString spannable = new SpannableString(this.groupMessageBody(payload));
            spannable.setSpan((Object)new StyleSpan(1), 0, payload.getAuthorName().length(), 33);
            inboxStyle.addLine((CharSequence)spannable);
        }
        String channelId = this.getConversationChannelId(payloads.get(payloads.size() - 1));
        String contentTitle = context.getString(R.string.intercom_new_notifications);
        return this.createBuilder(context, destination, null, null, -1, channelId, appConfig, null, subtitle, contentTitle).setPriority(payloads.get(payloads.size() - 1).getPriority()).setStyle((NotificationCompat.Style)inboxStyle).build();
    }

    private CharSequence groupMessageBody(PushPayload payload) {
        String message = payload.getMessage();
        if (!TextUtils.isEmpty((CharSequence)message)) {
            return message;
        }
        return payload.getAuthorName() + ": " + payload.getBody();
    }

    private String getConversationChannelId(PushPayload pushPayload) {
        return pushPayload.isFirstPart() ? "intercom_new_chats_channel" : "intercom_chat_replies_channel";
    }

    Notification createPushOnlyNotification(PushPayload payload, Context context, AppConfig appConfig, @Nullable Bitmap contentImage) {
        String conversationId = payload.getPushOnlyConversationId();
        String instanceId = payload.getInstanceId();
        int requestCode = TextUtils.isEmpty((CharSequence)instanceId) ? conversationId.hashCode() : instanceId.hashCode();
        String contentText = payload.messageOrBody();
        CharSequence contentTitle = this.getTitle(context, payload);
        return this.createBuilder(context, Uri.parse((String)payload.getUri()), conversationId, instanceId, requestCode, "intercom_actions_channel", appConfig, contentImage, contentText, contentTitle).setPriority(payload.getPriority()).build();
    }

    @VisibleForTesting
    NotificationCompat.Builder createBuilder(Context context, Uri destination, @Nullable String pushOnlyConversationId, @Nullable String pushOnlyInstanceId, int requestCode, String channelId, AppConfig appConfig, @Nullable Bitmap contentImage, CharSequence contentText, CharSequence contentTitle) {
        Intent openIntent = new Intent(context, IntercomPushTrampolineActivity.class);
        ComponentName receiverComponent = new ComponentName(context, IntercomPushBroadcastReceiver.class);
        Intent dismissIntent = new Intent("io.intercom.android.sdk.INTERCOM_PUSH_DISMISSED").setComponent(receiverComponent);
        String packageName = context.getPackageName();
        Intent hostAppIntent = context.getPackageManager().getLaunchIntentForPackage(packageName);
        if (hostAppIntent == null) {
            hostAppIntent = new Intent();
            twig.e("Couldn't get launch Intent for package '" + packageName + "' - tapping on notification will do nothing", new Object[0]);
        } else {
            hostAppIntent.addCategory("android.intent.category.LAUNCHER");
            hostAppIntent.setData(destination);
            hostAppIntent.putExtra("intercom_push_key", INTERCOM_SDK_PUSH);
            if (pushOnlyConversationId != null) {
                hostAppIntent.putExtra("push_only_convo_id", pushOnlyConversationId);
            }
            if (pushOnlyInstanceId != null) {
                hostAppIntent.putExtra("push_only_instance_id", pushOnlyInstanceId);
            }
        }
        openIntent.putExtra("host_app_intent", (Parcelable)hostAppIntent);
        dismissIntent.putExtra("host_app_intent", (Parcelable)hostAppIntent);
        int flags = 0x8000000;
        if (Build.VERSION.SDK_INT >= 23) {
            flags |= 0x4000000;
        }
        PendingIntent pendingOpenIntent = PendingIntent.getActivity((Context)context, (int)requestCode, (Intent)openIntent, (int)flags);
        PendingIntent pendingDismissIntent = PendingIntent.getBroadcast((Context)context, (int)requestCode, (Intent)dismissIntent, (int)flags);
        return this.baseNotificationBuilder(context, channelId, appConfig, pendingOpenIntent, pendingDismissIntent, contentImage, contentText, contentTitle);
    }

    @VisibleForTesting
    NotificationCompat.Builder baseNotificationBuilder(Context context, String channelId, AppConfig appConfig, PendingIntent contentIntent, PendingIntent deleteIntent, @Nullable Bitmap contentImage, CharSequence contentText, CharSequence contentTitle) {
        int vibrateFlag = DeviceUtils.hasPermission((Context)context, (String)"android.permission.VIBRATE") ? 2 : 0;
        int primaryColor = appConfig.getPrimaryColor();
        NotificationCompat.Builder builder = new NotificationCompat.Builder(context, channelId).setContentText(contentText).setContentTitle(contentTitle).setSmallIcon(R.drawable.intercom_push_icon).setCategory("msg").setAutoCancel(true).setColor(primaryColor).setLights(primaryColor, 500, 2000).setContentIntent(contentIntent).setDeleteIntent(deleteIntent).setDefaults(1 | vibrateFlag);
        if (contentImage != null) {
            builder.setStyle((NotificationCompat.Style)new NotificationCompat.BigPictureStyle().bigPicture(contentImage).setBigContentTitle(contentTitle).setSummaryText(contentText).bigLargeIcon(null));
            builder.setLargeIcon(contentImage);
        } else {
            builder.setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().setBigContentTitle(contentTitle).bigText(contentText));
        }
        return builder;
    }

    @SuppressLint(value={"PrivateResource"})
    CharSequence getTitle(Context context, PushPayload payload) {
        String title = payload.getTitle();
        if (!title.isEmpty()) {
            return title;
        }
        String authorName = payload.getAuthorName();
        String appName = payload.getAppName();
        if (!authorName.isEmpty() && !appName.isEmpty()) {
            return Phrase.from(context, R.string.intercom_teammate_from_company).put("name", authorName).put("company", appName).format();
        }
        return authorName.isEmpty() ? appName : authorName;
    }
}

