/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation.composer.textinput;

import android.os.Handler;
import android.text.Editable;
import android.text.TextWatcher;
import io.intercom.android.nexus.NexusClient;
import io.intercom.android.nexus.NexusEvent;
import io.intercom.android.sdk.actions.Actions;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Store;

class TextInputWatcher
implements TextWatcher {
    private static final long IS_TYPING_DELAY = 1000L;
    private final Handler handler;
    private final String userId;
    private final NexusClient nexusClient;
    private final Store<State> store;
    private String conversationId = "";
    boolean shouldSendIsTyping = true;

    TextInputWatcher(String userId, NexusClient nexusClient, Store<State> store, Handler handler) {
        this.userId = userId;
        this.nexusClient = nexusClient;
        this.store = store;
        this.handler = handler;
    }

    protected void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
    }

    public void afterTextChanged(Editable editable) {
        if (this.shouldSendIsTyping) {
            this.shouldSendIsTyping = false;
            this.handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    TextInputWatcher.this.shouldSendIsTyping = true;
                }
            }, 1000L);
            this.nexusClient.fire(NexusEvent.getUserIsTypingEvent((String)this.conversationId, (String)this.userId));
            if (editable.length() == 0) {
                this.store.dispatch(Actions.composerCleared(this.conversationId));
            } else {
                this.store.dispatch(Actions.composerTypedIn(this.conversationId));
            }
        }
    }
}

