/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.VisibleForTesting;
import com.intercom.twig.Twig;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.activities.IntercomCarouselActivity;
import io.intercom.android.sdk.activities.IntercomMessengerActivity;
import io.intercom.android.sdk.activities.IntercomNoteActivity;
import io.intercom.android.sdk.activities.IntercomPostActivity;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.helpcenter.utils.HelpCenterUrlUtilsKt;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.survey.ui.IntercomSurveyActivity;
import io.intercom.android.sdk.utilities.IntentUtils;
import java.util.Locale;
import java.util.Set;

public class LinkOpener {
    private static final Twig twig = LumberMill.getLogger();

    public static void handleUrl(String url, Context context, Api api) {
        Uri uri;
        if (TextUtils.isEmpty((CharSequence)url)) {
            return;
        }
        if (LinkOpener.isTrackingUrl(url)) {
            api.hitTrackingUrl(url);
            uri = LinkOpener.getTargetUriFromTrackingUrl(url);
        } else {
            uri = LinkOpener.parseUrl(url);
        }
        AppConfig config = Injector.get().getAppConfigProvider().get();
        Set<String> helpCenterUrls = config.getHelpCenterUrls();
        String parsedUrl = uri.toString();
        String metricPlace = LinkOpener.getPlaceFromContext(context);
        if (HelpCenterUrlUtilsKt.isHelpCenterArticleUrl(parsedUrl, helpCenterUrls)) {
            HelpCenterUrlUtilsKt.openArticle(context, HelpCenterUrlUtilsKt.extractIdFromLastSegment(uri.getLastPathSegment()), metricPlace);
        } else if (HelpCenterUrlUtilsKt.isHelpCenterCollectionUrl(parsedUrl, helpCenterUrls)) {
            HelpCenterUrlUtilsKt.openCollection(context, HelpCenterUrlUtilsKt.extractIdFromLastSegment(uri.getLastPathSegment()), metricPlace);
        } else {
            LinkOpener.openUrl(uri, context);
        }
    }

    private static String getPlaceFromContext(Context context) {
        if (context instanceof IntercomCarouselActivity) {
            return "carousel_message";
        }
        if (context instanceof IntercomPostActivity || context instanceof IntercomNoteActivity) {
            return "in_app";
        }
        if (context instanceof IntercomMessengerActivity) {
            return "conversation";
        }
        if (context instanceof IntercomSurveyActivity) {
            return "survey";
        }
        return "push";
    }

    @VisibleForTesting
    static Uri getTargetUriFromTrackingUrl(String trackingUrl) {
        Uri uri = Uri.parse((String)trackingUrl);
        String queryUrl = uri.isHierarchical() ? uri.getQueryParameter("url") : trackingUrl;
        String targetUrl = queryUrl == null ? trackingUrl : queryUrl;
        return LinkOpener.parseUrl(targetUrl);
    }

    private static Uri parseUrl(String url) {
        Uri uri = Uri.parse((String)url);
        if (uri.getScheme() == null) {
            uri = Uri.parse((String)("http://" + url));
        }
        if (uri.getScheme().equalsIgnoreCase("http") || uri.getScheme().equalsIgnoreCase("https")) {
            uri = LinkOpener.normalizeScheme(uri);
        }
        return uri;
    }

    private static Uri normalizeScheme(Uri uri) {
        String scheme = uri.getScheme();
        if (scheme == null) {
            return uri;
        }
        String lowerScheme = scheme.toLowerCase(Locale.ROOT);
        if (scheme.equals(lowerScheme)) {
            return uri;
        }
        return uri.buildUpon().scheme(lowerScheme).build();
    }

    private static boolean isTrackingUrl(String url) {
        return url.contains("via.intercom.io");
    }

    private static void openUrl(Uri uri, Context context) {
        String action = "mailto".equals(uri.getScheme()) ? "android.intent.action.SENDTO" : "android.intent.action.VIEW";
        Intent intent = new Intent(action, uri);
        intent.addFlags(0x10000000);
        try {
            IntentUtils.safelyOpenIntent(context, intent);
        }
        catch (ActivityNotFoundException e) {
            twig.e("No Activity found to handle the URL '" + uri.toString() + "'", new Object[0]);
        }
        catch (SecurityException e) {
            twig.e("Couldn't open link because of error: " + e.getMessage(), new Object[0]);
        }
    }
}

