/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import io.intercom.android.sdk.IntercomStatusCallback;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.actions.Actions;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.api.UserUpdateRequest;
import io.intercom.android.sdk.metrics.ops.OpsMetricTracker;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Store;

public class UserUpdater {
    private final Provider<Api> apiProvider;
    private final Store<State> store;
    private OpsMetricTracker opsMetricTracker;

    public UserUpdater(Provider<Api> apiProvider, Store<State> store, OpsMetricTracker opsMetricTracker) {
        this.apiProvider = apiProvider;
        this.store = store;
        this.opsMetricTracker = opsMetricTracker;
    }

    public synchronized void updateUser(UserUpdateRequest userUpdateRequest, IntercomStatusCallback intercomStatusCallback) {
        this.opsMetricTracker.trackEvent("start", "time-to-complete-ping-ms");
        if (!userUpdateRequest.isValidUpdate()) {
            return;
        }
        if (userUpdateRequest.isNewSession()) {
            this.store.dispatch(Actions.sessionStarted());
        }
        this.apiProvider.get().updateUser(userUpdateRequest, intercomStatusCallback);
    }
}

