/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.imageloader;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.widget.ImageView;
import coil.request.ImageRequest;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.utilities.BitmapUtilsKt;
import io.intercom.android.sdk.utilities.IntercomCoilKt;
import java.io.IOException;
import kotlin.Unit;

public class WallpaperLoader {
    private final Provider<AppConfig> appConfigProvider;

    public static WallpaperLoader create(Context context, Provider<AppConfig> appConfigProvider) {
        return new WallpaperLoader(appConfigProvider);
    }

    WallpaperLoader(Provider<AppConfig> appConfigProvider) {
        this.appConfigProvider = appConfigProvider;
    }

    public void loadWallpaperInto(ImageView imageView) {
        String wallpaperUrl = this.appConfigProvider.get().getWallpaper();
        if (TextUtils.isEmpty((CharSequence)wallpaperUrl)) {
            return;
        }
        ImageRequest imageRequest = new ImageRequest.Builder(imageView.getContext()).data((Object)wallpaperUrl).target(onStartDrawable -> Unit.INSTANCE, onErrorDrawable -> Unit.INSTANCE, onSuccessDrawable -> {
            Bitmap bitmap = BitmapUtilsKt.drawableToBitmap(onSuccessDrawable, 1, 1);
            bitmap.setDensity(160);
            BitmapDrawable tiledWallpaper = new BitmapDrawable(imageView.getContext().getResources(), bitmap);
            tiledWallpaper.setTileModeXY(Shader.TileMode.REPEAT, Shader.TileMode.REPEAT);
            imageView.setBackground((Drawable)tiledWallpaper);
            return Unit.INSTANCE;
        }).build();
        IntercomCoilKt.loadIntercomImage(imageView.getContext(), imageRequest);
    }

    public void close() throws IOException {
        IntercomCoilKt.cleanUp();
    }
}

