/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.helpcenter.utils.networking;

import io.intercom.android.sdk.helpcenter.utils.networking.NetworkResponse;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Request;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00040\u0003B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\t\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00018\u00008\u00000\u0000H\u0016J\u001c\u0010\u000b\u001a\u00020\b2\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040\rH\u0016J\u0014\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/intercom/android/sdk/helpcenter/utils/networking/NetworkResponseCall;", "S", "", "Lretrofit2/Call;", "Lio/intercom/android/sdk/helpcenter/utils/networking/NetworkResponse;", "delegate", "(Lretrofit2/Call;)V", "cancel", "", "clone", "kotlin.jvm.PlatformType", "enqueue", "callback", "Lretrofit2/Callback;", "execute", "Lretrofit2/Response;", "isCanceled", "", "isExecuted", "request", "Lokhttp3/Request;", "timeout", "Lokio/Timeout;", "intercom-sdk-base_release"})
public final class NetworkResponseCall<S>
implements Call<NetworkResponse<? extends S>> {
    @NotNull
    private final Call<S> delegate;

    public NetworkResponseCall(@NotNull Call<S> delegate) {
        Intrinsics.checkNotNullParameter(delegate, (String)"delegate");
        this.delegate = delegate;
    }

    public void enqueue(@NotNull Callback<NetworkResponse<S>> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.delegate.enqueue(new Callback<S>(callback, this){
            final /* synthetic */ Callback<NetworkResponse<S>> $callback;
            final /* synthetic */ NetworkResponseCall<S> this$0;
            {
                this.$callback = $callback;
                this.this$0 = $receiver;
            }

            public void onResponse(@NotNull Call<S> call, @NotNull Response<S> response) {
                Intrinsics.checkNotNullParameter(call, (String)"call");
                Intrinsics.checkNotNullParameter(response, (String)"response");
                Object body = response.body();
                int code = response.code();
                if (response.isSuccessful()) {
                    if (body != null) {
                        this.$callback.onResponse((Call)this.this$0, Response.success(new NetworkResponse.Success<Object>(body)));
                    } else {
                        this.$callback.onResponse((Call)this.this$0, Response.success((Object)new NetworkResponse.UnknownError(new Throwable())));
                    }
                } else {
                    this.$callback.onResponse((Call)this.this$0, Response.success((Object)new NetworkResponse.ApiError(code)));
                }
            }

            public void onFailure(@NotNull Call<S> call, @NotNull Throwable throwable) {
                Intrinsics.checkNotNullParameter(call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                Throwable throwable2 = throwable;
                NetworkResponse networkResponse = throwable2 instanceof IOException ? (NetworkResponse)new NetworkResponse.NetworkError((IOException)throwable) : (NetworkResponse)new NetworkResponse.UnknownError(throwable);
                this.$callback.onResponse((Call)this.this$0, Response.success((Object)networkResponse));
            }
        });
    }

    public boolean isExecuted() {
        return this.delegate.isExecuted();
    }

    @NotNull
    public NetworkResponseCall<S> clone() {
        Call call = this.delegate.clone();
        Intrinsics.checkNotNullExpressionValue((Object)call, (String)"delegate.clone()");
        return new NetworkResponseCall<S>(call);
    }

    public boolean isCanceled() {
        return this.delegate.isCanceled();
    }

    public void cancel() {
        this.delegate.cancel();
    }

    @NotNull
    public Response<NetworkResponse<S>> execute() {
        throw new UnsupportedOperationException("NetworkResponseCall doesn't support execute");
    }

    @NotNull
    public Request request() {
        Request request = this.delegate.request();
        Intrinsics.checkNotNullExpressionValue((Object)request, (String)"delegate.request()");
        return request;
    }

    @NotNull
    public Timeout timeout() {
        Timeout timeout = this.delegate.timeout();
        Intrinsics.checkNotNullExpressionValue((Object)timeout, (String)"delegate.timeout()");
        return timeout;
    }
}

