/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.middleware;

import com.squareup.otto.Bus;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.actions.Action;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.models.BaseResponse;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Store;

public class AppConfigMiddleware
implements Store.Middleware<State> {
    private final Provider<AppConfig> appConfigProvider;
    private final Bus bus;

    public AppConfigMiddleware(Provider<AppConfig> appConfigProvider, Bus bus) {
        this.appConfigProvider = appConfigProvider;
        this.bus = bus;
    }

    @Override
    public void dispatch(Store<State> store, Action<?> action, Store.NextDispatcher next) {
        next.dispatch(action);
        switch (action.type()) {
            case BASE_RESPONSE_RECEIVED: {
                BaseResponse response = (BaseResponse)action.value();
                this.appConfigProvider.get().update(response.getConfig(), this.bus);
                break;
            }
            case HARD_RESET: {
                this.appConfigProvider.get().reset();
                break;
            }
        }
    }
}

