/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.articles;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.text.TextUtils;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import io.intercom.android.sdk.articles.ArticleWebViewListener;
import io.intercom.android.sdk.helpcenter.utils.HelpCenterUrlUtilsKt;
import java.util.Set;

public class ArticleWebViewClient
extends WebViewClient {
    private final String articleUrl;
    private final ArticleWebViewListener articleWebViewListener;
    private boolean isLoadError;
    private boolean isArticleNotFound = false;
    private final Set<String> helpCenterUrls;

    public ArticleWebViewClient(String url, ArticleWebViewListener articleWebViewListener, Set<String> helpCenterUrls) {
        this.articleUrl = url;
        this.articleWebViewListener = articleWebViewListener;
        this.helpCenterUrls = helpCenterUrls;
    }

    public void onReceivedHttpError(WebView view, WebResourceRequest request, WebResourceResponse errorResponse) {
        super.onReceivedHttpError(view, request, errorResponse);
        if (errorResponse.getStatusCode() == 404 || errorResponse.getStatusCode() == 401) {
            this.isLoadError = true;
            this.isArticleNotFound = true;
            this.articleWebViewListener.articleNotFound();
        }
    }

    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        if (!this.isLoadError && !this.isArticleNotFound) {
            this.articleWebViewListener.onArticleFinishedLoading();
        }
    }

    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        super.onPageStarted(view, url, favicon);
        if (!this.isArticleNotFound) {
            this.isLoadError = false;
            this.articleWebViewListener.onArticleStartedLoading();
        }
    }

    public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
        super.onReceivedError(view, request, error);
        this.isLoadError = true;
        this.articleWebViewListener.onArticleLoadingError();
    }

    public boolean shouldOverrideUrlLoading(WebView view, String urlString) {
        Uri urlUri = Uri.parse((String)urlString);
        Uri articleUri = Uri.parse((String)this.articleUrl);
        String loadingUrlLastSegment = urlUri.getLastPathSegment();
        String articleUrlLastSegment = articleUri.getLastPathSegment();
        Context context = view.getContext();
        if (!TextUtils.isEmpty((CharSequence)loadingUrlLastSegment) && !TextUtils.isEmpty((CharSequence)articleUrlLastSegment) && loadingUrlLastSegment.contains(articleUrlLastSegment)) {
            return false;
        }
        if (HelpCenterUrlUtilsKt.isHelpCenterArticleUrl(urlString, this.helpCenterUrls)) {
            HelpCenterUrlUtilsKt.openArticle(context, HelpCenterUrlUtilsKt.extractIdFromLastSegment(loadingUrlLastSegment), "article");
        } else if (HelpCenterUrlUtilsKt.isHelpCenterCollectionUrl(urlString, this.helpCenterUrls)) {
            HelpCenterUrlUtilsKt.openCollection(context, HelpCenterUrlUtilsKt.extractIdFromLastSegment(loadingUrlLastSegment), "article");
        } else {
            context.startActivity(new Intent("android.intent.action.VIEW", urlUri));
        }
        return true;
    }

    public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
        return this.shouldOverrideUrlLoading(view, request.getUrl().toString());
    }
}

