/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.profile;

import android.content.Context;
import android.view.View;
import com.google.android.material.appbar.AppBarLayout;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.utilities.WindowUtils;

abstract class ProfileToolbarBehavior
implements AppBarLayout.OnOffsetChangedListener {
    float toolbarHeight;

    public ProfileToolbarBehavior(Context context) {
        this.toolbarHeight = context.getResources().getDimension(R.dimen.intercom_toolbar_height);
        this.toolbarHeight += (float)WindowUtils.getStatusBarHeight(context.getResources());
    }

    protected void setAlphaAsPercentageOfScroll(View child, View dependency, float maxAlpha, boolean fadeOut) {
        float scrollPercentage = this.getScrollPercentage(dependency);
        if (fadeOut) {
            scrollPercentage = 100.0f - scrollPercentage;
        }
        child.setAlpha(maxAlpha / 100.0f * scrollPercentage);
    }

    protected float getScrollPercentage(View dependency) {
        float dependencyHeight = (float)dependency.getHeight() - this.toolbarHeight;
        float dependencyBottom = (float)dependency.getBottom() - this.toolbarHeight;
        return dependencyBottom / dependencyHeight * 100.0f;
    }
}

