/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import com.intercom.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.R;

public class BlockUtils {
    private static final int DEFAULT_MARGIN_BOTTOM_DP = 10;
    private static final int SMALL_LINE_SPACING_DP = 2;
    private static final int LARGE_LINE_SPACING_DP = 4;

    public static void createLayoutParams(View view, int width, int height) {
        view.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(width, height));
    }

    public static void setDefaultMarginBottom(View view) {
        BlockUtils.setMarginBottom(view, 10);
    }

    public static void setMarginBottom(View view, int valueInDp) {
        ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
        params.bottomMargin = ScreenUtils.dpToPx((float)valueInDp, (Context)view.getContext());
    }

    public static void setMarginLeft(View view, int valueInDp) {
        ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
        params.setMarginStart(ScreenUtils.dpToPx((float)valueInDp, (Context)view.getContext()));
    }

    public static void setLayoutMarginsAndGravity(View view, int gravity, boolean shouldStripBottomPadding) {
        LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)view.getLayoutParams();
        if (shouldStripBottomPadding) {
            params.setMargins(params.leftMargin, params.topMargin, params.rightMargin, 0);
        }
        params.gravity = gravity;
    }

    public static void setSmallLineSpacing(TextView textView) {
        BlockUtils.setLineSpacing(textView, 2);
    }

    public static void setLargeLineSpacing(TextView textView) {
        BlockUtils.setLineSpacing(textView, 4);
    }

    private static void setLineSpacing(TextView textView, int lineSpacingDp) {
        textView.setLineSpacing((float)ScreenUtils.dpToPx((float)lineSpacingDp, (Context)textView.getContext()), 1.0f);
    }

    public static View getBlockView(ViewGroup parent, LinearLayout blocks, Context context) {
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        View row = inflater.inflate(R.layout.intercom_container_layout, parent, false);
        LinearLayout cellLayout = (LinearLayout)row.findViewById(R.id.cellLayout);
        if (blocks.getParent() != null) {
            ((LinearLayout)blocks.getParent()).removeView((View)blocks);
        }
        if (cellLayout.getChildCount() > 0) {
            cellLayout.removeAllViews();
        }
        cellLayout.addView((View)blocks, 0);
        row.setFocusable(false);
        cellLayout.setVisibility(0);
        return row;
    }

    public static void removeClickAbilityAnnouncement(View view) {
        ViewCompat.setAccessibilityDelegate((View)view, (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(){

            public void onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfoCompat info) {
                super.onInitializeAccessibilityNodeInfo(host, info);
                info.removeAction(AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_CLICK);
                info.removeAction(AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_LONG_CLICK);
                info.setClickable(false);
                info.setLongClickable(false);
            }
        });
    }

    public static void addHeadingAnnouncement(View view) {
        ViewCompat.setAccessibilityDelegate((View)view, (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(){

            public void onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfoCompat info) {
                super.onInitializeAccessibilityNodeInfo(host, info);
                info.setHeading(true);
            }
        });
    }
}

