/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.metrics;

import com.google.gson.annotations.SerializedName;
import com.intercom.commons.utilities.TimeProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class MetricObject {
    private static final String KEY_ANDROID_INSTALLER_PACKAGE_NAME = "android_installer_package_name";
    private static final String KEY_ANDROID_IS_DEBUG_BUILD = "android_is_debug_build";
    static final String KEY_SDK_VERSION = "sdk_version";
    static final String KEY_APP_VERSION = "app_version";
    static final String KEY_USER_ID = "user_id";
    static final String KEY_ACTION = "action";
    static final String KEY_OBJECT = "object";
    static final String KEY_PLACE = "place";
    static final String KEY_CONTEXT = "context";
    static final String KEY_OWNER = "owner";
    static final String KEY_CONVERSATION_SHOWN = "conversation_shown";
    private final Map<String, Object> metadata = new HashMap<String, Object>();
    private final String id;
    @SerializedName(value="created_at")
    private final long createdAt;
    private final String name;

    MetricObject(String name, String owner, String id2, String intercomId, String action, String object, String place, String context, TimeProvider timeProvider, String appVersion, String sdkVersion) {
        this.name = name;
        this.createdAt = TimeUnit.MILLISECONDS.toSeconds(timeProvider.currentTimeMillis());
        this.id = id2;
        this.metadata.put(KEY_ACTION, action);
        this.metadata.put(KEY_OBJECT, object);
        this.metadata.put(KEY_PLACE, place);
        this.metadata.put(KEY_CONTEXT, context);
        this.metadata.put(KEY_OWNER, owner);
        if (!intercomId.isEmpty()) {
            this.metadata.put(KEY_USER_ID, intercomId);
        }
        this.metadata.put(KEY_SDK_VERSION, sdkVersion);
        this.metadata.put(KEY_APP_VERSION, appVersion);
    }

    MetricObject addMetaData(String key, Object value) {
        this.metadata.put(key, value);
        return this;
    }

    MetricObject addIsDebugBuild(boolean isDebugBuild) {
        this.addMetaData(KEY_ANDROID_IS_DEBUG_BUILD, isDebugBuild);
        return this;
    }

    MetricObject addInstallerPackageName(String installerPackageName) {
        this.addMetaData(KEY_ANDROID_INSTALLER_PACKAGE_NAME, installerPackageName);
        return this;
    }

    public String getId() {
        return this.id;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricObject that = (MetricObject)o;
        if (this.createdAt != that.createdAt) {
            return false;
        }
        if (!this.metadata.equals(that.metadata)) {
            return false;
        }
        return this.id != null ? this.id.equals(that.id) : that.id == null;
    }

    public int hashCode() {
        int result = this.metadata.hashCode();
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (int)(this.createdAt ^ this.createdAt >>> 32);
        return result;
    }

    public String toString() {
        return "MetricObject{metadata=" + this.metadata + ", id='" + this.id + '\'' + ", createdAt=" + this.createdAt + '}';
    }
}

