/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.helpcenter.search;

import android.text.Editable;
import android.text.Html;
import android.text.style.ForegroundColorSpan;
import android.text.style.StyleSpan;
import androidx.annotation.ColorInt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.XMLReader;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J(\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/intercom/android/sdk/helpcenter/search/HighlightTagHandler;", "Landroid/text/Html$TagHandler;", "highlightColor", "", "(I)V", "endIndex", "startIndex", "applyBoldSpan", "", "text", "Landroid/text/Editable;", "applyColorSpan", "handleTag", "opening", "", "tag", "", "output", "xmlReader", "Lorg/xml/sax/XMLReader;", "Companion", "intercom-sdk-base_release"})
public final class HighlightTagHandler
implements Html.TagHandler {
    private int startIndex;
    private int endIndex;
    private final int highlightColor;
    private static final int SPAN_FLAG = 33;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void handleTag(boolean opening, @NotNull String tag, @NotNull Editable output, @NotNull XMLReader xmlReader) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)xmlReader, (String)"xmlReader");
        if (StringsKt.equals((String)tag, (String)"highlight", (boolean)true)) {
            if (opening) {
                this.startIndex = output.length();
            } else {
                this.endIndex = output.length();
                this.applyBoldSpan(output);
                this.applyColorSpan(output);
            }
        }
    }

    private final void applyBoldSpan(Editable text) {
        StyleSpan boldSpan = new StyleSpan(1);
        text.setSpan((Object)boldSpan, this.startIndex, this.endIndex, 33);
    }

    private final void applyColorSpan(Editable text) {
        text.setSpan((Object)new ForegroundColorSpan(this.highlightColor), this.startIndex, this.endIndex, 33);
    }

    public HighlightTagHandler(@ColorInt int highlightColor) {
        this.highlightColor = highlightColor;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/intercom/android/sdk/helpcenter/search/HighlightTagHandler$Companion;", "", "()V", "SPAN_FLAG", "", "intercom-sdk-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

