/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.preview;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.annotation.TargetApi;
import android.view.View;

@TargetApi(value=11)
public class PreviewAnimation {
    private static final int OFFSET_MS = 500;

    static void fadeInPreview(View notificationAvatar, View indicatorTextView, View shadow) {
        notificationAvatar.setAlpha(0.0f);
        indicatorTextView.setAlpha(0.0f);
        shadow.setAlpha(0.0f);
        PropertyValuesHolder alpha = PropertyValuesHolder.ofFloat((String)"alpha", (float[])new float[]{0.0f, 1.0f});
        PropertyValuesHolder scaleX = PropertyValuesHolder.ofFloat((String)"scaleX", (float[])new float[]{0.6f, 1.0f});
        PropertyValuesHolder scaleY = PropertyValuesHolder.ofFloat((String)"scaleY", (float[])new float[]{0.6f, 1.0f});
        ObjectAnimator avatarAnimation = ObjectAnimator.ofPropertyValuesHolder((Object)notificationAvatar, (PropertyValuesHolder[])new PropertyValuesHolder[]{alpha, scaleX, scaleY});
        avatarAnimation.setDuration(200L);
        avatarAnimation.setStartDelay(500L);
        ObjectAnimator shadowAnimation = avatarAnimation.clone();
        shadowAnimation.setTarget((Object)shadow);
        ObjectAnimator indicatorAnimation = avatarAnimation.clone();
        indicatorAnimation.setStartDelay(680L);
        indicatorAnimation.setTarget((Object)indicatorTextView);
        avatarAnimation.start();
        indicatorAnimation.start();
        shadowAnimation.start();
    }

    static AnimatorSet animateTextPreview(View target, boolean isLeftAligned) {
        if (isLeftAligned) {
            return PreviewAnimation.animateTextPreview(target, target.getTranslationX() - 120.0f);
        }
        return PreviewAnimation.animateTextPreview(target, target.getTranslationX() + 120.0f);
    }

    private static AnimatorSet animateTextPreview(View target, float offset) {
        PropertyValuesHolder entranceAlpha = PropertyValuesHolder.ofFloat((String)"alpha", (float[])new float[]{0.0f, 1.0f});
        PropertyValuesHolder entranceScaleX = PropertyValuesHolder.ofFloat((String)"scaleX", (float[])new float[]{0.6f, 1.0f});
        PropertyValuesHolder entranceScaleY = PropertyValuesHolder.ofFloat((String)"scaleY", (float[])new float[]{0.6f, 1.0f});
        PropertyValuesHolder entranceTranslationX = PropertyValuesHolder.ofFloat((String)"translationX", (float[])new float[]{offset, target.getTranslationX()});
        ObjectAnimator entranceAnim = ObjectAnimator.ofPropertyValuesHolder((Object)target, (PropertyValuesHolder[])new PropertyValuesHolder[]{entranceAlpha, entranceScaleX, entranceScaleY, entranceTranslationX});
        entranceAnim.setDuration(200L);
        entranceAnim.setStartDelay(720L);
        PropertyValuesHolder exitAlpha = PropertyValuesHolder.ofFloat((String)"alpha", (float[])new float[]{1.0f, 0.0f});
        PropertyValuesHolder exitScaleX = PropertyValuesHolder.ofFloat((String)"scaleX", (float[])new float[]{1.0f, 0.6f});
        PropertyValuesHolder exitScaleY = PropertyValuesHolder.ofFloat((String)"scaleY", (float[])new float[]{1.0f, 0.6f});
        PropertyValuesHolder exitTranslationX = PropertyValuesHolder.ofFloat((String)"translationX", (float[])new float[]{target.getTranslationX(), offset});
        ObjectAnimator exit = ObjectAnimator.ofPropertyValuesHolder((Object)target, (PropertyValuesHolder[])new PropertyValuesHolder[]{exitAlpha, exitScaleX, exitScaleY, exitTranslationX});
        exit.setDuration(50L);
        exit.setStartDelay(6500L);
        AnimatorSet set = new AnimatorSet();
        set.playSequentially(new Animator[]{entranceAnim, exit});
        return set;
    }
}

