/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation;

import android.content.Context;
import android.graphics.Color;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.conversation.ComposerTextWatcher;
import io.intercom.android.sdk.conversation.events.SendingEvent;

public class ComposerInputView
extends LinearLayout
implements View.OnFocusChangeListener,
View.OnClickListener {
    protected EditText messageTextBox;
    protected ImageButton sendButton;
    protected ImageButton attachmentButton;
    protected ComposerTextWatcher textWatcher;

    public ComposerInputView(Context context, AttributeSet attrs) {
        super(context, attrs);
        ComposerInputView.inflate((Context)this.getContext(), (int)R.layout.intercomsdk_composer_input_layout, (ViewGroup)this);
        this.sendButton = (ImageButton)this.findViewById(R.id.send_button);
        this.sendButton.setColorFilter(Color.parseColor((String)Bridge.getIdentityStore().getAppConfig().getBaseColor()));
        this.attachmentButton = (ImageButton)this.findViewById(R.id.attachment_button);
        this.attachmentButton.setColorFilter(context.getResources().getColor(R.color.intercomsdk_attachment_color));
        this.messageTextBox = (EditText)this.findViewById(R.id.input_text);
        this.messageTextBox.setOnFocusChangeListener((View.OnFocusChangeListener)this);
        this.sendButton.setOnClickListener((View.OnClickListener)this);
        this.attachmentButton.setOnClickListener((View.OnClickListener)this);
        this.textWatcher = new ComposerTextWatcher(this.sendButton, this.attachmentButton, Bridge.getIdentityStore().getIntercomId());
        this.messageTextBox.addTextChangedListener((TextWatcher)this.textWatcher);
    }

    public void onFocusChange(View view, boolean hasFocus) {
        if (view.getId() == R.id.input_text && !hasFocus) {
            InputMethodManager inputMethodManager = (InputMethodManager)this.getContext().getSystemService("input_method");
            inputMethodManager.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
    }

    public void onClick(View v) {
        if (v.getId() == R.id.send_button) {
            Bridge.getBus().post((Object)new SendingEvent(false));
        } else {
            Bridge.getBus().post((Object)new SendingEvent(true));
        }
    }

    protected void setConversationId(String conversationId) {
        this.textWatcher.setConversationId(conversationId);
    }

    protected String getTrimmedText() {
        return this.messageTextBox.getText().toString().trim();
    }

    protected void hideKeyboard() {
        InputMethodManager imm = (InputMethodManager)this.getContext().getSystemService("input_method");
        imm.hideSoftInputFromWindow(this.messageTextBox.getWindowToken(), 0);
    }

    protected void setHint(int hintRes) {
        this.messageTextBox.setHint(hintRes);
    }

    protected void requestInputFocus() {
        this.messageTextBox.requestFocus();
    }

    protected void clear() {
        this.messageTextBox.setText((CharSequence)"");
    }

    protected void cleanup() {
        this.messageTextBox.removeTextChangedListener((TextWatcher)this.textWatcher);
        this.clear();
        this.textWatcher.cleanup();
    }
}

