/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;
import io.intercom.android.sdk.R;

public class MaxSizeLinearLayout
extends LinearLayout {
    private final int maxWidth;
    private final int maxHeight;

    public MaxSizeLinearLayout(Context context) {
        super(context);
        this.maxWidth = Integer.MAX_VALUE;
        this.maxHeight = Integer.MAX_VALUE;
    }

    public MaxSizeLinearLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.MaxSizeLinearLayout);
        this.maxWidth = a.getDimensionPixelSize(R.styleable.MaxSizeLinearLayout_intercomsdk_maxWidth, Integer.MAX_VALUE);
        this.maxHeight = a.getDimensionPixelSize(R.styleable.MaxSizeLinearLayout_intercomsdk_maxHeight, Integer.MAX_VALUE);
        a.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int measuredWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int measuredHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (this.maxWidth > 0 && this.maxWidth < measuredWidth) {
            widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.maxWidth, (int)Integer.MIN_VALUE);
        }
        if (this.maxHeight > 0 && this.maxHeight < measuredHeight) {
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.maxHeight, (int)Integer.MIN_VALUE);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }
}

