/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.conversation.events.AdminIsTypingEvent;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.metrics.MetricType;
import io.intercom.android.sdk.models.Events.realtime.CreateConversationEvent;
import io.intercom.android.sdk.models.Events.realtime.NewCommentEvent;
import io.intercom.android.sdk.nexus.NexusClient;
import io.intercom.android.sdk.nexus.NexusConfig;
import io.intercom.android.sdk.nexus.NexusEvent;
import io.intercom.android.sdk.nexus.NexusListener;

public class NexusWrapper
extends NexusClient
implements NexusListener {
    public void connect(NexusConfig config, boolean shouldSendPresence) {
        if (!this.isConnected() && !config.getEndpoints().isEmpty()) {
            super.connect(config, shouldSendPresence);
            this.addEventListener(this);
        }
    }

    public void disconnect() {
        this.removeEventListener(this);
        super.disconnect();
    }

    public void cycle(NexusConfig config, boolean shouldSendPresence) {
        this.disconnect();
        this.connect(config, shouldSendPresence);
    }

    public void notifyEvent(NexusEvent event) {
        switch (event) {
            case AdminIsTyping: {
                if (!NexusWrapper.isRealTime()) break;
                IntercomLogger.INTERNAL("realtime", "received " + event.name() + " event");
                Bridge.getBus().post((Object)new AdminIsTypingEvent(event.getAdminId(), event.getConversationId(), event.getAdminName(), event.getAdminAvatarUrl()));
                break;
            }
            case NewComment: {
                IntercomLogger.INTERNAL("realtime", "received " + event.name() + " event");
                Bridge.getBus().post((Object)new NewCommentEvent(event.getConversationId(), event.getUserId()));
                break;
            }
            case CreateConversation: {
                IntercomLogger.INTERNAL("realtime", "received " + event.name() + " event");
                Bridge.getBus().post((Object)new CreateConversationEvent());
                break;
            }
            default: {
                IntercomLogger.INTERNAL("realtime", "unexpected event: " + event.name());
            }
        }
    }

    public void onConnect() {
        Bridge.getMetricsStore().increment(MetricType.NEXUS_CONNECTION_SUCCESS);
    }

    public void onConnectFailed() {
        Bridge.getMetricsStore().increment(MetricType.NEXUS_CONNECTION_FAILURE);
    }

    private static boolean isRealTime() {
        return Bridge.getIdentityStore().getAppConfig().isRealTime();
    }
}

