/*
 * Copyright 2017-present the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.koin.viewmodel.scope

import org.koin.core.annotation.KoinExperimentalAPI
import org.koin.core.annotation.KoinViewModelScopeApi
import org.koin.core.module.Module
import org.koin.dsl.ScopeDSL

/**
 * Declare a ViewModel scope section.
 *
 * ViewModels that need constructor injection from this scope must be declared inside this block.
 *
 * ```kotlin
 * viewModelScope {
 *     viewModel { MyViewModel(get()) }  // ViewModel with scoped dependency
 *     scoped { MyScopedDependency() }   // Scoped to ViewModel lifecycle
 * }
 * ```
 *
 * Requires `viewModelScopeFactory()` option to be enabled.
 *
 * @see KoinViewModelScopeApi for more details
 */
@KoinViewModelScopeApi
@KoinExperimentalAPI
fun Module.viewModelScope(scopeSet: ScopeDSL.() -> Unit) {
    val qualifier = ViewModelScopeArchetype
    ScopeDSL(qualifier, this).apply(scopeSet)
}
