/*
 * Decompiled with CFR 0.152.
 */
package org.koin.core.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.Koin;
import org.koin.core.annotation.KoinInternalApi;
import org.koin.core.definition.BeanDefinition;
import org.koin.core.definition.BeanDefinitionKt;
import org.koin.core.definition.Kind;
import org.koin.core.instance.InstanceContext;
import org.koin.core.instance.InstanceFactory;
import org.koin.core.instance.ScopedInstanceFactory;
import org.koin.core.instance.SingleInstanceFactory;
import org.koin.core.logger.Level;
import org.koin.core.logger.Logger;
import org.koin.core.module.Module;
import org.koin.core.module.ModuleKt;
import org.koin.core.parameter.ParametersHolder;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;
import org.koin.mp.KoinPlatformTools;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0016J\r\u0010\u0017\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0018J(\u0010\u0019\u001a\u00020\u00152\u001e\u0010\f\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\rj\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e`\u000fH\u0002JH\u0010\u001a\u001a\u00020\u0015\"\u0006\b\u0000\u0010\u001b\u0018\u00012\u0006\u0010\u001c\u001a\u0002H\u001b2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0012\b\u0002\u0010\u001f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030!0 2\b\b\u0002\u0010\"\u001a\u00020#H\u0081\b\u00a2\u0006\u0002\u0010$J\\\u0010%\u001a\u00020\u0015\"\u0006\b\u0000\u0010\u001b\u0018\u00012\u0006\u0010\u001c\u001a\u0002H\u001b2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0012\b\u0002\u0010\u001f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030!0 2\b\b\u0002\u0010\"\u001a\u00020#2\u0006\u0010&\u001a\u00020\u001e2\n\u0010'\u001a\u00060\u0007j\u0002`(H\u0081\b\u00a2\u0006\u0002\u0010)J\u0015\u0010*\u001a\u00020\u00152\u0006\u0010+\u001a\u00020,H\u0000\u00a2\u0006\u0002\b-J-\u0010.\u001a\b\u0012\u0004\u0012\u0002H\u001b0 \"\u0004\b\u0000\u0010\u001b2\n\u0010/\u001a\u0006\u0012\u0002\b\u00030!2\u0006\u00100\u001a\u000201H\u0000\u00a2\u0006\u0002\b2J\u0018\u00103\u001a\u00020\u00152\u0006\u00104\u001a\u0002052\u0006\u0010\"\u001a\u00020#H\u0002J#\u00106\u001a\u00020\u00152\f\u00107\u001a\b\u0012\u0004\u0012\u000205082\u0006\u0010\"\u001a\u00020#H\u0000\u00a2\u0006\u0002\b9J1\u0010:\u001a\b\u0012\u0002\b\u0003\u0018\u00010\t2\n\u0010/\u001a\u0006\u0012\u0002\b\u00030!2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010&\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b;J=\u0010<\u001a\u0004\u0018\u0001H\u001b\"\u0004\b\u0000\u0010\u001b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\n\u0010/\u001a\u0006\u0012\u0002\b\u00030!2\u0006\u0010&\u001a\u00020\u001e2\u0006\u00100\u001a\u000201H\u0000\u00a2\u0006\u0004\b=\u0010>J2\u0010?\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#2\n\u0010@\u001a\u00060\u0007j\u0002`\b2\n\u0010A\u001a\u0006\u0012\u0002\b\u00030\t2\b\b\u0002\u0010B\u001a\u00020#H\u0007J\u0006\u0010C\u001a\u00020DJ\u0010\u0010E\u001a\u00020\u00152\u0006\u00104\u001a\u000205H\u0002J\u001b\u0010F\u001a\u00020\u00152\f\u00107\u001a\b\u0012\u0004\u0012\u00020508H\u0000\u00a2\u0006\u0002\bGR\"\u0010\u0005\u001a\u0016\u0012\b\u0012\u00060\u0007j\u0002`\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR&\u0010\f\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\rj\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R%\u0010\u0010\u001a\u0016\u0012\b\u0012\u00060\u0007j\u0002`\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006H"}, d2={"Lorg/koin/core/registry/InstanceRegistry;", "", "_koin", "Lorg/koin/core/Koin;", "(Lorg/koin/core/Koin;)V", "_instances", "", "", "Lorg/koin/core/definition/IndexKey;", "Lorg/koin/core/instance/InstanceFactory;", "get_koin", "()Lorg/koin/core/Koin;", "eagerInstances", "Ljava/util/HashSet;", "Lorg/koin/core/instance/SingleInstanceFactory;", "Lkotlin/collections/HashSet;", "instances", "", "getInstances", "()Ljava/util/Map;", "close", "", "close$koin_core", "createAllEagerInstances", "createAllEagerInstances$koin_core", "createEagerInstances", "declareRootInstance", "T", "instance", "qualifier", "Lorg/koin/core/qualifier/Qualifier;", "secondaryTypes", "", "Lkotlin/reflect/KClass;", "allowOverride", "", "(Ljava/lang/Object;Lorg/koin/core/qualifier/Qualifier;Ljava/util/List;Z)V", "declareScopedInstance", "scopeQualifier", "scopeID", "Lorg/koin/core/scope/ScopeID;", "(Ljava/lang/Object;Lorg/koin/core/qualifier/Qualifier;Ljava/util/List;ZLorg/koin/core/qualifier/Qualifier;Ljava/lang/String;)V", "dropScopeInstances", "scope", "Lorg/koin/core/scope/Scope;", "dropScopeInstances$koin_core", "getAll", "clazz", "instanceContext", "Lorg/koin/core/instance/InstanceContext;", "getAll$koin_core", "loadModule", "module", "Lorg/koin/core/module/Module;", "loadModules", "modules", "", "loadModules$koin_core", "resolveDefinition", "resolveDefinition$koin_core", "resolveInstance", "resolveInstance$koin_core", "(Lorg/koin/core/qualifier/Qualifier;Lkotlin/reflect/KClass;Lorg/koin/core/qualifier/Qualifier;Lorg/koin/core/instance/InstanceContext;)Ljava/lang/Object;", "saveMapping", "mapping", "factory", "logWarning", "size", "", "unloadModule", "unloadModules", "unloadModules$koin_core", "koin-core"})
public final class InstanceRegistry {
    @NotNull
    private final Koin _koin;
    @NotNull
    private final Map<String, InstanceFactory<?>> _instances;
    @NotNull
    private final HashSet<SingleInstanceFactory<?>> eagerInstances;

    public InstanceRegistry(@NotNull Koin _koin) {
        Intrinsics.checkNotNullParameter((Object)_koin, (String)"_koin");
        this._koin = _koin;
        this._instances = KoinPlatformTools.INSTANCE.safeHashMap();
        this.eagerInstances = new HashSet();
    }

    @NotNull
    public final Koin get_koin() {
        return this._koin;
    }

    @NotNull
    public final Map<String, InstanceFactory<?>> getInstances() {
        return this._instances;
    }

    public final void loadModules$koin_core(@NotNull Set<Module> modules, boolean allowOverride) {
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        Iterable $this$forEach$iv = modules;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Module module = (Module)element$iv;
            boolean bl = false;
            this.loadModule(module, allowOverride);
            this.eagerInstances.addAll((Collection)module.getEagerInstances());
        }
    }

    public final void createAllEagerInstances$koin_core() {
        this.createEagerInstances(this.eagerInstances);
        this.eagerInstances.clear();
    }

    private final void loadModule(Module module, boolean allowOverride) {
        Map $this$forEach$iv = module.getMappings();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String mapping = (String)entry.getKey();
            InstanceFactory factory2 = (InstanceFactory)entry.getValue();
            InstanceRegistry.saveMapping$default(this, allowOverride, mapping, factory2, false, 8, null);
        }
    }

    @KoinInternalApi
    public final void saveMapping(boolean allowOverride, @NotNull String mapping, @NotNull InstanceFactory<?> factory2, boolean logWarning) {
        Logger this_$iv$iv;
        boolean $i$f$log;
        Level lvl$iv$iv;
        Logger this_$iv;
        String msg$iv;
        Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
        Intrinsics.checkNotNullParameter(factory2, (String)"factory");
        if (this._instances.containsKey(mapping)) {
            if (!allowOverride) {
                ModuleKt.overrideError(factory2, mapping);
            } else if (logWarning) {
                Logger logger = this._koin.getLogger();
                msg$iv = "(+) override index '" + mapping + "' -> '" + factory2.getBeanDefinition() + '\'';
                boolean $i$f$warn = false;
                Logger logger2 = this_$iv;
                lvl$iv$iv = Level.WARNING;
                $i$f$log = false;
                if (this_$iv$iv.isAt(lvl$iv$iv)) {
                    this_$iv$iv.display(lvl$iv$iv, msg$iv);
                }
            }
        }
        this_$iv = this._koin.getLogger();
        msg$iv = "(+) index '" + mapping + "' -> '" + factory2.getBeanDefinition() + '\'';
        boolean $i$f$debug = false;
        this_$iv$iv = this_$iv;
        lvl$iv$iv = Level.DEBUG;
        $i$f$log = false;
        if (this_$iv$iv.isAt(lvl$iv$iv)) {
            this_$iv$iv.display(lvl$iv$iv, msg$iv);
        }
        this._instances.put(mapping, factory2);
    }

    public static /* synthetic */ void saveMapping$default(InstanceRegistry instanceRegistry, boolean bl, String string, InstanceFactory instanceFactory, boolean bl2, int n, Object object) {
        if ((n & 8) != 0) {
            bl2 = true;
        }
        instanceRegistry.saveMapping(bl, string, instanceFactory, bl2);
    }

    private final void createEagerInstances(HashSet<SingleInstanceFactory<?>> eagerInstances) {
        if (!((Collection)eagerInstances).isEmpty()) {
            InstanceContext defaultContext = new InstanceContext(this._koin, this._koin.getScopeRegistry().getRootScope(), null, 4, null);
            Iterable $this$forEach$iv = eagerInstances;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SingleInstanceFactory factory2 = (SingleInstanceFactory)element$iv;
                boolean bl = false;
                factory2.get(defaultContext);
            }
        }
    }

    @Nullable
    public final InstanceFactory<?> resolveDefinition$koin_core(@NotNull KClass<?> clazz, @Nullable Qualifier qualifier, @NotNull Qualifier scopeQualifier) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)scopeQualifier, (String)"scopeQualifier");
        String indexKey = BeanDefinitionKt.indexKey(clazz, qualifier, scopeQualifier);
        return this._instances.get(indexKey);
    }

    @Nullable
    public final <T> T resolveInstance$koin_core(@Nullable Qualifier qualifier, @NotNull KClass<?> clazz, @NotNull Qualifier scopeQualifier, @NotNull InstanceContext instanceContext) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)scopeQualifier, (String)"scopeQualifier");
        Intrinsics.checkNotNullParameter((Object)instanceContext, (String)"instanceContext");
        InstanceFactory<?> instanceFactory = this.resolveDefinition$koin_core(clazz, qualifier, scopeQualifier);
        Object object = instanceFactory != null ? instanceFactory.get(instanceContext) : null;
        if (object == null) {
            object = null;
        }
        return (T)object;
    }

    /*
     * WARNING - void declaration
     */
    @PublishedApi
    public final /* synthetic */ <T> void declareScopedInstance(T instance, Qualifier qualifier, List<? extends KClass<?>> secondaryTypes, boolean allowOverride, Qualifier scopeQualifier, String scopeID) {
        ScopedInstanceFactory existingFactory;
        void kind$iv;
        Intrinsics.checkNotNullParameter(secondaryTypes, (String)"secondaryTypes");
        Intrinsics.checkNotNullParameter((Object)scopeQualifier, (String)"scopeQualifier");
        Intrinsics.checkNotNullParameter((Object)scopeID, (String)"scopeID");
        boolean $i$f$declareScopedInstance = false;
        Kind kind = Kind.Scoped;
        Intrinsics.needClassReification();
        Function2 definition$iv = new Function2<Scope, ParametersHolder, T>(instance){
            final /* synthetic */ T $instance;
            {
                this.$instance = $instance;
                super(2);
            }

            public final T invoke(@NotNull Scope $this$_createDefinition, @NotNull ParametersHolder it) {
                Intrinsics.checkNotNullParameter((Object)$this$_createDefinition, (String)"$this$_createDefinition");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$instance;
            }
        };
        boolean $i$f$_createDefinition22 = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        BeanDefinition def2 = new BeanDefinition(scopeQualifier, Reflection.getOrCreateKotlinClass(Object.class), qualifier, definition$iv, (Kind)kind$iv, secondaryTypes);
        String indexKey = BeanDefinitionKt.indexKey(def2.getPrimaryType(), def2.getQualifier(), def2.getScopeQualifier());
        InstanceFactory<?> $i$f$_createDefinition22 = this.getInstances().get(indexKey);
        ScopedInstanceFactory scopedInstanceFactory = existingFactory = $i$f$_createDefinition22 instanceof ScopedInstanceFactory ? (ScopedInstanceFactory)$i$f$_createDefinition22 : null;
        if (existingFactory != null) {
            Intrinsics.checkNotNull(instance, (String)"null cannot be cast to non-null type kotlin.Any");
            existingFactory.refreshInstance(scopeID, instance);
        } else {
            ScopedInstanceFactory factory2 = new ScopedInstanceFactory(def2);
            InstanceRegistry.saveMapping$default(this, allowOverride, indexKey, factory2, false, 8, null);
            Iterable $this$forEach$iv = def2.getSecondaryTypes();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KClass clazz = (KClass)element$iv;
                boolean bl = false;
                String index = BeanDefinitionKt.indexKey(clazz, def2.getQualifier(), def2.getScopeQualifier());
                InstanceRegistry.saveMapping$default(this, allowOverride, index, factory2, false, 8, null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ void declareScopedInstance$default(InstanceRegistry $this, Object instance, Qualifier qualifier, List secondaryTypes, boolean allowOverride, Qualifier scopeQualifier, String scopeID, int n, Object object) {
        ScopedInstanceFactory existingFactory;
        void kind$iv;
        if ((n & 2) != 0) {
            qualifier = null;
        }
        if ((n & 4) != 0) {
            secondaryTypes = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            allowOverride = true;
        }
        Intrinsics.checkNotNullParameter((Object)secondaryTypes, (String)"secondaryTypes");
        Intrinsics.checkNotNullParameter((Object)scopeQualifier, (String)"scopeQualifier");
        Intrinsics.checkNotNullParameter((Object)scopeID, (String)"scopeID");
        boolean $i$f$declareScopedInstance = false;
        Kind kind = Kind.Scoped;
        Intrinsics.needClassReification();
        Function2 definition$iv = new /* invalid duplicate definition of identical inner class */;
        boolean $i$f$_createDefinition22 = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        BeanDefinition def2 = new BeanDefinition(scopeQualifier, Reflection.getOrCreateKotlinClass(Object.class), qualifier, definition$iv, (Kind)kind$iv, secondaryTypes);
        String indexKey = BeanDefinitionKt.indexKey(def2.getPrimaryType(), def2.getQualifier(), def2.getScopeQualifier());
        InstanceFactory<?> $i$f$_createDefinition22 = $this.getInstances().get(indexKey);
        ScopedInstanceFactory scopedInstanceFactory = existingFactory = $i$f$_createDefinition22 instanceof ScopedInstanceFactory ? (ScopedInstanceFactory)$i$f$_createDefinition22 : null;
        if (existingFactory != null) {
            Intrinsics.checkNotNull((Object)instance, (String)"null cannot be cast to non-null type kotlin.Any");
            existingFactory.refreshInstance(scopeID, instance);
        } else {
            ScopedInstanceFactory factory2 = new ScopedInstanceFactory(def2);
            InstanceRegistry.saveMapping$default($this, allowOverride, indexKey, factory2, false, 8, null);
            Iterable $this$forEach$iv = def2.getSecondaryTypes();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KClass clazz = (KClass)element$iv;
                boolean bl = false;
                String index = BeanDefinitionKt.indexKey(clazz, def2.getQualifier(), def2.getScopeQualifier());
                InstanceRegistry.saveMapping$default($this, allowOverride, index, factory2, false, 8, null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @PublishedApi
    public final /* synthetic */ <T> void declareRootInstance(T instance, Qualifier qualifier, List<? extends KClass<?>> secondaryTypes, boolean allowOverride) {
        void kind$iv;
        Intrinsics.checkNotNullParameter(secondaryTypes, (String)"secondaryTypes");
        boolean $i$f$declareRootInstance = false;
        Qualifier rootQualifier = this.get_koin().getScopeRegistry().getRootScope().getScopeQualifier();
        Kind kind = Kind.Scoped;
        Intrinsics.needClassReification();
        Function2 definition$iv = new Function2<Scope, ParametersHolder, T>(instance){
            final /* synthetic */ T $instance;
            {
                this.$instance = $instance;
                super(2);
            }

            public final T invoke(@NotNull Scope $this$_createDefinition, @NotNull ParametersHolder it) {
                Intrinsics.checkNotNullParameter((Object)$this$_createDefinition, (String)"$this$_createDefinition");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$instance;
            }
        };
        boolean $i$f$_createDefinition = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        BeanDefinition def2 = new BeanDefinition(rootQualifier, Reflection.getOrCreateKotlinClass(Object.class), qualifier, definition$iv, (Kind)kind$iv, secondaryTypes);
        SingleInstanceFactory factory2 = new SingleInstanceFactory(def2);
        String indexKey = BeanDefinitionKt.indexKey(def2.getPrimaryType(), def2.getQualifier(), def2.getScopeQualifier());
        InstanceRegistry.saveMapping$default(this, allowOverride, indexKey, factory2, false, 8, null);
        Iterable $this$forEach$iv = def2.getSecondaryTypes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KClass clazz = (KClass)element$iv;
            boolean bl = false;
            String index = BeanDefinitionKt.indexKey(clazz, def2.getQualifier(), def2.getScopeQualifier());
            InstanceRegistry.saveMapping$default(this, allowOverride, index, factory2, false, 8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ void declareRootInstance$default(InstanceRegistry $this, Object instance, Qualifier qualifier, List secondaryTypes, boolean allowOverride, int n, Object object) {
        void kind$iv;
        if ((n & 2) != 0) {
            qualifier = null;
        }
        if ((n & 4) != 0) {
            secondaryTypes = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            allowOverride = true;
        }
        Intrinsics.checkNotNullParameter((Object)secondaryTypes, (String)"secondaryTypes");
        boolean $i$f$declareRootInstance = false;
        Qualifier rootQualifier = $this.get_koin().getScopeRegistry().getRootScope().getScopeQualifier();
        Kind kind = Kind.Scoped;
        Intrinsics.needClassReification();
        Function2 definition$iv = new /* invalid duplicate definition of identical inner class */;
        boolean $i$f$_createDefinition = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        BeanDefinition def2 = new BeanDefinition(rootQualifier, Reflection.getOrCreateKotlinClass(Object.class), qualifier, definition$iv, (Kind)kind$iv, secondaryTypes);
        SingleInstanceFactory factory2 = new SingleInstanceFactory(def2);
        String indexKey = BeanDefinitionKt.indexKey(def2.getPrimaryType(), def2.getQualifier(), def2.getScopeQualifier());
        InstanceRegistry.saveMapping$default($this, allowOverride, indexKey, factory2, false, 8, null);
        Iterable $this$forEach$iv = def2.getSecondaryTypes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KClass clazz = (KClass)element$iv;
            boolean bl = false;
            String index = BeanDefinitionKt.indexKey(clazz, def2.getQualifier(), def2.getScopeQualifier());
            InstanceRegistry.saveMapping$default($this, allowOverride, index, factory2, false, 8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void dropScopeInstances$koin_core(@NotNull Scope scope) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Iterable $this$filterIsInstance$iv = this._instances.values();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ScopedInstanceFactory)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ScopedInstanceFactory factory2 = (ScopedInstanceFactory)element$iv;
            boolean bl = false;
            factory2.drop(scope);
        }
    }

    public final void close$koin_core() {
        Map<String, InstanceFactory<?>> $this$forEach$iv = this._instances;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, InstanceFactory<?>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, InstanceFactory<?>> element$iv;
            Map.Entry<String, InstanceFactory<?>> entry = element$iv = iterator.next();
            boolean bl = false;
            String key = entry.getKey();
            InstanceFactory<?> factory2 = entry.getValue();
            factory2.dropAll();
        }
        this._instances.clear();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T> List<T> getAll$koin_core(@NotNull KClass<?> clazz, @NotNull InstanceContext instanceContext) {
        void $this$mapTo$iv$iv;
        InstanceFactory factory2;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)instanceContext, (String)"instanceContext");
        Iterable $this$filter$iv = this._instances.values();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            factory2 = (InstanceFactory)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)factory2.getBeanDefinition().getScopeQualifier(), (Object)instanceContext.getScope().getScopeQualifier())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            factory2 = (InstanceFactory)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual(factory2.getBeanDefinition().getPrimaryType(), clazz) || factory2.getBeanDefinition().getSecondaryTypes().contains(clazz))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            factory2 = (InstanceFactory)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.get(instanceContext));
        }
        return (List)destination$iv$iv;
    }

    public final void unloadModules$koin_core(@NotNull Set<Module> modules) {
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        Iterable $this$forEach$iv = modules;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Module it = (Module)element$iv;
            boolean bl = false;
            this.unloadModule(it);
        }
    }

    private final void unloadModule(Module module) {
        Set<String> set = module.getMappings().keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"module.mappings.keys");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String mapping = (String)element$iv;
            boolean bl = false;
            if (!this._instances.containsKey(mapping)) continue;
            InstanceFactory<?> instanceFactory = this._instances.get(mapping);
            if (instanceFactory != null) {
                instanceFactory.dropAll();
            }
            this._instances.remove(mapping);
        }
    }

    public final int size() {
        return this._instances.size();
    }
}

