/*
 * Decompiled with CFR 0.152.
 */
package org.koin.core.instance;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.koin.core.Koin;
import org.koin.core.definition.BeanDefinition;
import org.koin.core.error.InstanceCreationException;
import org.koin.core.instance.InstanceContext;
import org.koin.core.logger.Level;
import org.koin.core.parameter.DefinitionParameters;
import org.koin.mp.KoinPlatformTools;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u0000 \u0013*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u0013B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\n\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH&J\u0015\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00020\fH&\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0011\u001a\u00020\u0012H&R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lorg/koin/core/instance/InstanceFactory;", "T", "", "_koin", "Lorg/koin/core/Koin;", "beanDefinition", "Lorg/koin/core/definition/BeanDefinition;", "(Lorg/koin/core/Koin;Lorg/koin/core/definition/BeanDefinition;)V", "getBeanDefinition", "()Lorg/koin/core/definition/BeanDefinition;", "create", "context", "Lorg/koin/core/instance/InstanceContext;", "(Lorg/koin/core/instance/InstanceContext;)Ljava/lang/Object;", "drop", "", "get", "isCreated", "", "Companion", "koin-core"})
public abstract class InstanceFactory<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Koin _koin;
    @NotNull
    private final BeanDefinition<T> beanDefinition;
    @NotNull
    public static final String ERROR_SEPARATOR = "\n\t";

    public InstanceFactory(@NotNull Koin _koin, @NotNull BeanDefinition<T> beanDefinition2) {
        Intrinsics.checkNotNullParameter((Object)_koin, (String)"_koin");
        Intrinsics.checkNotNullParameter(beanDefinition2, (String)"beanDefinition");
        this._koin = _koin;
        this.beanDefinition = beanDefinition2;
    }

    @NotNull
    public final BeanDefinition<T> getBeanDefinition() {
        return this.beanDefinition;
    }

    public abstract T get(@NotNull InstanceContext var1);

    public T create(@NotNull InstanceContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this._koin.getLogger().isAt(Level.DEBUG)) {
            this._koin.getLogger().debug(Intrinsics.stringPlus((String)"| create instance for ", this.beanDefinition));
        }
        try {
            DefinitionParameters parameters = context.getParameters();
            context.getScope().addParameters(parameters);
            Object value = this.beanDefinition.getDefinition().invoke((Object)context.getScope(), (Object)parameters);
            context.getScope().clearParameters();
            return (T)value;
        }
        catch (Exception e) {
            String stack = KoinPlatformTools.INSTANCE.getStackTrace(e);
            this._koin.getLogger().error("Instance creation error : could not create instance for " + this.beanDefinition + ": " + stack);
            throw new InstanceCreationException(Intrinsics.stringPlus((String)"Could not create instance for ", this.beanDefinition), e);
        }
    }

    public abstract boolean isCreated();

    public abstract void drop();

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/koin/core/instance/InstanceFactory$Companion;", "", "()V", "ERROR_SEPARATOR", "", "koin-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

