/*
 * Decompiled with CFR 0.152.
 */
package org.koin.compose.module;

import androidx.compose.runtime.RememberObserver;
import androidx.compose.runtime.internal.StabilityInferred;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.koin.core.Koin;
import org.koin.core.annotation.KoinExperimentalAPI;
import org.koin.core.annotation.KoinInternalApi;
import org.koin.core.module.Module;

@KoinExperimentalAPI
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0013H\u0016J\b\u0010\u0016\u001a\u00020\u0013H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lorg/koin/compose/module/CompositionKoinModuleLoader;", "Landroidx/compose/runtime/RememberObserver;", "modules", "", "Lorg/koin/core/module/Module;", "koin", "Lorg/koin/core/Koin;", "unloadOnForgotten", "", "unloadOnAbandoned", "(Ljava/util/List;Lorg/koin/core/Koin;ZZ)V", "getKoin", "()Lorg/koin/core/Koin;", "getModules", "()Ljava/util/List;", "getUnloadOnAbandoned", "()Z", "getUnloadOnForgotten", "onAbandoned", "", "onForgotten", "onRemembered", "unloadModules", "koin-compose"})
@KoinInternalApi
@StabilityInferred(parameters=0)
public final class CompositionKoinModuleLoader
implements RememberObserver {
    @NotNull
    private final List<Module> modules;
    @NotNull
    private final Koin koin;
    private final boolean unloadOnForgotten;
    private final boolean unloadOnAbandoned;
    public static final int $stable = 8;

    public CompositionKoinModuleLoader(@NotNull List<Module> modules, @NotNull Koin koin, boolean unloadOnForgotten, boolean unloadOnAbandoned) {
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        Intrinsics.checkNotNullParameter((Object)koin, (String)"koin");
        this.modules = modules;
        this.koin = koin;
        this.unloadOnForgotten = unloadOnForgotten;
        this.unloadOnAbandoned = unloadOnAbandoned;
        this.koin.getLogger().debug(this + " -> load modules");
        Koin.loadModules$default((Koin)this.koin, this.modules, (boolean)false, (boolean)false, (int)6, null);
    }

    @NotNull
    public final List<Module> getModules() {
        return this.modules;
    }

    @NotNull
    public final Koin getKoin() {
        return this.koin;
    }

    public final boolean getUnloadOnForgotten() {
        return this.unloadOnForgotten;
    }

    public final boolean getUnloadOnAbandoned() {
        return this.unloadOnAbandoned;
    }

    public void onRemembered() {
    }

    public void onForgotten() {
        if (this.unloadOnForgotten) {
            this.unloadModules();
        }
    }

    public void onAbandoned() {
        if (this.unloadOnAbandoned) {
            this.unloadModules();
        }
    }

    private final void unloadModules() {
        this.koin.getLogger().debug(this + " -> unload modules");
        this.koin.unloadModules(this.modules);
    }
}

