/*
 * Copyright 2017-2021 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.koin.androidx.fragment.koin

import androidx.fragment.app.FragmentFactory
import org.koin.androidx.fragment.android.KoinFragmentFactory
import org.koin.core.KoinApplication
import org.koin.core.KoinExperimentalAPI
import org.koin.dsl.module

private val fragmentFactoryModule = module {
    single<FragmentFactory> { KoinFragmentFactory() }
}

/**
 * Setup the KoinFragmentFactory instance
 */
@KoinExperimentalAPI
fun KoinApplication.fragmentFactory() {
    koin.loadModules(listOf(fragmentFactoryModule))
}