/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.vertices.utility;

import io.improbable.keanu.annotation.ExportVertexToPythonBindings;
import io.improbable.keanu.tensor.bool.BooleanTensor;
import io.improbable.keanu.vertices.LoadVertexParam;
import io.improbable.keanu.vertices.NonProbabilistic;
import io.improbable.keanu.vertices.SaveVertexParam;
import io.improbable.keanu.vertices.Vertex;
import io.improbable.keanu.vertices.VertexLabel;
import io.improbable.keanu.vertices.bool.BooleanVertex;
import io.improbable.keanu.vertices.utility.GraphAssertionException;

public class AssertVertex
extends BooleanVertex
implements NonProbabilistic<BooleanTensor> {
    private static final String PREDICATE_NAME = "predicate";
    private static final String ERROR_MESSAGE_NAME = "error";
    private final Vertex<? extends BooleanTensor> predicate;
    private final String errorMessage;

    @ExportVertexToPythonBindings
    public AssertVertex(@LoadVertexParam(value="predicate") Vertex<? extends BooleanTensor> predicate, @LoadVertexParam(value="error") String errorMessage) {
        super(predicate.getShape());
        this.predicate = predicate;
        this.errorMessage = errorMessage;
        this.setParents(predicate);
    }

    public AssertVertex(Vertex<? extends BooleanTensor> predicate) {
        this(predicate, "");
    }

    @Override
    public BooleanTensor calculate() {
        VertexLabel label;
        return AssertVertex.assertion(this.predicate.getValue(), this.errorMessage, (label = this.getLabel()) != null ? label.getQualifiedName() : null);
    }

    public static BooleanTensor assertion(BooleanTensor predicateValue, String errorMessage, String labelQualifiedName) {
        if (!predicateValue.allTrue()) {
            throw new GraphAssertionException(AssertVertex.buildAssertMessage(errorMessage, labelQualifiedName));
        }
        return predicateValue;
    }

    private static String buildAssertMessage(String errorMessage, String labelQualifiedName) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AssertVertex");
        if (labelQualifiedName != null) {
            stringBuilder.append(" (" + labelQualifiedName + ")");
        }
        if (!errorMessage.equals("")) {
            stringBuilder.append(": " + errorMessage);
        }
        return stringBuilder.toString();
    }

    @SaveVertexParam(value="predicate")
    public Vertex<? extends BooleanTensor> getPredicate() {
        return this.predicate;
    }

    @SaveVertexParam(value="error")
    public String getErrorMessage() {
        return this.errorMessage;
    }
}

