/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.vertices.model;

import io.improbable.keanu.tensor.Tensor;
import io.improbable.keanu.tensor.dbl.DoubleTensor;
import io.improbable.keanu.vertices.NonSaveableVertex;
import io.improbable.keanu.vertices.Vertex;
import io.improbable.keanu.vertices.VertexLabel;
import io.improbable.keanu.vertices.dbl.DoubleVertex;
import io.improbable.keanu.vertices.model.ModelVertex;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class LambdaModelVertex
extends DoubleVertex
implements ModelVertex<DoubleTensor>,
NonSaveableVertex {
    private Map<VertexLabel, Vertex<? extends Tensor>> inputs;
    private Map<VertexLabel, Vertex<? extends Tensor>> outputs;
    private Consumer<Map<VertexLabel, Vertex<? extends Tensor>>> executor;
    private Supplier<Map<VertexLabel, Vertex<? extends Tensor>>> extractOutput;
    private boolean hasValue;

    public LambdaModelVertex(Map<VertexLabel, Vertex<? extends Tensor>> inputs, Consumer<Map<VertexLabel, Vertex<? extends Tensor>>> executor, Supplier<Map<VertexLabel, Vertex<? extends Tensor>>> updateValues) {
        super(Tensor.SCALAR_SHAPE);
        this.inputs = inputs;
        this.outputs = Collections.emptyMap();
        this.executor = executor;
        this.extractOutput = updateValues;
        this.hasValue = false;
        this.setParents(inputs.values());
    }

    public static LambdaModelVertex createFromProcess(Map<VertexLabel, Vertex<? extends Tensor>> inputs, String command, Supplier<Map<VertexLabel, Vertex<? extends Tensor>>> updateValues) {
        return new LambdaModelVertex(inputs, i -> {
            try {
                Process cmd = Runtime.getRuntime().exec(command);
                cmd.waitFor();
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException("Failed during execution of the process. " + e);
            }
        }, updateValues);
    }

    @Override
    public DoubleTensor calculate() {
        this.run();
        this.updateValues();
        return DoubleTensor.scalar(0.0);
    }

    @Override
    public boolean hasValue() {
        return this.hasValue;
    }

    @Override
    public void run() {
        this.executor.accept(this.inputs);
        this.hasValue = true;
    }

    @Override
    public Map<VertexLabel, Vertex<? extends Tensor>> updateValues() {
        this.outputs = this.extractOutput.get();
        return this.outputs;
    }

    @Override
    public boolean hasCalculated() {
        return this.hasValue();
    }

    @Override
    public <U, T extends Tensor<U, T>> T getModelOutputValue(VertexLabel label) {
        return (T)this.outputs.get(label).getValue();
    }
}

