/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.vertices.intgr.probabilistic;

import io.improbable.keanu.KeanuRandom;
import io.improbable.keanu.annotation.ExportVertexToPythonBindings;
import io.improbable.keanu.distributions.discrete.Poisson;
import io.improbable.keanu.tensor.NumberTensor;
import io.improbable.keanu.tensor.Tensor;
import io.improbable.keanu.tensor.TensorShapeValidation;
import io.improbable.keanu.tensor.dbl.DoubleTensor;
import io.improbable.keanu.tensor.intgr.IntegerTensor;
import io.improbable.keanu.vertices.LoadShape;
import io.improbable.keanu.vertices.LoadVertexParam;
import io.improbable.keanu.vertices.LogProbGraph;
import io.improbable.keanu.vertices.LogProbGraphSupplier;
import io.improbable.keanu.vertices.SamplableWithManyScalars;
import io.improbable.keanu.vertices.SaveVertexParam;
import io.improbable.keanu.vertices.Vertex;
import io.improbable.keanu.vertices.dbl.DoublePlaceholderVertex;
import io.improbable.keanu.vertices.dbl.DoubleVertex;
import io.improbable.keanu.vertices.dbl.nonprobabilistic.CastToDoubleVertex;
import io.improbable.keanu.vertices.dbl.nonprobabilistic.ConstantDoubleVertex;
import io.improbable.keanu.vertices.intgr.IntegerPlaceholderVertex;
import io.improbable.keanu.vertices.intgr.IntegerVertex;
import io.improbable.keanu.vertices.intgr.probabilistic.ProbabilisticInteger;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class PoissonVertex
extends IntegerVertex
implements ProbabilisticInteger,
SamplableWithManyScalars<IntegerTensor>,
LogProbGraphSupplier {
    private final DoubleVertex mu;
    private static final String MU_NAME = "mu";

    public PoissonVertex(@LoadShape long[] shape, @LoadVertexParam(value="mu") DoubleVertex mu) {
        super(shape);
        TensorShapeValidation.checkTensorsMatchNonLengthOneShapeOrAreLengthOne(shape, new long[][]{mu.getShape()});
        this.mu = mu;
        this.setParents(mu);
    }

    public PoissonVertex(long[] shape, double mu) {
        this(shape, new ConstantDoubleVertex(mu));
    }

    @ExportVertexToPythonBindings
    public PoissonVertex(DoubleVertex mu) {
        this(mu.getShape(), mu);
    }

    public PoissonVertex(Vertex<? extends NumberTensor> mu) {
        this(mu.getShape(), new CastToDoubleVertex<NumberTensor>(mu));
    }

    public PoissonVertex(double mu) {
        this(Tensor.SCALAR_SHAPE, new ConstantDoubleVertex(mu));
    }

    @SaveVertexParam(value="mu")
    public DoubleVertex getMu() {
        return this.mu;
    }

    @Override
    public double logProb(IntegerTensor value) {
        return (Double)Poisson.withParameters((DoubleTensor)this.mu.getValue()).logProb(value).sum();
    }

    @Override
    public LogProbGraph logProbGraph() {
        IntegerPlaceholderVertex valuePlaceholder = new IntegerPlaceholderVertex(this.getShape());
        DoublePlaceholderVertex muPlaceholder = new DoublePlaceholderVertex(this.mu.getShape());
        return LogProbGraph.builder().input(this, valuePlaceholder).input(this.mu, muPlaceholder).logProbOutput(Poisson.logProbOutput(valuePlaceholder, muPlaceholder)).build();
    }

    @Override
    public Map<Vertex, DoubleTensor> dLogProb(IntegerTensor value, Set<? extends Vertex> withRespectTo) {
        return Collections.emptyMap();
    }

    @Override
    public IntegerTensor sampleWithShape(long[] shape, KeanuRandom random) {
        return (IntegerTensor)Poisson.withParameters((DoubleTensor)this.mu.getValue()).sample(shape, random);
    }
}

