/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.vertices.intgr.nonprobabilistic.operators.unary;

import io.improbable.keanu.annotation.ExportVertexToPythonBindings;
import io.improbable.keanu.tensor.Tensor;
import io.improbable.keanu.tensor.TensorShapeValidation;
import io.improbable.keanu.tensor.intgr.IntegerTensor;
import io.improbable.keanu.vertices.LoadVertexParam;
import io.improbable.keanu.vertices.SaveVertexParam;
import io.improbable.keanu.vertices.intgr.IntegerVertex;
import io.improbable.keanu.vertices.intgr.nonprobabilistic.operators.unary.IntegerUnaryOpVertex;

public class IntegerTakeVertex
extends IntegerUnaryOpVertex {
    private static final String INDEX_NAME = "index";
    private final long[] index;

    @ExportVertexToPythonBindings
    public IntegerTakeVertex(@LoadVertexParam(value="inputVertex") IntegerVertex inputVertex, long ... index) {
        super(Tensor.SCALAR_SHAPE, inputVertex);
        this.index = index;
        TensorShapeValidation.checkIndexIsValid(inputVertex.getShape(), index);
    }

    @Override
    protected IntegerTensor op(IntegerTensor value) {
        return IntegerTensor.scalar((Integer)value.getValue(this.index));
    }

    @SaveVertexParam(value="index")
    public long[] getIndex() {
        return this.index;
    }
}

