/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.vertices.intgr.nonprobabilistic.operators.unary;

import io.improbable.keanu.annotation.ExportVertexToPythonBindings;
import io.improbable.keanu.tensor.TensorShape;
import io.improbable.keanu.tensor.intgr.IntegerTensor;
import io.improbable.keanu.vertices.LoadVertexParam;
import io.improbable.keanu.vertices.SaveVertexParam;
import io.improbable.keanu.vertices.intgr.IntegerVertex;
import io.improbable.keanu.vertices.intgr.nonprobabilistic.operators.unary.IntegerUnaryOpVertex;

public class IntegerSumVertex
extends IntegerUnaryOpVertex {
    private static final String DIMENSIONS_NAME = "overDimensions";
    private final int[] overDimensions;

    @ExportVertexToPythonBindings
    public IntegerSumVertex(@LoadVertexParam(value="inputVertex") IntegerVertex inputVertex, @LoadVertexParam(value="overDimensions") int[] overDimensions) {
        super(TensorShape.getReductionResultShape(inputVertex.getShape(), overDimensions), inputVertex);
        this.overDimensions = overDimensions;
    }

    public IntegerSumVertex(IntegerVertex inputVertex) {
        super(new long[0], inputVertex);
        this.overDimensions = null;
    }

    @Override
    protected IntegerTensor op(IntegerTensor value) {
        if (this.overDimensions == null) {
            return IntegerTensor.scalar((Integer)value.sum());
        }
        return (IntegerTensor)value.sum(this.overDimensions);
    }

    @SaveVertexParam(value="overDimensions")
    public int[] getOverDimensions() {
        return this.overDimensions;
    }
}

