/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.vertices.intgr.nonprobabilistic.operators.unary;

import io.improbable.keanu.annotation.ExportVertexToPythonBindings;
import io.improbable.keanu.tensor.TensorShape;
import io.improbable.keanu.tensor.intgr.IntegerTensor;
import io.improbable.keanu.vertices.LoadVertexParam;
import io.improbable.keanu.vertices.SaveVertexParam;
import io.improbable.keanu.vertices.intgr.IntegerVertex;
import io.improbable.keanu.vertices.intgr.nonprobabilistic.operators.unary.IntegerUnaryOpVertex;

public class IntegerSliceVertex
extends IntegerUnaryOpVertex {
    private static final String DIMENSION_NAME = "dimension";
    private static final String INDEX_NAME = "index";
    private final int dimension;
    private final long index;

    @ExportVertexToPythonBindings
    public IntegerSliceVertex(@LoadVertexParam(value="inputVertex") IntegerVertex inputVertex, @LoadVertexParam(value="dimension") int dimension, @LoadVertexParam(value="index") long index) {
        super(TensorShape.removeDimension(dimension, inputVertex.getShape()), inputVertex);
        this.dimension = dimension;
        this.index = index;
    }

    @Override
    protected IntegerTensor op(IntegerTensor value) {
        return (IntegerTensor)value.slice(this.dimension, this.index);
    }

    @SaveVertexParam(value="dimension")
    public int getDimension() {
        return this.dimension;
    }

    @SaveVertexParam(value="index")
    public long getIndex() {
        return this.index;
    }
}

