/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.vertices.intgr.nonprobabilistic.operators.binary;

import io.improbable.keanu.tensor.TensorShapeValidation;
import io.improbable.keanu.tensor.intgr.IntegerTensor;
import io.improbable.keanu.vertices.NonProbabilistic;
import io.improbable.keanu.vertices.SaveVertexParam;
import io.improbable.keanu.vertices.VertexBinaryOp;
import io.improbable.keanu.vertices.intgr.IntegerVertex;

public abstract class IntegerBinaryOpVertex
extends IntegerVertex
implements NonProbabilistic<IntegerTensor>,
VertexBinaryOp<IntegerVertex, IntegerVertex> {
    protected final IntegerVertex left;
    protected final IntegerVertex right;
    protected static final String LEFT_NAME = "left";
    protected static final String RIGHT_NAME = "right";

    public IntegerBinaryOpVertex(IntegerVertex left, IntegerVertex right) {
        this(TensorShapeValidation.checkHasOneNonLengthOneShapeOrAllLengthOne(left.getShape(), right.getShape()), left, right);
    }

    public IntegerBinaryOpVertex(long[] shape, IntegerVertex left, IntegerVertex right) {
        super(shape);
        this.left = left;
        this.right = right;
        this.setParents(left, right);
    }

    @Override
    public IntegerTensor calculate() {
        return this.op((IntegerTensor)this.left.getValue(), (IntegerTensor)this.right.getValue());
    }

    protected abstract IntegerTensor op(IntegerTensor var1, IntegerTensor var2);

    @Override
    @SaveVertexParam(value="left")
    public IntegerVertex getLeft() {
        return this.left;
    }

    @Override
    @SaveVertexParam(value="right")
    public IntegerVertex getRight() {
        return this.right;
    }
}

