/*
 * Decompiled with CFR 0.152.
 */
package io.improbable.keanu.vertices.intgr.nonprobabilistic.operators.binary;

import io.improbable.keanu.tensor.TensorShapeValidation;
import io.improbable.keanu.tensor.intgr.IntegerTensor;
import io.improbable.keanu.vertices.NonProbabilistic;
import io.improbable.keanu.vertices.NonSaveableVertex;
import io.improbable.keanu.vertices.Vertex;
import io.improbable.keanu.vertices.intgr.IntegerVertex;
import java.util.function.BiFunction;

public class IntegerBinaryOpLambda<A, B>
extends IntegerVertex
implements NonProbabilistic<IntegerTensor>,
NonSaveableVertex {
    protected final Vertex<A> left;
    protected final Vertex<B> right;
    protected final BiFunction<A, B, IntegerTensor> op;

    public IntegerBinaryOpLambda(long[] shape, Vertex<A> left, Vertex<B> right, BiFunction<A, B, IntegerTensor> op) {
        super(shape);
        this.left = left;
        this.right = right;
        this.op = op;
        this.setParents(left, right);
    }

    public IntegerBinaryOpLambda(Vertex<A> left, Vertex<B> right, BiFunction<A, B, IntegerTensor> op) {
        this(TensorShapeValidation.checkHasOneNonLengthOneShapeOrAllLengthOne(left.getShape(), right.getShape()), left, right, op);
    }

    @Override
    public IntegerTensor calculate() {
        return this.op.apply(this.left.getValue(), this.right.getValue());
    }
}

